<div class="row">

    <div class="col-lg-12 col-md-12 col-sm-12">

        <div class="card">
            <div class="card-body">
                <div class="filter-wrapper bg-gray p-2 rounded text-left m-lg-0 m-md-0 ms-0 d-flex align-items-center justify-content-start flex-lg-nowrap flex-sm-wrap  flex-wrap mb-3 gap-2">
                    <input wire:model.debounce.300ms="search" type="text" class="form-control mr-lg-2" placeholder="Search products...">

                    <select wire:model="orderBy" class="form-select ml-2 mr-lg-2 mt-lg-0 mt-sm-2 mt-2" id="grid-state">
                        <option value="id">ID</option>
                        <option value="name">Name</option>
                        <option value="price">Price</option>
                        <option value="size">size</option>
                        <option value="created_at">Sign Up Date</option>
                    </select>

                    <select wire:model="category" class="form-select ml-2 mr-lg-2  mt-lg-0 mt-sm-2  mt-2" id="grid-state">
                        <option value="0">all roles</option>
                        <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($category->id); ?>"><?php echo e($category->name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>

                    <select wire:model="orderAsc" class="form-select ml-2 mr-lg-2  mt-lg-0 mt-sm-2  mt-2" id="grid-state">
                        <option value="1">Ascending</option>
                        <option value="0">Descending</option>
                    </select>


                    <select wire:model="perPage" class="form-select ml-2  mt-lg-0 mt-sm-2  mt-2" id="grid-state">
                        <option>10</option>
                        <option>25</option>
                        <option>50</option>
                        <option>100</option>
                    </select>

                </div>
            </div>
        </div>
    </div>


    <div class="col-lg-12 col-md-12 col-sm-12 mt-2">

        <div class="card">
            <div class="card-body">

                <div class="table-responsive">
                    <table class="table table-vcenter card-table">
                        <thead>
                        <tr>
                            <th>id</th>
                            <th>name</th>
                            <th>image</th>
                            <th>category</th>
                            <th>quantity</th>
                            <th>sales count</th>
                            <th>price/usd</th>
                            <th>created at</th>
                            <th>updated at</th>
                            <th>Actions</th>
                        </tr>
                        </thead>
                        <tbody>


                        <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($product->id); ?></td>

                                <td><?php echo e($product->name); ?></td>
                                <td>
                                        <img width="80" src="<?php echo e(asset($product->image)); ?>">
                                </td>
                                <td><?php echo e($product->category->name); ?></td>
                                <td><?php echo e($product->quantity); ?></td>
                                <td><?php echo e($product->sales_count); ?></td>
                                <td><?php echo e($product->price); ?> usd</td>

                                <td><?php echo e($product->created_at->diffForHumans()); ?></td>
                                <td><?php echo e($product->updated_at->diffForHumans()); ?></td>
                                <td>


                                    <button type="button"  class="btn btn-ghost-success "
                                            onclick="edit('<?php echo e($product->id); ?>')">
                                        Edit
                                    </button>


                                    <button type="button"
                                            onclick="deleteRecord('<?php echo e(route("admin.products.destroy",["product"=>$product->id])); ?>')"
                                            class="btn btn-ghost-danger">
                                        Delete
                                    </button>




                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                        </tbody>
                    </table>

                </div>
                <div class="row">
                    <div class="pagination">
                        <?php echo $products->links(); ?>

                    </div>
                </div>
            </div>

        </div>
    </div>
</div>
<?php /**PATH D:\my projects\laravel\sanam\resources\views/livewire/products-table.blade.php ENDPATH**/ ?>