<?php $__env->startSection('styles'); ?>
<style>
    .counter{
        background-color: #FAF8F4;

    }
    .counter button{
        background-color: #CC7546;
        border: none;
        color:#fff;
        width: 50px;
        height: 50px;
        font-size: 30px;
        display: flex;
        justify-content: center;
        font-weight: bold;
    }
    .counter span{
        font-size: 26px;

    }
    .btn-add{
        background-color: #3C3C39;
        border: none;

        color:#fff;
        padding: 10px 40px;
        height: 50px;
        font-size: 16px;
    }
    .bg-sugar{
        background-color: #FAF8F4;
        padding: 10px;
    }
    .btn-wishlist{
        background-color: transparent;
        border: none;
        color:#000;

        height: 50px;
        font-size: 16px;
    }
    .size-card{
        display: inline-block;
        padding: 10px 20px;
        border: 1px solid #BEBEBE;
        width:auto;
        margin-right : 10px;
        cursor:pointer;
    }
    .size-card.disabled{
        background-color: #F0F0F0;
    }
    .size-card.selected{
        border: 1px solid #CC7546;
    }

    .btn-out-stock{
        color:#fff;
        padding: 10px 40px;
        height: 50px;
        width: 100%;
        font-size: 16px;
        background-color: #A80000;
    }


</style>

<?php $__env->stopSection(); ?>


<?php $__env->startSection('page'); ?>

    <?php echo $__env->make('front-component.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <br>

    <section class="product details">
        <div class="container">
            <div class="row mt-3">
                <div class="col-lg-5 col-md-12 col-sm-12">
                    <div class="row">
                        <div class="col-lg-12 col-md-12 col-sm-12">
                            <img src="<?php echo e(asset($product->image)); ?>" width="100%">
                        </div>

                        <?php $__currentLoopData = $product->images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-lg-3 col-md-3 col-sm-3 col-3 mt-1">
                            <img src="<?php echo e(asset($image->image)); ?>" width="100%">
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    </div>
                </div>

                <div class="col-lg-7 col-md-12 col-sm-12">
                    <h1 class="text-start" style="font-weight: bold;font-size: 30px"> <?php echo e($product->name); ?> </h1>
                    <?php if($product->offer != null): ?>
                          <p style="font-size: 24px"> <?php echo e($product->redable_old_offer); ?>   <del> <?php echo e($product->redable_price); ?>   </del> </p>
                    <?php else: ?>
                        <p style="font-size: 24px"> <?php echo e($product->redable_price); ?>    </p>



                    <?php endif; ?>

                    <?php if(count($product->sizes) > 0 ): ?>
                    <p style="font-weight: bold;font-size: 14px"> Size* </p>
                    <div class="row">
                        <?php $__currentLoopData = $product->sizes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $size): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div <?php if($size->quantity != 0 ): ?> onclick="selectSize('<?php echo e($size->id); ?>','<?php echo e($size->size); ?>')" <?php endif; ?> id="s-<?php echo e($size->id); ?>" class="size-card <?php if($size->quantity ==0): ?> disabled <?php endif; ?>">
                                    <?php echo e($size->size); ?>

                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                    <?php endif; ?>
                    <br>


                    <div class="row bg-sugar">

                        <?php if($product->quantity != 0): ?>
                        <div class="col-lg-4 col-md-4 col-sm-4 col">
                            <div class="counter d-flex align-items-center justify-content-between">
                                <button onclick="decrease()">-</button>
                                <span id="count" class="flex-1 text-center"> 1 </span>
                                <button onclick="increase()">+</button>
                            </div>

                        </div>
                        <div class="col-lg-4 col-md-4 col-sm-4 col">
                              <button class="btn-add add-to-cart"  data-id="<?php echo e($product->id); ?>"> Add to cart </button>
                        </div>

                        <?php else: ?>
                            <div class="col-lg-8 cik-md-8 col-sm-8 col">

                                <button type="button" class="btn-add btn-out-stock"  >  <?php echo e(__('front.This product is out of Stock!')); ?> </button>
                            </div>

                        <?php endif; ?>


                        <?php if(auth()->guard()->check()): ?>
                        <div id="button-wishlist" class="col-lg-4 col-md-4 col-sm-4 col-12 mt-2 mt-sm-0 justify-content-center">

                            <?php if( $product->isInWishList ==  0 ): ?>
                              <button data-id="<?php echo e($product->id); ?>" id="btn-add-to-wish-list" onclick="addToWishList('<?php echo e($product->id); ?>')" class="btn-wishlist">
                                  <svg xmlns="http://www.w3.org/2000/svg" width="22.885" height="20.581" viewBox="0 0 22.885 20.581">
                                      <path id="heart_1_copy" data-name="heart (1) copy" d="M19.228,1.818A5.616,5.616,0,0,0,15.051,0a5.254,5.254,0,0,0-3.282,1.133,6.714,6.714,0,0,0-1.327,1.385A6.71,6.71,0,0,0,9.116,1.133,5.253,5.253,0,0,0,5.834,0,5.616,5.616,0,0,0,1.657,1.818,6.528,6.528,0,0,0,0,6.277a7.774,7.774,0,0,0,2.071,5.088,44.168,44.168,0,0,0,5.185,4.867c.718.612,1.533,1.306,2.378,2.046a1.226,1.226,0,0,0,1.614,0c.846-.74,1.66-1.434,2.379-2.047a44.148,44.148,0,0,0,5.185-4.867,7.773,7.773,0,0,0,2.071-5.088A6.528,6.528,0,0,0,19.228,1.818Zm0,0" transform="translate(1 1)" fill="none" stroke="#3c3c39" stroke-width="2"/>
                                  </svg>
                                &nbsp;  Add to wishlist
                              </button>
                            <?php else: ?>

                                <button data-id="<?php echo e($product->id); ?>" id="btn-add-to-wish-list" onclick="removeFromWishList('<?php echo e($product->id); ?>')" class="btn-wishlist">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="20.885" height="18.581" viewBox="0 0 20.885 18.581">
                                        <path id="heart_1_copy" data-name="heart (1) copy" d="M19.228,1.818A5.616,5.616,0,0,0,15.051,0a5.254,5.254,0,0,0-3.282,1.133,6.714,6.714,0,0,0-1.327,1.385A6.71,6.71,0,0,0,9.116,1.133,5.253,5.253,0,0,0,5.834,0,5.616,5.616,0,0,0,1.657,1.818,6.528,6.528,0,0,0,0,6.277a7.774,7.774,0,0,0,2.071,5.088,44.168,44.168,0,0,0,5.185,4.867c.718.612,1.533,1.306,2.378,2.046a1.226,1.226,0,0,0,1.614,0c.846-.74,1.66-1.434,2.379-2.047a44.148,44.148,0,0,0,5.185-4.867,7.773,7.773,0,0,0,2.071-5.088A6.528,6.528,0,0,0,19.228,1.818Zm0,0" fill="#cc7546"/>
                                    </svg>
                                    &nbsp;  remove from wishlist
                                </button>
                            <?php endif; ?>

                        </div>
                        <?php endif; ?>

                    </div>
                    <div class="row mt-3">
                        <div class="col-lg-12 col-md-12 col-sm-12">
                            <h1 class="text-start" style="font-weight: bold;font-size: 20px"> Description </h1>
                            <p class="text-start" style="font-size: 16px"> <?php echo e($product->description); ?> </p>
                        </div>
                    </div>

                </div>
            </div>

        </div>
    </section>
    <br>
    <br>




    <?php echo $__env->make('front-component.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php $__env->stopSection(); ?>


<?php $__env->startSection('scripts'); ?>
    <script>
        var count = 1;

        var maxCount = '<?php echo e($product->quantity); ?>';
        maxCount = parseInt(maxCount);

        function increase(){

            if(count === maxCount) {
                toastr.error('There is no additional quantity of this product in stock');
                return;
            }
            count++
            $("#count").html(count)
        }
        function decrease(){
            if(count === 1){
                return
            }
            count--
            $("#count").html(count)
        }

    </script>

    <script>
        var size = "";

        var sizesCount ='<?php echo e($product->sizes()->where('quantity','!=','0')->count()); ?>';
        var pQuantity ='<?php echo e($product->quantity); ?>';


        sizesCount = parseInt(sizesCount);
        pQuantity = parseInt(pQuantity);

        function selectSize(id,selectedSize){
            $('.size-card').removeClass('selected');
            $('#s-'+id).addClass('selected');
            size=selectedSize;
        }

    </script>


    <script>
        $(document).ready(function () {





            $(".add-to-cart").click(function () {

                if(sizesCount > 0 && size === ""){
                    toastr.info('select product size and try again');
                    return
                }
                var sent;

                let productId = $(this).data('id');
                let quantity = count;

                if(sizesCount === 0){
                    sent  = {product_id: productId,quantity:quantity};
                }else{
                    sent = {product_id: productId,quantity:quantity,size:size};
                }


                    $.ajax({
                    url: '/cart/add',
                    type: 'POST',
                    data: sent,
                    success: function () {
                        location.href="/cart";
                    }
                });
            });

            $(".remove-from-cart").click(function () {
                let productId = $(this).data('id');
                $.ajax({
                    url: '/cart/remove',
                    type: 'POST',
                    data: {product_id: productId},
                    success: function () {
                        location.href="/cart";
                    }
                });
            });




            //

        });

        var btnLoad = ` <button class="btn-wishlist">&nbsp;  loading... </button>`;

        function removeFromWishList(productId){
            $("#button-wishlist").html(btnLoad)
            $("#button-wishlist").load('/remove/from/wishlist/'+productId);
        }

        function addToWishList(productId){
            $("#button-wishlist").html(btnLoad)
            $("#button-wishlist").load('/add/to/wishlist/'+productId);
        }



    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.front', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\my projects\laravel\sanam\resources\views/front/product-details.blade.php ENDPATH**/ ?>