<?php $__env->startSection('styles'); ?>
    <style>

        .product p{
            color:#000;
            text-decoration: none;

        }
        .product .love-btn{
            position: absolute;
            right: 10px;
            top: 10px;
            cursor:pointer;

        }
        .product .icon{
            width: 32px;
            height: 32px;
        }
    </style>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('page'); ?>

    <?php echo $__env->make('front-component.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>



    <br>
    <div class="container ">
        <div class="row orders-row py-5">
            <div class="col-lg-12 col-md-12 col-sm-12 col-12">
                <h2 class="fw-bold">WHISHLIST</h2>
            </div>


            <?php if( count($products) != 0): ?>

            <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div id="row_<?php echo e($product->id); ?>" class="col-lg-4 col-md-3 col-sm-6 col-6 ">
                    <a href="<?php echo e(route('product.details',['id'=>$product->id])); ?>" style="text-decoration: none">
                        <div class="product p-5 position-relative">
                            <div class="love-btn" onclick="removeFromWishList('<?php echo e($product->id); ?>')">

                                <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="40" height="40" viewBox="0 0 24 24" stroke-width="2" stroke="none" fill="red" stroke-linecap="round" stroke-linejoin="round">
                                    <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
                                    <path d="M19.5 13.572l-7.5 7.428l-7.5 -7.428m0 0a5 5 0 1 1 7.5 -6.566a5 5 0 1 1 7.5 6.572" />
                                </svg>
                            </div>
                            <img src="<?php echo e(asset($product->image)); ?>" alt="">
                            <p class="mb-0"><b> <?php echo e($product->name); ?> </b></p>
                            <p class="mb-0"> <?php echo e($product->category->name); ?> </p>
                            <p class="mb-0"> <?php echo e($product->redable_price); ?>   </p>
                        </div>
                    </a>

                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            <?php else: ?>
                <div class="col-lg-12 col-md-12 col-sm-12 d-flex justify-content-center align-items-center min-vh-50">

                    <?php echo $__env->make('front-component.empty',['message'=>'no items in your wishlist'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                </div>

            <?php endif; ?>

        </div>
    </div>

    <br>



    <?php echo $__env->make('front-component.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection("scripts"); ?>

<script>

    function removeFromWishList(pid){
            event.preventDefault();
            $("#row_"+pid).remove();

        $.ajax({
            url: '/remove/from/wishlist/'+pid,
            type: 'GET',
        });
    }

</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.front', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\my projects\laravel\sanam\resources\views/front/wishlist.blade.php ENDPATH**/ ?>