<!doctype html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- CSRF Token -->
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <title><?php echo e(config('app.name', 'Laravel')); ?></title>


    <!-- Fonts -->
    <link rel="dns-prefetch" href="//fonts.gstatic.com">
    <link href="https://fonts.googleapis.com/css?family=Nunito" rel="stylesheet">

    <!-- Styles -->

    <link href="<?php echo e(asset('css/app.css')); ?>" rel="stylesheet">
    <?php echo toastr_css(); ?>

    <link href='https://unpkg.com/boxicons@2.0.7/css/boxicons.min.css' rel='stylesheet'>
    <link rel="stylesheet" href="<?php echo e(asset('css/admin.css')); ?>">
    <?php echo $__env->yieldContent('style'); ?>
</head>
<body>
<div id="app">

    <div class="sidebar  ">
        <div class="logo-details">

            <i class='bx bx-cart'></i>
            <span class="logo_name"><?php echo e(env('APP_NAME')); ?></span>
        </div>
        <ul class="nav-links">
            <li>
                <a href="<?php echo e(route('admin.dashboard')); ?>">
                    <i class='bx bx-grid-alt' ></i>
                    <span class="link_name">Dashboard</span>
                </a>
                <ul class="sub-menu blank">
                    <li><a class="link_name" href="#">Dashboard</a></li>
                </ul>
            </li>

            <li>
                <div class="iocn-link">
                    <a href="<?php echo e(route('admin.roles.index')); ?>">
                        <i class='bx bx-link-alt'></i>
                        <span class="link_name">Roles</span>
                    </a>
                    <i class='bx bxs-chevron-down arrow' ></i>
                </div>
                <ul class="sub-menu">
                    <li><a class="link_name" href="#">Roles</a></li>
                    <li><a href="<?php echo e(route('admin.roles.create')); ?>">create role</a></li>
                    <li><a href="<?php echo e(route('admin.roles.index')); ?>">roles</a></li>

                </ul>
            </li>

            <li>
                <div class="iocn-link">
                    <a href="<?php echo e(route('admin.users.index')); ?>">
                        <i class='bx bxs-user'></i>
                        <span class="link_name">Users</span>
                    </a>
                    <i class='bx bxs-chevron-down arrow' ></i>
                </div>
                <ul class="sub-menu">
                    <li><a class="link_name" href="<?php echo e(route('admin.users.index')); ?>">Users</a></li>
                    <li><a href="<?php echo e(route('admin.users.create')); ?>">Create User</a></li>
                    <li><a href="<?php echo e(route('admin.users.index')); ?>">All Users</a></li>
                    <li><a href="#">Top user </a></li>

                </ul>
            </li>
            <li>
                <a href="#">
                    <i class='bx bx-cart'></i>
                    <span class="link_name">Markets</span>
                </a>
                <ul class="sub-menu blank">
                    <li><a class="link_name" href="#">Markets</a></li>
                </ul>
            </li>


            <li>
                <div class="iocn-link">
                    <a href="#">
                        <i class='bx bx-collection' ></i>
                        <span class="link_name">Category</span>
                    </a>
                    <i class='bx bxs-chevron-down arrow' ></i>
                </div>
                <ul class="sub-menu">
                    <li><a class="link_name" href="#">Category</a></li>
                    <li><a href="#">HTML & CSS</a></li>
                    <li><a href="#">JavaScript</a></li>
                    <li><a href="#">PHP & MySQL</a></li>
                </ul>
            </li>
            <li>
                <div class="iocn-link">
                    <a href="#">
                        <i class='bx bx-book-alt' ></i>
                        <span class="link_name">Products</span>
                    </a>
                    <i class='bx bxs-chevron-down arrow' ></i>
                </div>
                <ul class="sub-menu">
                    <li><a class="link_name" href="#">Products</a></li>
                    <li><a href="#">create product</a></li>

                </ul>
            </li>
            <li>
                <a href="#">
                    <i class='bx bx-pie-chart-alt-2' ></i>
                    <span class="link_name">Analytics</span>
                </a>
                <ul class="sub-menu blank">
                    <li><a class="link_name" href="#">Analytics</a></li>
                </ul>
            </li>
            <li>
                <a href="#">
                    <i class='bx bx-line-chart' ></i>
                    <span class="link_name">Chart</span>
                </a>
                <ul class="sub-menu blank">
                    <li><a class="link_name" href="#">Chart</a></li>
                </ul>
            </li>
            <li>
                <div class="iocn-link">
                    <a href="#">
                        <i class='bx bx-plug' ></i>
                        <span class="link_name">Plugins</span>
                    </a>
                    <i class='bx bxs-chevron-down arrow' ></i>
                </div>
                <ul class="sub-menu">
                    <li><a class="link_name" href="#">Plugins</a></li>
                    <li><a href="#">UI Face</a></li>
                    <li><a href="#">Pigments</a></li>
                    <li><a href="#">Box Icons</a></li>
                </ul>
            </li>
            <li>
                <a href="#">
                    <i class='bx bx-compass' ></i>
                    <span class="link_name">Explore</span>
                </a>
                <ul class="sub-menu blank">
                    <li><a class="link_name" href="#">Explore</a></li>
                </ul>
            </li>
            <li>
                <a href="#">
                    <i class='bx bx-history'></i>
                    <span class="link_name">History</span>
                </a>
                <ul class="sub-menu blank">
                    <li><a class="link_name" href="#">History</a></li>
                </ul>
            </li>
            <li>
                <a href="#">
                    <i class='bx bx-cog' ></i>
                    <span class="link_name">Setting</span>
                </a>
                <ul class="sub-menu blank">
                    <li><a class="link_name" href="#">Setting</a></li>
                </ul>
            </li>
            <li>
                <div class="profile-details">
                    <a href="<?php echo e(route('admin.users.profile')); ?>" style="text-decoration: none;">


                    <div class="profile-content">
                        <img src="<?php echo e(asset(auth()->user()->image)); ?>" alt="profileImg">
                    </div>
                    <div class="name-job">
                        <div class="profile_name user_profile_name"><?php echo e(auth()->user()->name); ?></div>
                        <div class="job"><?php echo e(auth()->user()->role->name); ?></div>
                    </div>
                    </a>
                    <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" class="d-none">
                        <?php echo csrf_field(); ?>
                    </form>
                    <i class='bx bx-log-out' onclick="event.preventDefault();
                               document.getElementById('logout-form').submit();" ></i>
                </div>
            </li>
        </ul>
    </div>
    <section class="home-section">
        <div class="home-content">
            <i class='bx bx-menu' ></i>
            <span class="text user_profile_name"><?php echo e(auth()->user()->name); ?></span>
        </div>

        <?php echo $__env->yieldContent('content'); ?>



    </section>


</div>

<?php echo jquery(); ?>
<?php echo toastr_js(); ?>
<?php echo app('toastr')->render(); ?>
<script src="https://cdn.jsdelivr.net/npm/jquery@3.5.1/dist/jquery.slim.min.js" integrity="sha384-DfXdz2htPH0lsSSs5nCTpuj/zy4C+OGpamoFVy38MVBnE+IbbVYUew+OrCXaRkfj" crossorigin="anonymous"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.1/dist/js/bootstrap.bundle.min.js" integrity="sha384-fQybjgWLrvvRgtW6bFlB7jaZrFsaBXjsOMm/tB9LTS58ONXgqbR9W8oWht/amnpF" crossorigin="anonymous"></script>
<?php echo $__env->yieldContent('scripts'); ?>
<script>
    let arrow = document.querySelectorAll(".arrow");
    for (var i = 0; i < arrow.length; i++) {
        arrow[i].addEventListener("click", (e)=>{
            let arrowParent = e.target.parentElement.parentElement;//selecting main parent of arrow
            arrowParent.classList.toggle("showMenu");
        });
    }
    let sidebar = document.querySelector(".sidebar");
    let sidebarBtn = document.querySelector(".bx-menu");

    sidebarBtn.addEventListener("click", ()=>{
        sidebar.classList.toggle("close-side");
    });



</script>
</body>
</html>
<?php /**PATH D:\my projects\laravel\BetaBlog\resources\views/layouts/admin.blade.php ENDPATH**/ ?>