<?php $__env->startSection('styles'); ?>
    <style>
        .fw-bold{
            font-weight: bolder !important;
        }

    </style>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('page'); ?>

    <?php echo $__env->make('front-component.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>



    <br>
    <div class="container" <?php if(app()->getLocale()=="ar"): ?> dir="rtl" <?php endif; ?>>
        <div class="row min-vh-60 order-details-row py-5">
            <div class="col-12">
                <h1 class="fw-bolder"><?php echo e(__('front.order_details_heading')); ?></h1>
            </div>
            <div class="col-lg-4 mb-3 mb-lg-0">
                <h2 class="fw-bold"><?php echo e(__('front.order_details_heading')); ?></h2>
                <div class="d-flex justify-content-between p-3" style="background-color: #FAF8F4">
                    <div>
                        <span class="d-block mb-2"><?php echo e(__('front.order_date')); ?></span>
                        <span class="d-block mb-2"><?php echo e(__('front.status')); ?></span>
                        <span class="d-block mb-2"><?php echo e(__('front.payment_method')); ?></span>
                        <?php if($order->payment_type == "credit_card"): ?>
                            <span class="d-block mb-2"><?php echo e(__('front.payment_id')); ?></span>
                            <span class="d-block mb-2"><?php echo e(__('front.transaction_id')); ?></span>
                        <?php endif; ?>
                        <span class="d-block mb-2"><?php echo e(__('front.total')); ?></span>
                    </div>
                    <div class="d-flex flex-column align-items-end">
                        <span class="d-block mb-2"><?php echo e(substr($order->created_at,0,10)); ?></span>
                        <span class="d-block mb-2"><?php echo e($order->status); ?></span>
                        <span class="d-block mb-2"><?php echo e($order->payment_type == "credit" ? "KNET" : "Cash on delivery"); ?></span>
                        <?php if($order->payment_type == "credit"): ?>
                            <?php
                                $payment = \App\Models\Payments::where('id',$order->payment_id)->first();
                            ?>
                            <?php if($payment): ?>
                                <span class="d-block mb-2"><?php echo e($payment->payment_id); ?></span>
                                <span class="d-block mb-2"><?php echo e($payment->transaction_id); ?></span>
                            <?php endif; ?>
                        <?php endif; ?>
                        <span class="d-block mb-2"><?php echo e($order->final_amount); ?></span>
                    </div>
                </div>
            </div>
            <div class="col-lg-4 mb-3 mb-lg-0">
                <h2 class="fw-bold"><?php echo e(__('front.order_summary')); ?></h2>
                <?php $__currentLoopData = $order->orderChildren; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $orderChild): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="d-flex p-2 mb-3" style="background-color: #FAF8F4">
                        <img class="summary-image me-2" src="<?php echo e(asset($orderChild->product->image)); ?>" width="70" />
                        <div class="d-flex flex-column justify-content-start  <?php if(app()->getLocale()=="ar"): ?>  m-2 <?php endif; ?>">
                            <span class="fw-bold"><?php echo e($orderChild->product->name); ?></span>
                            <span><?php echo e($orderChild->quantity); ?></span>
                            <span><?php echo e($orderChild->amount); ?></span>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
            <div class="col-lg-4 mb-3 mb-lg-0">
                <h2 class="fw-bold"><?php echo e(__('front.delivery_address')); ?></h2>
                <div class="d-flex flex-column align-items-start p-3 mb-3" style="background-color: #FAF8F4">
                    <?php if($order->address->address_type == "internal"): ?>
                        <span class="fw-bold"><?php echo e($order->address->area); ?></span>
                        <span>block <?php echo e($order->address->block); ?>,street <?php echo e($order->address->street); ?></span>
                    <?php else: ?>
                        <span>country: <?php echo e($order->address->country); ?> - city: <?php echo e($order->address->city); ?></span>
                        <span>line 1: <?php echo e($order->address->line_1); ?></span>
                        <span>line 2: <?php echo e($order->address->line_2); ?></span>
                    <?php endif; ?>
                    <span><?php echo e($order->address->extra_direction); ?></span>
                </div>
                <h2 class="fw-bold"><?php echo e(__('front.payment_details')); ?></h2>
                <div class="d-flex justify-content-between p-3" style="background-color: #FAF8F4">
                    <div class="d-flex flex-column align-items-start">
                        <span class="mb-2"><?php echo e(__('front.sub_total')); ?></span>
                        <span class="mb-2"><?php echo e(__('front.discount')); ?></span>
                        <span class="mb-2"><?php echo e(__('front.delivery_charges')); ?></span>
                        <span class="fw-bold"><?php echo e(__('front.total')); ?></span>
                    </div>
                    <div class="d-flex flex-column align-items-start">
                        <span class="mb-2"><?php echo e($order->total_amount); ?></span>
                        <span class="mb-2"><?php echo e($order->discount ?? 0.000); ?></span>
                        <span class="mb-2"><?php echo e($order->delivery_charges ?? 0.000); ?></span>
                        <span class="fw-bold"><?php echo e($order->final_amount); ?></span>
                    </div>
                </div>
            </div>
        </div>
    </div>


    <br>



    <?php echo $__env->make('front-component.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection("scripts"); ?>

    <script>

    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.front', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\my projects\laravel\sanam\resources\views/front/order-details.blade.php ENDPATH**/ ?>