<?php $__env->startSection('title','Admin Settings'); ?>

<?php $__env->startSection('header-top'); ?>

    <?php echo $__env->make('layouts.inc.top-large-bar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div class="page-wrapper ">
        <div class="wrapper">
            <!-- Page title -->
            <div class="page-header d-print-none">
                <div class="row align-items-center">
                    <div class="col">
                        <!-- Page pre-title -->

                        <h2 class="page-title">
                            Coupon Codes
                        </h2>
                    </div>
                    <!-- Page title actions -->
                    <div class="col-auto ms-auto d-print-none">


                        <div class="btn-list">

                            <a href="#" class="btn btn-indigo d-none d-sm-inline-block" data-bs-toggle="modal"
                               data-bs-target="#modal-large">
                                <!-- Download SVG icon from http://tabler-icons.io/i/plus -->
                                <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24"
                                     viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none"
                                     stroke-linecap="round" stroke-linejoin="round">
                                    <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
                                    <line x1="12" y1="5" x2="12" y2="19"/>
                                    <line x1="5" y1="12" x2="19" y2="12"/>
                                </svg>
                                add new coupon
                            </a>
                            <a href="#" class="btn btn-indigo d-sm-none btn-icon" data-bs-toggle="modal"
                               data-bs-target="#modal-large" aria-label="Create new report">
                                <!-- Download SVG icon from http://tabler-icons.io/i/plus -->
                                <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24"
                                     viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none"
                                     stroke-linecap="round" stroke-linejoin="round">
                                    <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
                                    <line x1="12" y1="5" x2="12" y2="19"/>
                                    <line x1="5" y1="12" x2="19" y2="12"/>
                                </svg>
                            </a>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="wrapper ">
        <div class="row">
            <div class="col-lg-12 col-md-12 col-sm-12">

                <div class="card">
                    <div class="card-body-s">

                        <div class="table-responsive">
                            <table class="table table-striped">
                                <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>Course</th>
                                    <th>Workshop</th>
                                    <th>Discount (%)</th>
                                    <th>Apply Count</th>
                                    <th>Allowed Apply Count</th>
                                    <th>Coupon Code</th>
                                    <th>Actions</th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php $__currentLoopData = $couponCodes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $coupon): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($coupon->id); ?></td>
                                        <td><?php echo e($coupon->course ? $coupon->course->name : ' '); ?></td>
                                        <td><?php echo e($coupon->workshop ? $coupon->workshop->name : ' '); ?></td>
                                        <td><?php echo e($coupon->discount); ?>%</td>
                                        <td><?php echo e($coupon->apply_count); ?></td>
                                        <td><?php echo e($coupon->allowed_apply_count); ?></td>
                                        <td><?php echo e($coupon->coupon); ?></td>
                                        <td>
                                            <div class="dropdown">
                                                <button class="btn dropdown-toggle align-text-top" data-bs-toggle="dropdown" aria-expanded="false">
                                                    Actions
                                                </button>
                                                <div class="dropdown-menu dropdown-menu-end">
                                            <button type="button" class="dropdown-item" onclick="edit('<?php echo e($coupon->id); ?>')">Edit</button>
                                            <button type="button" onclick="deleteRecord('<?php echo e(route("admin.coupon_codes.destroy",["coupon_code"=>$coupon->id])); ?>')" class="dropdown-item">Delete</button>
                                                </div>
                                            </div>

                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>

                        </div>
                        
                        
                        
                        
                        
                    </div>

                </div>
            </div>
        </div>

        
        <div class="modal modal-blur fade" id="modal-large" tabindex="-1" role="dialog" aria-hidden="true">
            <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Create New Coupon</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <form action="<?php echo e(route('admin.coupon_codes.store')); ?>" method="post" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>

                        <?php if(isset($course)): ?>
                            <input name="course_id" value="<?php echo e($course->id); ?>" hidden>
                        <?php endif; ?>
                        <?php if(isset($workshop)): ?>
                            <input name="workshop_id" value="<?php echo e($workshop->id); ?>" hidden>
                        <?php endif; ?>

                        <div class="modal-body scrollable-modal">

                            <div class="row mt-3">


                                <div class="col-lg-12 col-md-12 col-sm-12 mt-2">
                                    <div class="form-group">
                                        <label>Discount (%)</label>
                                        <input class="form-control <?php $__errorArgs = ['discount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" type="number" name="discount" placeholder="Discount" value="<?php echo e(isset($coupon) ? $coupon->discount : old('discount')); ?>">
                                        <?php $__errorArgs = ['discount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <small class="form-text text-danger"><?php echo e($message); ?></small> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>

                                <div class="col-lg-12 col-md-12 col-sm-12 mt-2">
                                    <div class="form-group">
                                        <label>Allowed Apply Count</label>
                                        <input class="form-control <?php $__errorArgs = ['allowed_apply_count'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" type="number" name="allowed_apply_count" placeholder="Allowed Apply Count" value="<?php echo e(isset($coupon) ? $coupon->allowed_apply_count : old('allowed_apply_count')); ?>">
                                        <?php $__errorArgs = ['allowed_apply_count'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <small class="form-text text-danger"><?php echo e($message); ?></small> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>

                                <div class="col-lg-12 col-md-12 col-sm-12 mt-2">
                                    <div class="form-group">
                                        <label>Coupon Code</label>
                                        <input class="form-control <?php $__errorArgs = ['coupon'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" type="text" name="coupon" placeholder="Coupon Code" value="<?php echo e(isset($coupon) ? $coupon->coupon : old('coupon')); ?>">
                                        <?php $__errorArgs = ['coupon'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <small class="form-text text-danger"><?php echo e($message); ?></small> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>


                            </div>


                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn me-auto" data-bs-dismiss="modal">Close</button>
                            <button type="submit" class="btn btn-primary">
                                Create Coupon
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        

        <div class="modal modal-blur fade" id="edit-modal" tabindex="-1" role="dialog" aria-hidden="true">
            <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
                <div class="modal-content" id="edit-modal-content">

                </div>
            </div>
        </div>

        <?php echo $__env->make('components.remove-modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php $__env->stopSection(); ?>

        <?php $__env->startPush('scripts'); ?>
            <script>

                const dropdowns = document.querySelectorAll('.dropdown-toggle')
                const dropdown = [...dropdowns].map((dropdownToggleEl) => new bootstrap.Dropdown(dropdownToggleEl, {
                    popperConfig(defaultBsPopperConfig) {
                        return { ...defaultBsPopperConfig, strategy: 'fixed' };
                    }
                }));

                let loader = `<?php echo $__env->make('components.loader', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>`;

                function edit(id) {
                    $("#edit-modal-content").html(loader);
                    $('#edit-modal').modal('show');
                    $("#edit-modal-content").load(`admin/coupon_codes/${id}/edit`);
                }


                function setDir(dir) {
                    // Use querySelectorAll for more modern and efficient element selection
                    const elements = document.querySelectorAll('.direc');

                    if (elements.length === 0) {
                        console.warn("No elements found with class 'direc'.");
                        return; // Exit the function if no elements are found
                    }

                    if (dir.toLowerCase() === 'rtl') {
                        elements.forEach(element => element.setAttribute('dir', 'rtl'));
                    } else if (dir.toLowerCase() === 'ltr') {
                        elements.forEach(element => element.setAttribute('dir', 'ltr'));
                    } else {
                        console.warn("Invalid direction specified. Please use 'rtl' or 'ltr'.");
                    }
                }
            </script>
            <script>
                function deleteRecord(action) {
                    console.log(action)
                    $("#remove-form").attr('action', action);
                    $("#modal-danger").modal('show');
                }

            </script>
    <?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.tabler-vertical', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\free lancing projects\laravel\lms_azzam\resources\views/admin/coupons/index.blade.php ENDPATH**/ ?>