<?php $__env->startSection('styles'); ?>
    <style>
        .vh-50{
            height: 75vh;
        }
        .main-color{
            background-color: #CC7546;
        }
        .accordion{
            background-color: #FAF8F4;
        }
        .accordion a{
            font-size: 18px;
            color:#000;
            text-decoration: none;
        }
        .accordion a.active{
            font-size: 18px;
            color:#CC7546;
            text-decoration: none;
            font-weight: bold;
        }
        .title{
            font-size: 28px;
        }
        .order-border{
            border: solid 1px #F1EBE0;
        }
        .order-border .orange{
            font-size: 18px;
            color:#CC7546;
            text-decoration: none;
            font-weight: bold !important;
        }
        .btn-dark{
            --tblr-btn-border-color: #3C3C39;
            --tblr-btn-hover-border-color: #3C3C39;
            --tblr-btn-active-border-color: #3C3C39;
            --tblr-btn-bg: #3C3C39;
            --tblr-btn-disabled-bg: #3C3C39;
        }

        .btn.dn:hover {
            color: var(--tblr-btn-hover-color);
            text-decoration: none;
            background-color: red;
            border-color:red;
        }

    </style>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('page'); ?>

    <?php echo $__env->make('front-component.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <div class="container min-vh-70 <?php if(app()->getLocale() == "ar"): ?> text-end <?php else: ?> text-start  <?php endif; ?>"  <?php if(app()->getLocale() == "ar"): ?> dir="rtl" <?php endif; ?>>
        <div class="row orders-row py-5">
            <div class="col-lg-3 mb-3 mb-lg-0 ps-0">
                <div class="d-flex flex-start main-color p-3">
                    <div class="image p-4 me-3 text-center"><img class="px-1" src="<?php echo e(asset('assets/media/icons/user-1.svg')); ?>"/></div>
                    <div class="image-text text-white">
                        <h3 class="fw-bolder mb-0"><?php echo e(\Illuminate\Support\Facades\Auth::user()->name); ?></h3>
                        <span class="d-block mb-2"><?php echo e(\Illuminate\Support\Facades\Auth::user()->email); ?></span>
                        <span><?php echo e(\Illuminate\Support\Facades\Auth::user()->phone); ?></span>
                    </div>
                </div>
                <div class="accordion">
                    <a type="button" onclick="showOrderSection()" id="order-link" class="d-flex justify-content-between align-items-center p-3">
                        <span><?php echo e(__('front.My Orders')); ?></span>
                        <img  src="<?php echo e(asset('assets/media/icons/right-arrow.svg')); ?>"/>
                    </a>
                    <a type="button" onclick="showAddressSection()" id="address-link" class="d-flex justify-content-between align-items-center p-3">
                        <span><?php echo e(__('front.Address Book')); ?> </span>
                        <img  src="<?php echo e(asset('assets/media/icons/right-arrow.svg')); ?>"/>
                    </a>
                    <a type="button" onclick="showAccountSection()" id="account-link" class="d-flex justify-content-between align-items-center p-3">
                        <span><?php echo e(__('front.Edit Account')); ?></span>
                        <img  src="<?php echo e(asset('assets/media/icons/right-arrow.svg')); ?>"/>
                    </a>
                    <a type="button" onclick="showPasswordSection()" id="password-link" class="d-flex justify-content-between align-items-center p-3">
                        <span><?php echo e(__('front.Change Password')); ?> </span>
                        <img  src="<?php echo e(asset('assets/media/icons/right-arrow.svg')); ?>"/>
                    </a>
                    <a type="button" data-bs-toggle="modal" data-bs-target="#logoutModal" class="d-flex justify-content-between align-items-center p-3" >
                        <span><?php echo e(__('front.Logout')); ?> </span>
                        <img  src="<?php echo e(asset('assets/media/icons/right-arrow.svg')); ?>"/>
                    </a>
                </div>
            </div>
            <div class="col-lg-9 " style="padding:0 20px">

                <?php if(session('message')): ?>
                    <div class="alert alert-success" role="alert">
                        <h4 class="alert-title">Success</h4>
                        <div class="text-muted"><?php echo e(session('message')); ?></div>
                    </div>
                <?php endif; ?>

                    <?php if(session('error')): ?>
                        <div class="alert alert-danger" role="alert">
                            <h4 class="alert-title">Error &hellip;</h4>
                            <div class="text-muted"><?php echo e(session('error')); ?></div>
                        </div>
                <?php endif; ?>

                <div class="d-none" id="my-orders">
                    <h4 class="fw-bolder title"><?php echo e(__('front.My Orders')); ?></h4>
                    <?php if(count($orders) == 0): ?>
                        <div class="card pt-2 pb-2 w-50 d-flex flex-column justify-content-center align-items-center" style="  background-color: #FAF8F4">
                            <div class="emty-icon mt-2">
                                <svg xmlns="http://www.w3.org/2000/svg" width="64.373" height="64.373" viewBox="0 0 64.373 64.373">
                                    <g id="nothing" transform="translate(0 0)">
                                        <path id="Path_142324" data-name="Path 142324" d="M40.519,68.308A20.449,20.449,0,0,1,68.306,40.52l5.8-5.8A28.419,28.419,0,0,0,34.721,74.106Z" transform="translate(-26.227 -26.229)" fill="#cc7546"/>
                                        <path id="Path_142325" data-name="Path 142325" d="M164.784,137A20.45,20.45,0,0,1,137,164.785l-5.8,5.8A28.418,28.418,0,0,0,170.582,131.2Z" transform="translate(-114.702 -114.704)" fill="#cc7546"/>
                                        <path id="Path_142326" data-name="Path 142326" d="M63.822.551a1.889,1.889,0,0,0-2.668,0l-60.6,60.6A1.887,1.887,0,0,0,3.22,63.82l60.6-60.6a1.889,1.889,0,0,0,0-2.668Z" transform="translate(0 0)" fill="#cc7546"/>
                                    </g>
                                </svg>
                            </div>
                            <h2 class="mb-0"><?php echo e(__('no_orders_heading')); ?></h2>
                            <p><?php echo e(__('no_orders_text')); ?></p>

                        </div>
                    <?php endif; ?>

                <?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="order-border w-100 p-4 mt-3">
                            <div class="row text-left">
                                <div class="col-md-3 d-flex flex-column align-items-center justify-content-center mb-2 mb-md-0">
                                    <span class="fw-bold"><?php echo e(__('front.order_date')); ?></span>
                                    <span><?php echo e($order->created_at->diffForHumans()); ?></span>
                                </div>
                                <div class="col-md-2 d-flex flex-column align-items-center justify-content-center mb-2 mb-md-0">
                                    <span class="fw-bold"><?php echo e(__('front.order_no')); ?></span>
                                    <span>#<?php echo e($order->order_number); ?></span>
                                </div>
                                <div class="col-md-2 d-flex flex-column align-items-center justify-content-center mb-2 mb-md-0">
                                    <span class="fw-bold"><?php echo e(__('front.status')); ?></span>
                                    <span><?php echo e($order->status); ?></span>
                                </div>
                                <div class="col-md-2 d-flex flex-column align-items-center justify-content-center mb-2 mb-md-0">
                                    <span class="fw-bold"><?php echo e(__('front.total')); ?></span>
                                    <span><?php echo e($order->final_amount); ?></span>
                                </div>
                                <div class="col-md-3 d-flex flex-column align-items-center align-items-md-end justify-content-center">
                                    <a href="<?php echo e(route('order.show',['order'=>$order->id])); ?>" class="btn btn-dark w-50 no-radius">
                                        <?php echo e(__('front.view')); ?>

                                    </a>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                </div>
                <div class="d-none" id="address-book">
                    <div class="row" id="address-container">
                        <div class="col-12 d-flex justify-content-between align-items-center mb-3">
                            <h4 class="fw-bolder title"><?php echo e(__('front.Address Book')); ?></h4>
                            <button class="btn btn-dark no-radius"  data-bs-toggle="modal" data-bs-target="#addAddress">

                                <?php echo e(__('front.Add New Address')); ?>

                            </button>
                        </div>
                        <?php $__currentLoopData = \Illuminate\Support\Facades\Auth::user()->addresses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $address): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-md-6 mb-1">
                            <div class="order-border d-flex flex-column p-3">
                                <?php if($address->address_type == "internal"): ?>
                                    <span class="fw-bold orange">    Kuwait
                                    </span>
                                    <span class="fw-bold">area <?php echo e($address->area); ?> </span>
                                    <span >block <?php echo e($address->block); ?>,street <?php echo e($address->street); ?></span>
                                <?php else: ?>
                                    <span class="fw-bold orange">

                                        <?php if(is_numeric($address->country)): ?>
                                            <?php echo e(\App\Models\Country::find($address->country)->name); ?>

                                            <?php else: ?>
                                            <?php echo e($address->country); ?>

                                        <?php endif; ?>


                                    </span>
                                    <span  > city : <?php echo e($address->city); ?> </span>
                                    <span  > line 1 : <?php echo e($address->line_1); ?>  </span>
                                    <span  > line 2 : <?php echo e($address->line_2); ?>  </span>
                                <?php endif; ?>
                                <span  > <?php echo e($address->extra_direction); ?>  </span>

                                <div class="d-flex justify-content-start w-75 mt-4">
                                    <button class="btn btn-outline-dark dn no-radius <?php if(app()->getLocale() == "en"): ?> me-4 <?php else: ?> ms-4 <?php endif; ?>"   onclick="deleteRecord('<?php echo e(route("address.destroy",["address"=>$address->id])); ?>')">
                                        <?php echo e(__('front.delete')); ?>

                                    </button>
                                    <button onclick="edit('<?php echo e($address->id); ?>')" class="btn btn-dark no-radius" >
                                        <?php echo e(__('front.edit')); ?>

                                    </button>
                                </div>
                            </div>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
                <div class="d-none" id="edit-account">
                    <h4 class="fw-bolder mb-4 title"><?php echo e(__('front.Edit Account')); ?></h4>
                    <div class="d-flex flex-column w-50">
                        <form action="<?php echo e(route('update.account')); ?>" method="POST">
                            <?php echo csrf_field(); ?>

                            <div class="mb-4">
                                <label class="mb-1 fw-bold" for="block"><?php echo e(__('front.full_name')); ?>*</label>
                                <input class="form-control no-radius" id="name" name="name" value="<?php echo e(Auth::user()->name); ?>" placeholder="<?php echo e(__('front.enter_full_name')); ?>"/>
                            </div>
                            <div class="mb-4">
                                <label class="mb-1 fw-bold" for="block"><?php echo e(__('front.email_address')); ?>*</label>
                                <input class="form-control no-radius" type="email" id="email" name="email" value="<?php echo e(Auth::user()->email); ?>" placeholder="<?php echo e(__('front.enter_email')); ?>"/>
                            </div>
                            <div class="mb-4">
                                <label class="mb-1 fw-bold" for="block"><?php echo e(__('front.mobile_number')); ?>*</label>
                                <input type="number" class="form-control no-radius" id="mobile" name="phone" value="<?php echo e(Auth::user()->phone); ?>" placeholder="<?php echo e(__('front.enter_mobile')); ?>"/>
                            </div>
                            <button class="btn btn-dark no-radius w-50">
                                <?php echo e(__('front.update')); ?>

                            </button>

                        </form>
                    </div>
                </div>
                <div class="d-none" id="change-password">
                    <h4 class="fw-bolder mb-4 title"><?php echo e(__('front.Change Password')); ?></h4>
                    <div class="d-flex flex-column w-50">
                        <form action="<?php echo e(route('change.password')); ?>" method="POST">
                            <?php echo csrf_field(); ?>

                            <div class="mb-4">
                                <label class="mb-1 fw-bold" for="block"><?php echo e(__('front.old_password')); ?>*</label>
                                <input class="form-control no-radius" name="old_password" placeholder="<?php echo e(__('front.enter_old_password')); ?>"/>
                            </div>
                            <div class="mb-4">
                                <label class="mb-1 fw-bold" for="block"><?php echo e(__('front.new_password')); ?>*</label>
                                <input class="form-control no-radius" name="new_password" placeholder="<?php echo e(__('front.enter_new_password')); ?>"/>
                            </div>
                            <div class="mb-4">
                                <label class="mb-1 fw-bold" for="block"><?php echo e(__('front.confirm_password')); ?>*</label>
                                <input type="number" class="form-control no-radius" name="confirm_password" placeholder="<?php echo e(__('front.confirm_new_password')); ?>"/>
                            </div>
                            <button class="btn btn-dark no-radius w-50">
                                <?php echo e(__('front.change')); ?>

                            </button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="modal fade" id="logoutModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content no-radius">
                <div class="modal-body p-5" <?php if(app()->getLocale()=="ar"): ?> dir="rtl" <?php endif; ?>>
                    <div class="d-flex flex-column ">
                        <h1 class="fw-bolder mb-3">        <?php echo e(__('front.logout')); ?> </h1>
                        <span class="mb-3"><?php echo e(__('front.logout_confirmation')); ?> ?</span>
                        <div class="d-flex justify-content-between">
                            <a href="<?php echo e(route('logout')); ?>" class="btn btn-outline-dark no-radius py-3  <?php if(app()->getLocale()=="ar"): ?> ms-2 <?php else: ?>  me-2 <?php endif; ?>  flex-fill">
                                <?php echo e(__('front.yes')); ?>

                            </a>
                            <button class="btn btn-dark no-radius py-3 flex-fill" data-bs-dismiss="modal">
                                <?php echo e(__('front.no')); ?>

                            </button>
                        </div>
                    </div>
                </div>
                
            </div>
        </div>
    </div>


    <div class="modal fade" id="addAddress" tabindex="-1" aria-labelledby="addAddressLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content no-radius">


                <div class="modal-body mt-0 ">
                   <div class="row mb-2">

                       <div class="col-12 d-flex align-items-center">
                           <span class="h1 text-center w-100 fw-bold mb-0 "> <?php echo e(__('front.Add New Address')); ?></span>
                           <span type="button" class="  close-modal p-0 mb-0 flex-1 " data-bs-dismiss="modal">
                                <svg xmlns="http://www.w3.org/2000/svg" width="34.399" height="34.399" viewBox="0 0 34.399 34.399">
                                    <g id="cancel_3_" data-name="cancel (3)" transform="translate(0 -0.005)">
                                        <g id="Group_50679" data-name="Group 50679" transform="translate(0 0.005)">
                                            <path id="Path_142368" data-name="Path 142368" d="M29.367,5.037a17.2,17.2,0,1,0,0,24.336A17.227,17.227,0,0,0,29.367,5.037ZM24.3,22.275A1.434,1.434,0,1,1,22.269,24.3L17.2,19.232,12.132,24.3A1.434,1.434,0,0,1,10.1,22.273L15.172,17.2,10.1,12.135a1.434,1.434,0,0,1,2.028-2.028L17.2,15.177l5.069-5.069A1.434,1.434,0,0,1,24.3,12.135L19.228,17.2Z" transform="translate(0 -0.005)" fill="#cc7546"/>
                                        </g>
                                    </g>
                                </svg>
                           </span>
                       </div>

                   </div>
                    <div class="container m-0 p-0 vh-50 overflow-y-auto">

                        <?php if($ad_type == 'internal'): ?>
                            <?php echo $__env->make('front-component.internal-form', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        <?php else: ?>
                            <?php echo $__env->make('front-component.external-form', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        <?php endif; ?>



                    </div>
                    <div class="row">

                        <div class="col-12 px-5 mb-4">
                            <button id="add-address-btn" class="btn btn-dark w-100 no-radius">
                                <?php echo e(__('front.Add New Address')); ?>

                            </button>
                        </div>
                    </div>
                </div>

            </div>
        </div>
        </div>


        <div class="modal modal-blur fade" id="edit-modal" tabindex="-1" role="dialog" aria-hidden="true">
            <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
                <div class="modal-content" id="edit-modal-content">

                </div>
            </div>
        </div>




    <?php echo $__env->make('front-component.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('components.remove-modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    <script>
        function showOrderSection(){
            document.getElementById('my-orders').classList.remove('d-none');
            document.getElementById('address-book').classList.add('d-none');
            document.getElementById('edit-account').classList.add('d-none');
            document.getElementById('change-password').classList.add('d-none');


            document.getElementById('order-link').classList.add('active');
            document.getElementById('address-link').classList.remove('active');
            document.getElementById('account-link').classList.remove('active');
            document.getElementById('password-link').classList.remove('active');

        }
        function showAddressSection(){
            document.getElementById('address-book').classList.remove('d-none');
            document.getElementById('my-orders').classList.add('d-none');
            document.getElementById('edit-account').classList.add('d-none');
            document.getElementById('change-password').classList.add('d-none');

            document.getElementById('address-link').classList.add('active');
            document.getElementById('order-link').classList.remove('active');
            document.getElementById('account-link').classList.remove('active');
            document.getElementById('password-link').classList.remove('active');
        }
        function showAccountSection(){
            document.getElementById('edit-account').classList.remove('d-none');
            document.getElementById('address-book').classList.add('d-none');
            document.getElementById('my-orders').classList.add('d-none');
            document.getElementById('change-password').classList.add('d-none');

            document.getElementById('account-link').classList.add('active');
            document.getElementById('address-link').classList.remove('active');
            document.getElementById('order-link').classList.remove('active');
            document.getElementById('password-link').classList.remove('active');
        }
        function showPasswordSection(){
            document.getElementById('change-password').classList.remove('d-none');
            document.getElementById('edit-account').classList.add('d-none');
            document.getElementById('address-book').classList.add('d-none');
            document.getElementById('my-orders').classList.add('d-none');

            document.getElementById('password-link').classList.add('active');
            document.getElementById('account-link').classList.remove('active');
            document.getElementById('address-link').classList.remove('active');
            document.getElementById('order-link').classList.remove('active');
        }
    </script>
    <script>
        // Wait for the DOM to be fully loaded
        document.addEventListener('DOMContentLoaded', function() {
            // Find the success message element
            var successMessage = document.querySelector('.alert');

            // Check if the success message exists
            if (successMessage) {
                // Automatically remove the success message after 5000 milliseconds (5 seconds)
                setTimeout(function() {
                    successMessage.remove();
                }, 5000);
            }
        });
    </script>
    <script>

        $(document).on('change', '#build-type', function () {
            // Get the selected value
            var selectedValue = $(this).val();


            // Log the selected value to the console
            console.log(selectedValue);
            if(selectedValue === "house"){
                $('#house-number').show();
                $('#building_number').hide();
                $('#office').hide();
                $('#apartment').hide();
                $('#floor').hide();
            }else if(selectedValue === "building"){
                $('#house-number').hide();
                $('#building_number').show();
                $('#apartment').show();
                $('#office').hide();
                $('#floor').show();
            }else{
                $('#house-number').hide();
                $('#building_number').show();
                $('#apartment').hide();
                $('#office').show();
                $('#floor').show();
            }

        });


    </script>

    <script>

        $("#add-address-btn").click(function() {

            let area = $("#area").val();



           let ad_type = '<?php echo e($ad_type); ?>';



            if(area === 0){
                toastr.error("please select the area");
                return
            }

            var formData;

            if(ad_type == 'external'){

                formData = {
                    country_ex: $("#country_ex").val(),
                    city_ex: $("#city_ex").val(),
                    line_1_ex: $("#line_1_ex").val(),
                    line_2_ex: $("#line_2_ex").val(),
                    extra_direction_ex: $("#extra_direction_ex").val(),
                    address_type : 'external'
                };

            }else{

                formData = {
                    area: $("#area").val(),
                    block: $("#block").val(),
                    street: $("#street").val(),
                    avenu: $("#avenu").val(),
                    build_type: $("#build-type").val(),
                    house_number: $("#house").val(),
                    building_number: $("#building_number_inp").val(),
                    floor: $("#Floor").val(),
                    apartment: $("#apartment_inp").val(),
                    office_number: $("#office_inp").val(),
                    extra_direction: $("#directions").val(),
                    address_type : 'internal'
                };

            }



            $("#add-address-btn").prop('disabled',true);
            // Send the form data using AJAX
            $.ajax({
                type: "POST",
                url: "<?php echo e(route('address.store')); ?>",
                data: formData,
                success: function(response) {
                    $("#add-address-btn").prop('disabled',false);
                    toastr.success("Address added successfully!");
                    $("#address-container").append(response)
                    $("#area").val("0");
                    $("#block").val("");
                    $("#street").val("");
                    $("#avenu").val("");

                    $("#house").val("");
                    $("#building_number").val("");
                    $("#Floor").val("");
                    $("#apartment").val("");
                    $("#office").val("");
                    $("#directions").val("");

                    $('#addAddress').modal('hide');

                },
                error: function() {
                    $("#add-address-btn").prop('disabled',false);
                    toastr.error("An error occurred. Please try again.");
                }
            });
        });

    </script>

    <script>
        let loader = `<?php echo $__env->make('components.loader', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>`;

        function edit(id) {
           $("#edit-modal-content").html(loader);
           $('#edit-modal').modal('show');
           $("#edit-modal-content").load(`address/${id}/edit`);
        }
    </script>

    <script>
        function deleteRecord(action) {
            console.log(action)
            $("#remove-form").attr('action', action)
            $("#modal-danger").modal('show');
        }
    </script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.front', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\my projects\laravel\sanam\resources\views/front/account.blade.php ENDPATH**/ ?>