<div class="modal-header">
    <h5 class="modal-title"><?php echo app('translator')->get('admin.edit_category'); ?></h5>
    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
</div>
<form action="<?php echo e(route('admin.categories.update', ['category' => $category->id])); ?>" method="post"
    enctype="multipart/form-data">
    <?php echo csrf_field(); ?>
    <?php echo method_field('PUT'); ?>
    <div class="modal-body scrollable-modal">

        <div class="row mt-3">

            <div class="col-12 ">

                <button type="button" onclick="setDir('ltr')" class="btn btn-light ">
                    <!-- Download SVG icon from http://tabler-icons.io/i/align-left -->
                    <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24"
                        viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round"
                        stroke-linejoin="round">
                        <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                        <line x1="4" y1="6" x2="20" y2="6" />
                        <line x1="4" y1="12" x2="14" y2="12" />
                        <line x1="4" y1="18" x2="18" y2="18" />
                    </svg>
                </button>
                <button type="button" onclick="setDir('rtl')" class="btn btn-light ">
                    <!-- Download SVG icon from http://tabler-icons.io/i/align-right -->
                    <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24"
                        viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round"
                        stroke-linejoin="round">
                        <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                        <line x1="4" y1="6" x2="20" y2="6" />
                        <line x1="10" y1="12" x2="20" y2="12" />
                        <line x1="6" y1="18" x2="20" y2="18" />
                    </svg>
                </button>

            </div>

            <div class="col-lg-12 col-md-12 col-sm-12 mt-2">
                <div class="form-group">
                    <label><?php echo app('translator')->get('admin.name'); ?></label>
                    <input class="form-control <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?> direc" type="text" name="name"
                        placeholder="<?php echo app('translator')->get('admin.name'); ?>" value="<?php echo e($category->name); ?>">
                    <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <small class="form-text  text-danger"><?php echo e($message); ?></small>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
            </div>

            <div class="col-lg-4 col-md-4 col-sm-12 mt-2">
                <div class="form-group">
                    <label> صورة التصنيف </label>
                    <input class="form-control <?php $__errorArgs = ['image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?> direc" type="file" name="image"
                        placeholder="صورة التصنيف">
                    <?php $__errorArgs = ['image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <small class="form-text text-danger"><?php echo e($message); ?></small>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                    <?php if($category->image): ?>
                        <img src="<?php echo e(asset($category->image)); ?>" width="60">
                    <?php endif; ?>
                </div>
            </div>

            <div class="col-lg-4 col-md-4 col-sm-12 mt-2">
                <div class="form-group">
                    <label> نوع التصنيف </label>
                    <select class="form-select" id="cat_type_1" name="cat_type">
                        <option <?php if($category->cat_type == 0): ?> selected <?php endif; ?> value="0"> تصنيف كورس </option>
                        <option <?php if($category->cat_type == 1): ?> selected <?php endif; ?> value="1"> تصنيف ورشة </option>
                    </select>
                    <?php $__errorArgs = ['cat_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <small class="form-text text-danger"><?php echo e($message); ?></small>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
            </div>

            <div class="col-lg-4 col-md-4 col-sm-12 mt-2">
                <div class="form-group">
                    <label> التصنيف الأب</label>
                    <select class="form-select" id="father_category_id_1" name="father_category_id">

                        <option <?php if(!$category->father_category): ?> selected <?php endif; ?> value="0">
                            <?php echo e('بدون تصنيف أب'); ?>

                        </option>

                        <?php
                            $sub_categories = App\Models\Category::where('father_category_id', 0)->get();
                        ?>

                        <?php $__currentLoopData = $sub_categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sub_cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option <?php if($category->father_category_id == $sub_cat->id): ?> selected <?php endif; ?> value=<?php echo e($sub_cat->id); ?>

                                data-cat-type="<?php echo e($sub_cat->cat_type); ?>">
                                <?php echo e($sub_cat->name); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    </select>
                    <?php $__errorArgs = ['father_category_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <small class="form-text text-danger"><?php echo e($message); ?></small>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
            </div>

        </div>


    </div>
    <div class="modal-footer">
        <button type="button" class="btn me-auto" data-bs-dismiss="modal"> <?php echo app('translator')->get('admin.close'); ?> </button>
        <button type="submit" class="btn btn-primary"> <?php echo app('translator')->get('admin.save_changes'); ?> </button>
    </div>
</form>


<script>
    changeTypes();
    
    function changeTypes() {
        var selectedCatType = $('#cat_type_1').val();

        $('#father_category_id_1 option').each(function() {
            var optionCatType = $(this).data('cat-type'); // Get the cat_type value from data attribute

            // Show/Hide options based on cat_type
            if (selectedCatType == optionCatType || $(this).val() == "0") {
                $(this).show();
            } else {
                $(this).hide();
            }
        });
    }

    $('#cat_type_1').change(function(e) {
        e.preventDefault();
        changeTypes();
    });
</script>
<?php /**PATH /home/virtualcourt/tls/resources/views/admin/category/edit.blade.php ENDPATH**/ ?>