<?php $__env->startSection('title','Admin Profile'); ?>

<?php $__env->startSection('header-top'); ?>

    <?php echo $__env->make('layouts.inc.top-large-bar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="wrapper">

        <div class="row mt-3" >

            <div class="col-lg-12 col-md-12 col-sm-12">
                <div class="card">
                    <div class="card-body">
                        <h4 class="text-primary mb-3">Update Your Profile </h4>

                        <form action="<?php echo e(route('admin.users.profile')); ?>" method="POST" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>

                            <div class="text-center m-3  ">

                                <img onclick="document.getElementById('img_inp').click()" id="user_profile_image" src="<?php echo e(asset(auth()->user()->image)); ?>" width="130px" height="130px" class="rounded-circle" style="border: 2px solid #eee;" alt="">


                            <div class="row m-3 justify-content-center">
                                <h3 class="user_profile_name"> <?php echo e(auth()->user()->name); ?> </h3>
                                <div class="mt-1">
                                    <span class="badge bg-green-lt"><?php echo e(auth()->user()->role->name); ?></span>
                                </div>
                            </div>
                            </div>
                            <div class="row">

                                <input id="img_inp" type="file" accept="image/*" name="image" class="d-none">

                                <div class="col-lg-4 col-md-6 col-sm-12">
                                    <div class="form-group">
                                        <label>Your Name</label>
                                        <input id="name_inp" class="form-control" type="text" value="<?php echo e(auth()->user()->name); ?>" name="name" placeholder="User Name">
                                        <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <small  class="form-text  text-danger"><?php echo e($message); ?></small>  <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>
                                <div class="col-lg-4 col-md-6 col-sm-12">
                                    <div class="form-group">
                                        <label>Your Email</label>
                                        <input id="email_inp" class="form-control" type="text" value="<?php echo e(auth()->user()->email); ?>" name="email" placeholder="User Email">
                                        <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <small  class="form-text  text-danger"><?php echo e($message); ?></small>  <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>
                                <div class="col-lg-4 col-md-6 col-sm-12">
                                    <div class="form-group">
                                        <label>Type New Password : min 8 char</label>
                                        <input class="form-control" type="text" name="password" placeholder="Strong Password">
                                        <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <small  class="form-text  text-danger"><?php echo e($message); ?></small>  <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>



                            </div>



                            <div class=" wrapper mt-3 text-right justify-content-end" >
                                <button type="submit" class="btn btn-primary">   Save Changes </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    <script>
        let imgInp=document.getElementById('img_inp');
        let user_profile_image=document.getElementById('user_profile_image');

        let name_inp=document.getElementById('name_inp');
        imgInp.onchange = evt => {
            const [file] = imgInp.files
            if (file) {
                user_profile_image.src = URL.createObjectURL(file)
            }
        }
        const inputHandler = function(e) {

                Array.prototype.forEach.call(document.getElementsByClassName("user_profile_name"), function(element) {
                    // Use `element` here
                    element.innerHTML = e.target.value;
                });

        }
        name_inp.addEventListener('input', inputHandler);
        name_inp.addEventListener('propertychange', inputHandler);


    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.tabler-vertical', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\my projects\laravel\sanam\resources\views/admin/users/profile.blade.php ENDPATH**/ ?>