<?php $__env->startSection('styles'); ?>
    <style>
        .bg-sugar{
            background-color: #FAF8F4;
        }
        .fw-bold{
            font-weight: bolder !important;
        }

        .orange{
            font-size: 18px;
            color:#CC7546;
            text-decoration: none;
            font-weight: bold !important;
        }
        .btn-dark{
            --tblr-btn-border-color: #3C3C39;
            --tblr-btn-hover-border-color: #3C3C39;
            --tblr-btn-active-border-color: #3C3C39;
            --tblr-btn-bg: #3C3C39;
            --tblr-btn-disabled-bg: #3C3C39;
        }
    </style>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('page'); ?>

    <?php echo $__env->make('front-component.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>



    <div class="container ">
        <form action="<?php echo e(route('get.invoice.fatoorah')); ?>" method="POST" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>
            <input name="user_type" value="user" hidden>

            <div class="row checkout-section mt-4">
                
                

                
                <div class="col-md-8 p-0" <?php if(app()->getLocale() == "ar"): ?> dir="rtl" <?php endif; ?>>
                    <h1 class="fw-bold mb-4"><?php echo e(__('front.CHECKOUT')); ?></h1>
                    <div class="row ">
                        <div class="col-12 d-flex justify-content-between align-items-center">
                            <h2 class="fw-bold mb-0"><?php echo e(__('front.ADDRESS')); ?> </h2>
                            <div class="btn btn-dark no-radius " data-bs-toggle="modal" data-bs-target="#addAddress">
                                <?php echo e(__('front.Add New Address')); ?>


                            </div>
                        </div>
                    </div>

                    <?php if(count(\Illuminate\Support\Facades\Auth::user()->addresses) == 0): ?>
                        <div class="row mt-3">
                            <div class="col-6">
                                <div class="light-background p-5 text-center" style="background-color: #FAF8F4">
                                    <img src="<?php echo e(asset('assets/media/icons/nothing.svg')); ?>"/>
                                    <h5 class="fw-bold mb-4 mt-3">NO SAVED ADDRESS</h5>
                                    <span>There Is No Saved Address.</span>
                                    <br>
                                    <span>Please Save New Address !</span>
                                </div>
                            </div>
                            <div class="col-6"></div>
                        </div>
                    <?php endif; ?>

                    <div class="row" id="address-container">
                        <?php $__currentLoopData = \Illuminate\Support\Facades\Auth::user()->addresses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $address): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class=" col-lg-6 col-md-6 col-sm-12 col-12  mt-3">
                                <label class="form-selectgroup-item">
                                    <input type="radio" name="address_id" value="<?php echo e($address->id); ?>" class="form-selectgroup-input">
                                    <span class="form-selectgroup-label text-start">
                                      <div class="order-border d-flex flex-column p-3">
                                          <?php if($address->address_type == "internal"): ?>
                                              <span class="fw-bold orange">Kuwait</span>
                                              <span class="fw-bold">area : <?php echo e($address->area); ?> </span>
                                              <span >block <?php echo e($address->block); ?>,street <?php echo e($address->street); ?></span>
                                          <?php else: ?>
                                              <span class="fw-bold orange">
                                           <?php if(is_numeric($address->country)): ?>
                                                      <?php echo e(\App\Models\Country::find($address->country)->name); ?>

                                                  <?php else: ?>
                                                      <?php echo e($address->country); ?>

                                                  <?php endif; ?>
                                              </span>
                                              <span  > city : <?php echo e($address->city); ?> </span>
                                              <span  > line 1 : <?php echo e($address->line_1); ?>  </span>
                                              <span  > line 2 : <?php echo e($address->line_2); ?>  </span>
                                          <?php endif; ?>
                                          <span  > <?php echo e($address->extra_direction); ?>  </span>


                                      </div>
                              </span>
                                </label>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>


                </div>



                <div class="col-md-4 mt-4">
                    <div class="col-12 light-background p-3 mt-4 bg-sugar">
                        <div class="d-flex justify-content-between" <?php if(app()->getLocale() == "ar"): ?> dir="rtl" <?php endif; ?>>
                            <span class="fw-bold mb-4"> <?php echo app('translator')->get('front.coupon_code'); ?> </span>
                            <span id="coupon-result-message" class="<?php if(session()->has('coupon')): ?> text-green <?php endif; ?>">
                                <?php if(session()->has('coupon')): ?> <?php echo app('translator')->get('front.applied_successfully'); ?> <?php endif; ?>
                            </span>
                        </div>
                        <div class="input-group flex-nowrap mb-3">
                            <?php if(session()->has('coupon')): ?>
                                <?php
                                    $copoun = \App\Models\CouponCode::find(session()->get('coupon'));
                                ?>

                            <?php endif; ?>

                            <input id="coupon-code-input"  <?php if(session()->has('coupon')): ?> value="<?php echo e($copoun->code); ?>" <?php endif; ?> type="text" class="form-control no-radius" placeholder="<?php echo app('translator')->get('front.enter_here'); ?>" aria-label="Recipient's username" aria-describedby="button-addon2">


                            <button onclick="applyCouponeCode()" class="btn no-radius apply " style="background-color: #CC7546;color:#fff; <?php if(!session()->has('coupon')): ?>  display: inline-block; <?php else: ?>  display: none;  <?php endif; ?> " type="button" id="apply_coupon_btn"><?php echo app('translator')->get('front.apply'); ?></button>

                            <button onclick="removeCouponeCode()" type="button" class="btn no-radius btn-dark " id="remove_coupon_btn" style=" <?php if(!session()->has('coupon')): ?>  display: none; <?php else: ?>  display: inline-block;  <?php endif; ?>  color:#fff"><?php echo app('translator')->get('front.remove'); ?></button>

                        </div>
                    </div>
                    <div class="col-12 light-background p-3 mt-4 bg-sugar">
                        <h2 class="fw-bold mb-4  " <?php if(app()->getLocale() == "ar"): ?> dir="rtl" <?php endif; ?>><?php echo e(__('front.PAYMENT METHOD')); ?>   </h2>
                        <?php if($ad_type != "external"): ?>
                        <div class="input-group d-flex justify-content-between mb-2 p-3" style="background-color: white">
                            <div>
                                <img src="<?php echo e(asset('assets/media/icons/knet.svg')); ?>" class="rounded-1 me-2"/>
                                <span>KNet</span>
                            </div>
                            <div class="form-check m-0 d-flex align-items-center">
                                <input class="form-check-input" type="radio" value="knet" name="payment_type" id="method">
                            </div>
                        </div>
                        <?php endif; ?>
                        <div class="input-group d-flex justify-content-between mb-2 p-3" style="background-color: white">
                            <div>
                                <img src="<?php echo e(asset('assets/media/icons/visa-mastercard.svg')); ?>" class="rounded-1 me-2"/>
                                <span>VISA/MASTERCARD</span>
                            </div>
                            <div class="form-check m-0 d-flex align-items-center">
                                <input class="form-check-input" type="radio" value="credit" name="payment_type" id="method">
                            </div>
                        </div>









                    </div>
                    <div class="col-12 light-background p-3 mt-4 mb-4 bg-sugar" <?php if(app()->getLocale() =="ar" ): ?> dir="rtl" <?php endif; ?>>
                        <h2 class="fw-bold mb-4"><?php echo e(__('front.payment_details')); ?></h2>
                        <div class="d-flex justify-content-between mb-2">
                            <span><?php echo e(__('front.sub_total')); ?></span>
                            <span id="total-div" dir="ltr"><?php echo e($total_amount); ?></span>
                        </div>
                        <div class="d-flex justify-content-between mb-2">
                            <span><?php echo e(__('front.discount')); ?></span>
                            <span id="discount-div" dir="ltr"> - <?php echo e($discount); ?></span>
                        </div>
                        <div class="d-flex justify-content-between mb-2">
                            <span><?php echo e(__('front.delivery_charges')); ?></span>
                            <span id="delivery-div" dir="ltr"><?php echo e($delivery_charges); ?></span>
                        </div>
                        <div class="d-flex justify-content-between mb-4">
                            <span class="fw-bold"><?php echo e(__('front.total')); ?></span>
                            <span id="final-div" class="fw-bold" dir="ltr"><?php echo e($final_amount); ?></span>
                        </div>
                        <div class="d-flex justify-content-center">
                            <button type="submit" class="btn btn-dark w-100 no-radius">
                                <?php echo e(__('front.proceed_to_checkout')); ?>

                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </form>

    </div>




























































    <div class="modal fade" id="addAddress" tabindex="-1" aria-labelledby="addAddressLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content no-radius">


                <div class="modal-body mt-0 ">
                    <div class="row mb-2">

                        <div class="col-12 d-flex align-items-center">
                            <span class="h1 text-center w-100 fw-bold mb-0 "> <?php echo e(__('front.Add New Address')); ?> </span>
                            <span type="button" class="  close-modal p-0 mb-0 flex-1 " data-bs-dismiss="modal">
                                <svg xmlns="http://www.w3.org/2000/svg" width="34.399" height="34.399" viewBox="0 0 34.399 34.399">
                                    <g id="cancel_3_" data-name="cancel (3)" transform="translate(0 -0.005)">
                                        <g id="Group_50679" data-name="Group 50679" transform="translate(0 0.005)">
                                            <path id="Path_142368" data-name="Path 142368" d="M29.367,5.037a17.2,17.2,0,1,0,0,24.336A17.227,17.227,0,0,0,29.367,5.037ZM24.3,22.275A1.434,1.434,0,1,1,22.269,24.3L17.2,19.232,12.132,24.3A1.434,1.434,0,0,1,10.1,22.273L15.172,17.2,10.1,12.135a1.434,1.434,0,0,1,2.028-2.028L17.2,15.177l5.069-5.069A1.434,1.434,0,0,1,24.3,12.135L19.228,17.2Z" transform="translate(0 -0.005)" fill="#cc7546"/>
                                        </g>
                                    </g>
                                </svg>
                           </span>
                        </div>

                    </div>
                    <div class="container m-0 p-0 vh-50 overflow-y-auto">

                        <?php if($ad_type == 'internal'): ?>
                            <?php echo $__env->make('front-component.internal-form', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        <?php else: ?>
                            <?php echo $__env->make('front-component.external-form', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        <?php endif; ?>



                    </div>
                    <div class="row">

                        <div class="col-12 px-5 mb-4">
                            <button id="add-address-btn" class="btn btn-dark w-100 no-radius">
                                <?php echo e(__('front.Add New Address')); ?>

                            </button>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>



    <br>



    <?php echo $__env->make('front-component.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    <script>

        function applyCouponeCode(){

            let coupon = $("#coupon-code-input").val();
            let messageDiv  = $("#coupon-result-message");

            $('#apply_coupon_btn').prop('disabled', true);

            $.ajax({
                url: '/apply/coupon', // Replace with your actual route
                type: 'POST',
                data: {
                    coupon_code : coupon
                },
                success: function (response) {
                    // Assuming you return a JSON response with a 'success' property

                          // Hide the apply button and display the remove button
                        $('#apply_coupon_btn').prop('disabled', false);
                        console.log(response.process)
                        // Add the remove button click event to remove the coupon

                        if(response.process === "yes"){
                            $('#apply_coupon_btn').hide();
                            $('#remove_coupon_btn').css('display','inline-block');

                            $("#discount-div").html(response.discount);
                            $("#total-div").html(response.total_amount);
                            $("#final-div").html(response.final_amount);
                            $("#delivery-div").html(response.delivery_charges);

                            $("#coupon-result-message").css("color", "green");
                        }else{
                            $('#apply_coupon_btn').prop('disabled', false);
                            $("#coupon-result-message").css("color", "red");
                        }
                        let message = response.message;
                        messageDiv.html(message);

                },
                error: function (error) {
                    $('#apply_coupon_btn').prop('disabled', false);

                }
            });




        }

        function removeCouponeCode(){
            window.location.href = "/remove/guest/coupon"
        }


    </script>


    <script>

        $(document).on('change', '#build-type', function () {
            // Get the selected value
            var selectedValue = $(this).val();


            // Log the selected value to the console
            console.log(selectedValue);
            if(selectedValue === "house"){
                $('#house-number').show();
                $('#building_number').hide();
                $('#office').hide();
                $('#apartment').hide();
                $('#floor').hide();
            }else if(selectedValue === "building"){
                $('#house-number').hide();
                $('#building_number').show();
                $('#apartment').show();
                $('#office').hide();
                $('#floor').show();
            }else{
                $('#house-number').hide();
                $('#building_number').show();
                $('#apartment').hide();
                $('#office').show();
                $('#floor').show();
            }

        });


    </script>

    <script>

        $("#add-address-btn").click(function() {

            let area = $("#area").val();



            let ad_type = '<?php echo e($ad_type); ?>';



            if(area === 0){
                toastr.error("please select the area");
                return
            }

            var formData;

            if(ad_type == 'external'){

                formData = {
                    country_ex: $("#country_ex").val(),
                    city_ex: $("#city_ex").val(),
                    line_1_ex: $("#line_1_ex").val(),
                    line_2_ex: $("#line_2_ex").val(),
                    extra_direction_ex: $("#extra_direction_ex").val(),
                    address_type : 'external'
                };

            }else{

                formData = {
                    area: $("#area").val(),
                    block: $("#block").val(),
                    street: $("#street").val(),
                    avenu: $("#avenu").val(),
                    build_type: $("#build-type").val(),
                    house_number: $("#house").val(),
                    building_number: $("#building_number_inp").val(),
                    floor: $("#Floor").val(),
                    apartment: $("#apartment_inp").val(),
                    office_number: $("#office_inp").val(),
                    extra_direction: $("#directions").val(),
                    address_type : 'internal'
                };

            }



            $("#add-address-btn").prop('disabled',true);
            // Send the form data using AJAX
            $.ajax({
                type: "POST",
                url: "<?php echo e(route('address.authed.store')); ?>",
                data: formData,
                success: function(response) {
                    $("#add-address-btn").prop('disabled',false);
                    toastr.success("Address added successfully!");
                    $("#address-container").append(response)
                    $("#area").val("0");
                    $("#block").val("");
                    $("#street").val("");
                    $("#avenu").val("");

                    $("#house").val("");
                    $("#building_number").val("");
                    $("#Floor").val("");
                    $("#apartment").val("");
                    $("#office").val("");
                    $("#directions").val("");

                    $('#addAddress').modal('hide');

                },
                error: function() {
                    $("#add-address-btn").prop('disabled',false);
                    toastr.error("An error occurred. Please try again.");
                }
            });
        });

    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.front', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\my projects\laravel\sanam\resources\views/front/check-out.blade.php ENDPATH**/ ?>