<?php $__env->startSection('title', 'Admin Settings'); ?>



<?php $__env->startSection('header-top'); ?>
    <style>
        .shrink-text {
            overflow: hidden;
            text-overflow: ellipsis;
            white-space: nowrap;
            display: inline-block;
            max-width: 150px;
            width: 86px;
            height: 17px;
        }
    </style>
    <?php echo $__env->make('layouts.inc.top-large-bar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div class="page-wrapper ">
        <div class="wrapper">
            <!-- Page title -->


            <div class="page-header d-print-none">
                <div class="row align-items-center">
                    <div class="col">
                        <!-- Page pre-title -->

                        <h2 class="page-title">
                            <?php echo e(__('admin.settings')); ?>

                        </h2>
                    </div>

                    <div class="col">
                        <a href="<?php echo e(route('admin.settings.index', ['type' => 'app'])); ?>"
                            class="btn btn-outline-warning ms-2"><?php echo e(__('app')); ?></a>
                    </div>

                    <div class="col">
                        <a href="<?php echo e(route('admin.settings.index', ['type' => 'dash'])); ?>"
                            class="btn btn-outline-success ms-2"><?php echo e(__('dash')); ?></a>
                    </div>

                    <!-- Page title actions -->
                    <div class="col-auto ms-auto d-print-none">
                        <div class="btn-list">

                            <a href="#" class="btn btn-indigo d-none d-sm-inline-block" data-bs-toggle="modal"
                                data-bs-target="#modal-large">
                                <!-- Download SVG icon from http://tabler-icons.io/i/plus -->
                                <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24"
                                    viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none"
                                    stroke-linecap="round" stroke-linejoin="round">
                                    <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                    <line x1="12" y1="5" x2="12" y2="19" />
                                    <line x1="5" y1="12" x2="19" y2="12" />
                                </svg>
                                <?php echo e(__('admin.create_new_record')); ?>

                            </a>
                            <a href="#" class="btn btn-indigo d-sm-none btn-icon" data-bs-toggle="modal"
                                data-bs-target="#modal-large" aria-label="Create new report">
                                <!-- Download SVG icon from http://tabler-icons.io/i/plus -->
                                <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24"
                                    viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none"
                                    stroke-linecap="round" stroke-linejoin="round">
                                    <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                    <line x1="12" y1="5" x2="12" y2="19" />
                                    <line x1="5" y1="12" x2="19" y2="12" />
                                </svg>
                            </a>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="wrapper ">
        <div class="row">
            <div class="col-lg-12 col-md-12 col-sm-12">

                <div class="card">
                    <div class="card-body">

                        <h3> <?php echo e(__('admin.project_variables')); ?> </h3>


                        <div class="table-responsive">
                            <table class="table table-vcenter card-table">
                                <thead>
                                    <tr>
                                        <th><?php echo e(__('admin.key')); ?></th>
                                        <th><?php echo e(__('admin.value')); ?></th>
                                        <th><?php echo e(__('admin.type')); ?></th>
                                        <th><?php echo e(__('admin.description')); ?></th>
                                        <th><?php echo e(__('admin.created_at')); ?></th>
                                        <th><?php echo e(__('admin.updated_at')); ?></th>
                                        <th><?php echo e(__('admin.actions')); ?></th>
                                    </tr>
                                </thead>
                                <tbody>


                                    <?php $__currentLoopData = $settings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $setting): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td> <?php echo e($setting->key); ?> </td>
                                            <td>
                                                <span> <?php echo e($setting->value); ?> </span>
                                            </td>

                                            <td> <?php echo e($setting->type); ?> </td>
                                            <td> <?php echo e($setting->description); ?> </td>

                                            <td><?php echo e($setting->created_at->diffForHumans()); ?></td>
                                            <td><?php echo e($setting->updated_at->diffForHumans()); ?></td>
                                            <td>

                                                <button type="button" href="#" class="btn btn-ghost-success "
                                                    onclick="edit('<?php echo e($setting->id); ?>')">
                                                    <?php echo e(__('admin.edit')); ?>

                                                </button>

                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                                </tbody>
                            </table>

                        </div>
                    </div>

                </div>
            </div>
        </div>

        
<div class="modal modal-blur fade" id="modal-large" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"> <?php echo e(__('admin.create_new_setting')); ?> </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form action="<?php echo e(route('admin.settings.store')); ?>" method="post">
                <?php echo csrf_field(); ?>
                <div class="modal-body scrollable-modal">
                    <div class="row mt-3">

                        <div class="col-lg-12 col-md-12 col-sm-12">
                            <div class="form-group">
                                <label><?php echo e(__('admin.key')); ?></label>
                                <input class="form-control" type="text" name="key" required>
                                <?php $__errorArgs = ['key'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <small class="form-text text-danger"><?php echo e($message); ?></small>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>

                        <div class="col-lg-12 col-md-12 col-sm-12 mt-2">
                            <div class="form-group">
                                <label><?php echo e(__('admin.value')); ?></label>
                                <textarea class="form-control" rows="5" name="value" required></textarea>
                                <?php $__errorArgs = ['value'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <small class="form-text text-danger"><?php echo e($message); ?></small>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>

                        <div class="col-lg-12 col-md-12 col-sm-12 mt-2">
                            <div class="form-group">
                                <label><?php echo e(__('admin.type')); ?></label>
                                <select class="form-control" name="type">
                                    <option value="app">app</option>
                                    <option value="dash">dash</option>
                                </select>
                                <?php $__errorArgs = ['type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <small class="form-text text-danger"><?php echo e($message); ?></small>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>

                        <div class="col-lg-12 col-md-12 col-sm-12 mt-2">
                            <div class="form-group">
                                <label><?php echo e(__('admin.description')); ?></label>
                                <input class="form-control" type="text" name="description">
                                <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <small class="form-text text-danger"><?php echo e($message); ?></small>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>

                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn me-auto" data-bs-dismiss="modal">
                        <?php echo e(__('admin.close')); ?>

                    </button>
                    <button type="submit" class="btn btn-primary">
                        <?php echo e(__('admin.create_setting')); ?>

                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

        

        <div class="modal modal-blur fade" id="edit-modal" tabindex="-1" role="dialog" aria-hidden="true">
            <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
                <div class="modal-content" id="edit-modal-content">

                </div>
            </div>
        </div>


    <?php $__env->stopSection(); ?>

    <?php $__env->startPush('scripts'); ?>
        <script>
            let loader = `<?php echo $__env->make('components.loader', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>`;

            function edit(id) {
                $("#edit-modal-content").html(loader);
                $('#edit-modal').modal('show');
                $("#edit-modal-content").load(`admin/settings/${id}/edit`);
            }
        </script>
    <?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.tabler-vertical', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/virtualcourt/tls/resources/views/admin/settings/index.blade.php ENDPATH**/ ?>