<?php $__env->startSection('title','Admin Settings'); ?>
<?php $__env->startPush('styles'); ?>
    <?php echo \Livewire\Livewire::styles(); ?>

<?php $__env->stopPush(); ?>
<?php $__env->startSection('header-top'); ?>
    <style>
        .table-responsive .dropdown,
        .table-responsive .btn-group,
        .table-responsive .btn-group-vertical {
            position: static;
        }
    </style>
    <?php echo $__env->make('layouts.inc.top-large-bar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div class="page-wrapper ">
        <div class="wrapper">
            <!-- Page title -->
            <div class="page-header d-print-none">
                <div class="row align-items-center">
                    <div class="col">
                        <!-- Page pre-title -->

                        <h2 class="page-title">
                            Orders
                        </h2>
                    </div>
                    <!-- Page title actions -->
                    <div class="col-auto ms-auto d-print-none">
                            <a href="<?php echo e(route('admin.orders.export')); ?>" class="btn btn-indigo btn-sm"> Export As PDF</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <div class="wrapper ">
        <div class="row">
            <div class="col-lg-12 col-md-12 col-sm-12 mt-2">

                <div class="card">
                    <div class="card-body">

                        <div class="table-responsive">
                            <table class="table table-vcenter card-table">
                                <thead>
                                <tr>
                                    <th>id</th>
                                    <th>order_number</th>
                                    <th>payment_type</th>
                                    <th>status</th>
                                    <th>discount</th>
                                    <th>total_amount</th>
                                    <th>delivery_charges</th>
                                    <th>final_amount</th>
                                    <th>created at</th>
                                    <th>updated at</th>
                                    <th>Actions</th>
                                </tr>
                                </thead>
                                <tbody>


                                <?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($order->id); ?></td>
                                        <td><?php echo e($order->order_number); ?></td>
                                        <td><?php echo e($order->payment_type); ?></td>
                                        <td>
                                            <?php if($order->status == "failed"): ?>
                                            <b class="text-red"> <?php echo e($order->status); ?> </b>
                                            <?php endif; ?>
                                            <?php if($order->status == "success"): ?>
                                                    <b class="text-green"> <?php echo e($order->status); ?> </b>
                                            <?php endif; ?>
                                            <?php if($order->status == "pending"): ?>
                                                    <b class="text-yellow"> <?php echo e($order->status); ?> </b>
                                            <?php endif; ?>

                                        </td>
                                        <td><?php echo e($order->discount); ?></td>
                                        <td><?php echo e($order->total_amount); ?></td>
                                        <td><?php echo e($order->delivery_charges); ?></td>
                                        <td><?php echo e($order->final_amount); ?></td>
                                        <td><?php echo e(substr( $order->created_at,0,10)); ?></td>
                                        <td><?php echo e($order->updated_at->diffForHumans()); ?></td>
                                        <td>

                                            <?php if(auth()->user()->hasPermission('update order')): ?>
                                              <span class="dropdown">
                                                  <button class="btn dropdown-toggle align-text-top" data-bs-boundary="viewport" data-bs-toggle="dropdown">Actions</button>
                                                  <div class="dropdown-menu dropdown-menu-end">

                                                          <a href="<?php echo e(route('admin.orders.show',['order'=>$order->id])); ?>" class="dropdown-item text-drop-down" >invoice</a>

                                                        <?php if($order->status == "success"): ?>
                                                          <a href="<?php echo e(route('admin.orders.toggle',['state'=>'failed','id'=>$order->id])); ?>" class="dropdown-item text-drop-down" >make failed</a>
                                                          <a href="<?php echo e(route('admin.orders.toggle',['state'=> 'pending','id'=>$order->id])); ?>" class="dropdown-item text-drop-down" >make pending</a>
                                                        <?php endif; ?>

                                                          <?php if($order->status == "pending"): ?>
                                                              <a href="<?php echo e(route('admin.orders.toggle',['state'=>'failed','id'=>$order->id])); ?>" class="dropdown-item text-drop-down" >make failed</a>
                                                              <a href="<?php echo e(route('admin.orders.toggle',['state'=>'success','id'=>$order->id])); ?>" class="dropdown-item text-drop-down" >make success</a>
                                                          <?php endif; ?>

                                                          <?php if($order->status == "failed"): ?>
                                                              <a href="<?php echo e(route('admin.orders.toggle',['state'=> 'success','id'=>$order->id])); ?>" class="dropdown-item text-drop-down" >make success</a>
                                                              <a href="<?php echo e(route('admin.orders.toggle',['state'=>'pending','id'=>$order->id])); ?>" class="dropdown-item text-drop-down" >make pending</a>
                                                          <?php endif; ?>
                                                  </div>
                                                </span>


                                            <?php endif; ?>



                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                                </tbody>
                            </table>

                        </div>
                        <div class="row">
                            <div class="pagination">
                                <?php echo $orders->links(); ?>

                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>



        
        <div class="modal modal-blur fade" id="modal-large" tabindex="-1" role="dialog" aria-hidden="true">
            <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Create New Product</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <form action="<?php echo e(route('admin.products.store')); ?>" method="post" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <div class="modal-body scrollable-modal">

                            <div class="row mt-3">

                                <div class="col-lg-6 col-md-6 col-sm-12">
                                    <div class="form-group">
                                        <label>name</label>
                                        <input class="form-control <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" type="text" name="name" placeholder="name">
                                        <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <small class="form-text  text-danger"><?php echo e($message); ?></small> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>
                                <div class="col-lg-6 col-md-6 col-sm-12">
                                    <div class="form-group">
                                        <label>category</label>
                                        <select class="form-select" type="text" name="category_id"  >

                                            <?php $__currentLoopData = \App\Models\Category::all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($category->id); ?>"><?php echo e($category->name); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                        <?php $__errorArgs = ['category_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <small class="form-text  text-danger"><?php echo e($message); ?></small> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>
                                <div class="col-lg-6 col-md-6 col-sm-12">
                                    <div class="form-group">
                                        <label>size</label>
                                        <select class="form-select" name="size"  >

                                            <option value="small">small</option>
                                            <option value="medium">medium</option>
                                            <option value="large">large</option>
                                            <option value="xl">xl</option>
                                            <option value="xxl">xxl</option>
                                            <option value="xxx l">xxx l</option>

                                        </select>
                                        <?php $__errorArgs = ['size'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <small class="form-text  text-danger"><?php echo e($message); ?></small> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>
                                <div class="col-lg-6 col-md-6 col-sm-12">
                                    <div class="form-group">
                                        <label>price</label>
                                        <input class="form-control <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" type="text" name="price" placeholder="price">
                                        <?php $__errorArgs = ['price'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <small class="form-text  text-danger"><?php echo e($message); ?></small> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>


                                <div class="col-lg-12 col-md-12 col-sm-12">
                                    <div class="form-group">
                                        <label>description</label>
                                        <textarea class="form-control <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" type="text" name="description" placeholder="description"></textarea>
                                        <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <small class="form-text  text-danger"><?php echo e($message); ?></small> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>
                                <?php echo $__env->make('components.intelegent_image_uploader',['image_input_name'=>'image','title'=>'product image','cssclass'=>''], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            </div>



                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn me-auto" data-bs-dismiss="modal">Close</button>
                            <button type="submit" class="btn btn-primary">
                                Create Product
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        

        <div class="modal modal-blur fade" id="edit-modal" tabindex="-1" role="dialog" aria-hidden="true">
            <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
                <div class="modal-content" id="edit-modal-content">

                </div>
            </div>
        </div>

        <?php echo $__env->make('components.remove-modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php $__env->stopSection(); ?>

        <?php $__env->startPush('scripts'); ?>

            <script>
                let loader = `<?php echo $__env->make('components.loader', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>`;

                function edit(id) {
                    $("#edit-modal-content").html(loader);
                    $('#edit-modal').modal('show');
                    $("#edit-modal-content").load(`admin/products/${id}/edit`);
                }
            </script>
            <script>
                function deleteRecord(action) {
                    console.log(action)
                    $("#remove-form").attr('action', action)
                    $("#modal-danger").modal('show');
                }

            </script>
    <?php echo \Livewire\Livewire::scripts(); ?>

    <?php $__env->stopPush(); ?>


<?php echo $__env->make('layouts.tabler-vertical', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\Reham\taphone\resources\views/admin/orders/index.blade.php ENDPATH**/ ?>