<style>
    /* Navbar */

    .navbar,.content-nav{
        background-color: white !important;
        border-bottom: 1px solid #F1EBDF;
        font-size: 18px;
    }
    .content-nav{
        padding-left: 10rem;
        padding-right: 10rem;
    }

    .navbar-collapse{
        flex-grow: initial !important;
    }
    .search-button{
        background-color: white;
    }
    .navbar-brand img{
        width:100px !important;
    }
    .navbar .container-fluid {
        padding-left: 7rem !important;
        padding-right:7rem !important;
    }
    .search-form{
        width:400px;
    }
    .search-form .form-control:focus{
        border:none !important;
        outline: none !important;
        box-shadow: none;
    }
    .link-active{
        color:#CC7546;
        font-weight: bolder !important;
    }
    .nav-link{
        font-weight: bold;
        font-size: 16px;
    }
    .navbar-toggler{
        border:none !important;
        box-shadow: none !important;
    }

    @media (max-width: 670px) {
        .navbar .container-fluid {
            padding-left: 1rem !important;
            padding-right:1rem !important;
        }
    }

    .offcanvas{
        width:50%;
    }
    @media (max-width: 767px) {
        .offcanvas{
            width:75% !important
        }
    }

    @media (min-width: 576px) and (max-width: 1250px) {
        .navbar .container-fluid {
            padding-left: 1rem !important;
            padding-right: 1rem !important;
        }
    }

</style>

<?php
$country = \App\Http\Helpers\SettingHelper::getCurrentCountry();
?>
<nav class="navbar navbar-expand-lg bg-body-tertiary">
    <div class="container-fluid">
        <form action="<?php echo e(route('search')); ?>" method="POST" class="d-none d-lg-flex search-form" role="search">
            <?php echo csrf_field(); ?>
            <div class="input-group border">
                <input name="keyword" class="form-control border-0" type="search" placeholder="<?php echo app('translator')->get('front.Search For Products'); ?>" aria-label="Search">
                <button class="btn search-button border-0" type="submit">
                    <img src="<?php echo e(asset('assets/media/icons/search.svg')); ?>">
                </button>
            </div>
        </form>
        <button class="navbar-toggler" type="button" data-bs-toggle="offcanvas" href="#offcanvasExample" role="button" aria-controls="offcanvasExample">
            
            <svg xmlns="http://www.w3.org/2000/svg" width="32" height="23.969" viewBox="0 0 32 23.969">
                <g id="menu_5_" data-name="menu (5)" transform="translate(0 -4.016)">
                    <path id="Path_142372" data-name="Path 142372" d="M1.945,7.906h28.11a1.945,1.945,0,0,0,0-3.89H1.945a1.945,1.945,0,1,0,0,3.89Z" fill="#cc7546"/>
                    <path id="Path_142373" data-name="Path 142373" d="M30.055,14.055H1.945a1.945,1.945,0,1,0,0,3.89h28.11a1.945,1.945,0,0,0,0-3.89Z" fill="#cc7546"/>
                    <path id="Path_142374" data-name="Path 142374" d="M30.055,24.094H1.945a1.945,1.945,0,0,0,0,3.891h28.11a1.945,1.945,0,0,0,0-3.891Z" fill="#cc7546"/>
                </g>
            </svg>
        </button>
        <a class="navbar-brand text-center p-2" href="<?php echo e(route('home')); ?>"><img src="<?php echo e(asset('assets/media/logo/logo.svg')); ?>"/></a>
        <div class="d-block d-lg-none">
            <a class="nav-link" aria-current="page" href="<?php echo e(route('cart.page')); ?>"><img class="me-2" src="<?php echo e(asset('assets/media/icons/shopping-bag.svg')); ?>"/></a>
        </div>

        
        <div class="collapse navbar-collapse" id="navbarSupportedContent" >
            <ul class="navbar-nav me-auto mb-2 mb-lg-0">
                <li class="nav-item d-lg-none">
                    <a <?php if(Route::currentRouteName()=='home'): ?> class="nav-link link-active" <?php else: ?> class="nav-link" <?php endif; ?> aria-current="page" href="<?php echo e(route('home')); ?>"><?php echo app('translator')->get('front.home'); ?></a>
                </li>
                <li class="nav-item d-lg-none">
                    <a <?php if(Route::currentRouteName()=='categories'): ?> class="nav-link link-active" <?php else: ?> class="nav-link" <?php endif; ?> aria-current="page" href="<?php echo e(route('categories')); ?>"><?php echo app('translator')->get('front.categories'); ?></a>
                </li>
                <li class="nav-item d-lg-none">
                    <a <?php if(Route::currentRouteName()=='offers'): ?> class="nav-link link-active" <?php else: ?> class="nav-link" <?php endif; ?> aria-current="page" href="<?php echo e(route('offers')); ?>"><?php echo app('translator')->get('front.offers'); ?></a>
                </li>
                <li class="nav-item d-lg-none">
                    <a <?php if(Route::currentRouteName()=='aboutUs'): ?> class="nav-link link-active" <?php else: ?> class="nav-link" <?php endif; ?> aria-current="page" href="<?php echo e(route('aboutUs')); ?>"><?php echo app('translator')->get('front.about_us'); ?></a>
                </li>
                <li class="nav-item d-lg-none">
                    <a class="nav-link" aria-current="page" href="<?php echo e(route('contact')); ?>"><?php echo app('translator')->get('front.contact'); ?></a>
                </li>


                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle"  role="button" data-bs-toggle="dropdown" aria-expanded="false">
                        <img class="me-2" src="<?php echo e(asset($country->flag)); ?>"/> <?php echo e($country->name); ?> (<?php echo e($country->currency); ?>)
                    </a>
                    <ul class="dropdown-menu">
                        <li>
                            <a class="dropdown-item" href="<?php echo e(route('set.country',['country'=>'KWD'])); ?>">
                                <img class="me-2" src="<?php echo e(asset('assets/media/flags/KW.svg')); ?>"/>Kuwait(KWD)
                            </a>
                        </li>
                        <hr>
                        <li>
                            <a class="dropdown-item" href="<?php echo e(route('set.country',['country'=>'SAR'])); ?>">
                                <img class="me-2" src="<?php echo e(asset('assets/media/flags/SA.svg')); ?>"/>Saudi(SAR)
                            </a>
                        </li>

                        <hr>
                        <li>
                            <a class="dropdown-item" href="<?php echo e(route('set.country',['country'=>'QAR'])); ?>">
                                <img class="me-2" src="<?php echo e(asset('assets/media/flags/QA.svg')); ?>"/>Qatar(QAR)
                            </a>
                        </li>
                        <hr>
                        <li>
                            <a class="dropdown-item" href="<?php echo e(route('set.country',['country'=>'OMR'])); ?>">
                                <img class="me-2" src="<?php echo e(asset('assets/media/flags/OM.svg')); ?>"/>Oman(OMR)
                            </a>
                        </li>
                        <hr>
                        <li>
                            <a class="dropdown-item" href="<?php echo e(route('set.country',['country'=>'BHD'])); ?>">
                                <img class="me-2" src="<?php echo e(asset('assets/media/flags/BH.svg')); ?>"/>Bahrain(BHD)
                            </a>
                        </li>
                        <hr>
                        <li>
                            <a class="dropdown-item" href="<?php echo e(route('set.country',['country'=>'AED'])); ?>">
                                <img class="me-2" src="<?php echo e(asset('assets/media/flags/AE.svg')); ?>"/>UAE(AED)
                            </a>
                        </li>
                    </ul>
                </li>

                <li class="nav-item dropdown">

                    <a class="nav-link dropdown-toggle"  role="button" data-bs-toggle="dropdown" aria-expanded="false">
                        <img class="me-2" src="<?php echo e(asset('assets/media/icons/globe.svg')); ?>"/>
                        <?php if(app()->getLocale() == "ar"): ?>
                            العربية
                        <?php else: ?>
                            English
                        <?php endif; ?>
                    </a>

                    <ul class="dropdown-menu">
                        <li>
                            <a class="dropdown-item" href="<?php echo e(route('set.language',['lang'=>'ar'])); ?>">
                                <img class="me-2" src="<?php echo e(asset('assets/media/icons/globe.svg')); ?>"/>العربية
                            </a>
                        </li>
                        <li>
                            <a class="dropdown-item" href="<?php echo e(route('set.language',['lang'=>'en'])); ?>">
                                <img class="me-2" src="<?php echo e(asset('assets/media/icons/globe.svg')); ?>"/> English
                            </a>
                        </li>
                    </ul>

                </li>
                <li class="nav-item">
                    <a class="nav-link" aria-current="page" href="<?php echo e(route('wishlist')); ?>">
                        <img class="me-md-2" src="<?php echo e(asset('assets/media/icons/heart.svg')); ?>"/>
                        <span class="d-lg-none"><?php echo app('translator')->get('front.wishlist'); ?></span>
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" aria-current="page" href="<?php echo e(asset('account')); ?>">
                        <img class="me-2" src="<?php echo e(asset('assets/media/icons/user.svg')); ?>"/>
                        <span class="d-lg-none"><?php echo app('translator')->get('front.account'); ?></span>
                    </a>
                </li>
                <li class="nav-item d-none d-md-block">
                    <a class="nav-link" aria-current="page" href="<?php echo e(route('cart.page')); ?>"><img class="me-2" src="<?php echo e(asset('assets/media/icons/shopping-bag.svg')); ?>"/></a>
                </li>
            </ul>
        </div>
    </div>
</nav>

<div class="offcanvas offcanvas-start" tabindex="-1" id="offcanvasExample" aria-labelledby="offcanvasExampleLabel" <?php if(app()->getLocale() == "ar"): ?> dir="rtl" <?php endif; ?>>
    <div class="offcanvas-header d-flex justify-content-center">
        <img width="119px" src="<?php echo e(asset('assets/media/logo/logo.svg')); ?>"/>
    </div>
    <div class="offcanvas-body px-4">
        <ul class="navbar-nav me-auto mb-2 mb-lg-0">
            <li class="nav-item d-lg-none mb-4">
                <a <?php if(Route::currentRouteName()=='home'): ?> class="nav-link link-active" <?php else: ?> class="nav-link" <?php endif; ?> aria-current="page" href="<?php echo e(route('home')); ?>"><?php echo app('translator')->get('front.home'); ?></a>
            </li>
            <li class="nav-item d-lg-none mb-4">
                <a <?php if(Route::currentRouteName()=='categories'): ?> class="nav-link link-active" <?php else: ?> class="nav-link" <?php endif; ?> aria-current="page" href="<?php echo e(route('categories')); ?>"><?php echo app('translator')->get('front.categories'); ?></a>
            </li>
            <li class="nav-item d-lg-none mb-4">
                <a <?php if(Route::currentRouteName()=='offers'): ?> class="nav-link link-active" <?php else: ?> class="nav-link" <?php endif; ?> aria-current="page" href="<?php echo e(route('offers')); ?>"><?php echo app('translator')->get('front.offers'); ?></a>
            </li>
            <li class="nav-item d-lg-none mb-4">
                <a <?php if(Route::currentRouteName()=='aboutUs'): ?> class="nav-link link-active" <?php else: ?> class="nav-link" <?php endif; ?> aria-current="page" href="<?php echo e(route('aboutUs')); ?>"><?php echo app('translator')->get('front.about_us'); ?></a>
            </li>
            <li class="nav-item d-lg-none mb-5">
                <a <?php if(Route::currentRouteName()=='contact'): ?> class="nav-link link-active" <?php else: ?> class="nav-link" <?php endif; ?> aria-current="page" href="<?php echo e(route('contact')); ?>"><?php echo app('translator')->get('front.contact'); ?></a>
            </li>

            <li class="nav-item mb-3">
                <a class="nav-link" aria-current="page" href="<?php echo e(route('wishlist')); ?>">
                    <img class="me-md-2" src="<?php echo e(asset('assets/media/icons/heart.svg')); ?>"/> &nbsp;&nbsp;
                    <span class="d-lg-none"><?php echo app('translator')->get('front.wishlist'); ?></span>
                </a>
            </li>
            <li class="nav-item d-none d-md-block mb-3">
                <a class="nav-link" aria-current="page" href="<?php echo e(route('cart.page')); ?>"><img class="me-2" src="<?php echo e(asset('assets/media/icons/shopping-bag.svg')); ?>"/></a>
            </li>
            <li class="nav-item mb-3">
                <a class="nav-link" aria-current="page" href="<?php echo e(route('account')); ?>">
                    <img class="me-2" src="<?php echo e(asset('assets/media/icons/user.svg')); ?>"/>
                    <span class="d-lg-none"><?php echo app('translator')->get('front.account'); ?></span>
                </a>
            </li>


            <li class="nav-item dropdown">

                <a class="nav-link dropdown-toggle"  role="button" data-bs-toggle="dropdown" aria-expanded="false">
                    <img class="me-2" src="<?php echo e(asset('assets/media/icons/globe.svg')); ?>"/>
                        <?php if(app()->getLocale() == "ar"): ?>
                            العربية
                        <?php else: ?>
                            English
                        <?php endif; ?>
                </a>

                <ul class="dropdown-menu">
                    <li>
                        <a class="dropdown-item" href="<?php echo e(route('set.language',['lang'=>'ar'])); ?>">
                            <img class="me-2" src="<?php echo e(asset('assets/media/icons/globe.svg')); ?>"/>العربية
                        </a>
                    </li>
                    <li>
                        <a class="dropdown-item" href="<?php echo e(route('set.language',['lang'=>'en'])); ?>">
                            <img class="me-2" src="<?php echo e(asset('assets/media/icons/globe.svg')); ?>"/> English
                        </a>
                    </li>
                </ul>

            </li>

            <li class="nav-item dropdown">
                <a class="nav-link dropdown-toggle"  role="button" data-bs-toggle="dropdown" aria-expanded="false">
                    <img class="me-2" src="<?php echo e(asset($country->flag)); ?>"/><?php echo e($country->name); ?> (<?php echo e($country->currency); ?>)
                </a>


                <ul class="dropdown-menu">
                    <li>
                        <a class="dropdown-item" href="<?php echo e(route('set.country',['country'=>'KWD'])); ?>">
                            <img class="me-2" src="<?php echo e(asset('assets/media/flags/KW.svg')); ?>"/>Kuwait(KWD)
                        </a>
                    </li>
                    <hr>
                    <li>
                        <a class="dropdown-item" href="<?php echo e(route('set.country',['country'=>'SAR'])); ?>">
                            <img class="me-2" src="<?php echo e(asset('assets/media/flags/SA.svg')); ?>"/>Saudi(SAR)
                        </a>
                    </li>
                    <hr>
                    <li>
                        <a class="dropdown-item" href="<?php echo e(route('set.country',['country'=>'QAR'])); ?>">
                            <img class="me-2" src="<?php echo e(asset('assets/media/flags/QA.svg')); ?>"/>Qatar(QAR)
                        </a>
                    </li>
                    <hr>
                    <li>
                        <a class="dropdown-item" href="<?php echo e(route('set.country',['country'=>'OMR'])); ?>">
                            <img class="me-2" src="<?php echo e(asset('assets/media/flags/OM.svg')); ?>"/>Oman(OMR)
                        </a>
                    </li>
                    <hr>
                    <li>
                        <a class="dropdown-item" href="<?php echo e(route('set.country',['country'=>'BHD'])); ?>">
                            <img class="me-2" src="<?php echo e(asset('assets/media/flags/BH.svg')); ?>"/>Bahrain(BHD)
                        </a>
                    </li>
                    <hr>
                    <li>
                        <a class="dropdown-item" href="<?php echo e(route('set.country',['country'=>'AED'])); ?>">
                            <img class="me-2" src="<?php echo e(asset('assets/media/flags/AE.svg')); ?>"/>UAE(AED)
                        </a>
                    </li>
                </ul>

            </li>
        </ul>
    </div>
</div>

<div class="w-100"  <?php if(app()->getLocale() == "ar"): ?> dir="rtl" <?php endif; ?>>
    <ul class="content-nav py-2 align-items-center navbar-nav d-none d-lg-flex flex-row justify-content-evenly w-100">
        <li class="nav-item">
            <a <?php if(Route::currentRouteName()=='home'): ?> class="nav-link link-active" <?php else: ?> class="nav-link" <?php endif; ?> href="<?php echo e(route('home')); ?>"><?php echo app('translator')->get('front.home'); ?></a>
        </li>
        <li class="nav-item">
            <a <?php if(Route::currentRouteName()=='categories'): ?> class="nav-link link-active" <?php else: ?> class="nav-link" <?php endif; ?> href="<?php echo e(route('categories')); ?>"><?php echo app('translator')->get('front.categories'); ?></a>
        </li>
        <li class="nav-item">
            <a <?php if(Route::currentRouteName()=='offers'): ?> class="nav-link link-active" <?php else: ?> class="nav-link" <?php endif; ?> href="<?php echo e(route('offers')); ?>"><?php echo app('translator')->get('front.offers'); ?></a>
        </li>
        <li class="nav-item">
            <a <?php if(Route::currentRouteName()=='aboutUs'): ?> class="nav-link link-active" <?php else: ?> class="nav-link" <?php endif; ?> href="<?php echo e(route('aboutUs')); ?>"><?php echo app('translator')->get('front.about_us'); ?></a>
        </li>
        <li class="nav-item">
            <a <?php if(Route::currentRouteName()=='contact'): ?> class="nav-link link-active" <?php else: ?> class="nav-link" <?php endif; ?> href="<?php echo e(route('contact')); ?>"><?php echo app('translator')->get('front.contact'); ?></a>
        </li>
    </ul>
</div>
<?php /**PATH D:\Reham\taphone\resources\views/front-component/header.blade.php ENDPATH**/ ?>