<?php $__env->startSection('title','Admin Settings'); ?>

<?php $__env->startSection('header-top'); ?>

    <?php echo $__env->make('layouts.inc.top-large-bar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div class="page-wrapper ">
        <div class="wrapper">
            <!-- Page title -->
            <div class="page-header d-print-none">
                <div class="row align-items-center">
                    <div class="col">
                        <!-- Page pre-title -->

                        <h2 class="page-title">
                            Articles
                        </h2>
                    </div>
                    <!-- Page title actions -->
                    <div class="col-auto ms-auto d-print-none">

                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="wrapper ">
        <div class="row">
            <div class="col-lg-12 col-md-12 col-sm-12">

                <div class="card">
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-vcenter card-table">
                                <thead>
                                <tr>
                                    <th>id</th>
                                    <th>image</th>
                                    <th>title</th>
                                    <th>subtitle</th>
                                    <th>visits</th>
                                    <th>status</th>
                                    <th>created by</th>

                                    <th>created at</th>
                                    <th>updated at</th>
                                    <th>Actions</th>
                                </tr>
                                </thead>
                                <tbody>


                                <?php $__currentLoopData = $articles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $article): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($article->id); ?></td>
                                        <td> <img src="<?php echo e(asset($article->image)); ?>" width="150" alt="">   </td>
                                        <td><?php echo e($article->title); ?></td>
                                        <td><?php echo e($article->subtitle); ?></td>
                                        <td><?php echo e($article->visits_count); ?></td>
                                        <td>
                                            <?php if($article->status == '1'): ?>
                                                <span onclick="toggleActive('<?php echo e($article->id); ?>','on')" class="badge bg-success me-1" style="width: 15px; height: 15px;cursor: pointer"></span>
                                            <?php else: ?>
                                                <span onclick="toggleActive('<?php echo e($article->id); ?>','off')" class="badge bg-danger me-1" style="width: 15px; height: 15px;cursor: pointer"></span>
                                            <?php endif; ?>

                                        </td>

                                        <td> <?php echo e($article->user->name); ?> </td>


                                        <td><?php echo e($article->created_at->diffForHumans()); ?></td>
                                        <td><?php echo e($article->updated_at->diffForHumans()); ?></td>

                                        <td>

                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('update',$article)): ?>
                                                <button type="button"  class="btn btn-ghost-success "
                                                        onclick="edit('<?php echo e($article->id); ?>')">
                                                    Edit
                                                </button>
                                            <?php endif; ?>

                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('delete',$article)): ?>
                                                <button type="button"
                                                        onclick="deleteRecord('<?php echo e(route("admin.articles.destroy",["article" => $article->id])); ?>')"
                                                        class="btn btn-ghost-danger">
                                                    Delete
                                                </button>
                                            <?php endif; ?>


                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                                </tbody>
                            </table>

                        </div>
                        <div class="row mt-3 ">
                            <?php echo $articles->links("pagination::bootstrap-4"); ?>

                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>


    

    <div class="modal modal-blur fade" id="edit-modal" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-xl modal-dialog-centered" role="document">
            <div class="modal-content" id="edit-modal-content">

            </div>
        </div>
    </div>

    <?php echo $__env->make('components.remove-modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script>
        let loader = `<?php echo $__env->make('components.loader', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>`;

        function edit(id) {
            $("#edit-modal-content").html(loader);
            $('#edit-modal').modal('show');
            $("#edit-modal-content").load(`admin/articles/${id}/edit`);
        }
    </script>
    <script>
        function deleteRecord(action) {
            console.log(action)
            $("#remove-form").attr('action', action)
            $("#modal-danger").modal('show');
        }

    </script>
    <script>
        function toggleActive(id,status) {

            var element = event.target;

            $.post("<?php echo e(route('admin.toggle.article.status')); ?>", { article_id:id } ).done(function( data ) {
                if(status === "on"){
                    element.classList.remove('bg-success')
                    element.classList.add('bg-danger')
                }else{
                    element.classList.remove('bg-danger')
                    element.classList.add('bg-success')
                }
            });
        }

    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.tabler-vertical', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\my projects\laravel\BetaBlog\resources\views/admin/articles/index.blade.php ENDPATH**/ ?>