<!DOCTYPE html>
<html class="rtl  " dir="rtl" lang="ar" xmlns="http://www.w3.org/1999/xhtml" xmlns:b="http://www.google.com/2005/gml/b" xmlns:data="http://www.google.com/2005/gml/data" xmlns:expr="http://www.google.com/2005/gml/expr">

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">

    <head>
        <meta charset="UTF-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <link rel="stylesheet" href="<?php echo e(asset('front/style.min.css')); ?>">
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" integrity="sha512-iecdLmaskl7CVkqkXNQ/ZH/XLlvWZOJyj7Yy7tcenmpD1ypASozpmT/E0iPtmFIB46ZmdtAc9eNBvH0H/ZpiBw==" crossorigin="anonymous" referrerpolicy="no-referrer"
        />
        <link href='https://unpkg.com/boxicons@2.1.4/css/boxicons.min.css' rel='stylesheet'>



        <?php echo $__env->make('front/components/meta-tags', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <style>


            .d-flex{
                display: flex;
            }
            .align-items-center{
                align-items: center;
            }
            .categories-conatiner{
                display: flex;
                flex-wrap: wrap;
                column-gap: 10px;
            }
                .categories-conatiner .post{
                    flex: 1;
                    min-width: 150px;
                    margin-top: 20px;
                }
            .article-thumb{
                background-size: cover !important;
                background-position: center center !important;
                background-repeat: no-repeat !important;
                opacity: 1;
            }
            .cat-section{
                position: relative; overflow: visible; box-sizing: border-box; min-height: 1px;     width: inherit;
            }

        </style>


    </head>

<body style="background-color: var(--outer-bg);">

<?php echo $__env->make('front/components/header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php

    $categories = \App\Models\Category::active()->get();

?>

<!-- categories -->

<div class="flex-c" id="content-wrapper">
    <div class="container row-x1 flex-sb" style="transform: none;">
        <section  class="cat-section">

                <h3> التصنيفات الرئيسية </h3>
                <div class="ul mega-items categories-conatiner">

                    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="post item-<?php echo e($loop->index + 1); ?>">
                            <a title="<?php echo e($category->name); ?>" class="entry-thumbnail sz-3" href="<?php echo e(route('filtered.category',['category'=>$category->id])); ?>">
                                <span class="thumbnail pbt-lazy" data-src="" style="background-image:url('<?php echo e(asset($category->image)); ?>')"></span></a>
                            <div class="entry-header">
                                <h2 class="entry-title">
                                    <a href="" title="<?php echo e($category->name); ?>">
                                        <?php echo e($category->name); ?>

                                    </a>
                                </h2>
                                <div class="entry-meta">
                                                            <span class="entry-time">
                                                                <time class="published" datetime="<?php echo e(substr($category->created_at,0,10)); ?>"><?php echo e(substr($category->created_at,0,10)); ?></time>
                                                            </span>
                                </div>
                            </div>
                        </div>

                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                </div>



        </section>
    </div>
</div>
<!-- end categories -->

<div class="flex-c" id="content-wrapper">
    <div class="container row-x1 flex-sb" style="transform: none;">
        <main id="main-wrapper" style="position: relative; overflow: visible; box-sizing: border-box; min-height: 1px;">


            <div class="theiaStickySidebar" style="padding-top: 0px; padding-bottom: 1px; position: static; transform: none;">
                <div class="main section" id="main" name="Main Posts">
                    <div class="widget Blog" data-version="2" id="Blog1">
                        <div class="blog-posts item-post-wrap flex-col">

                            <div class="main-title-wrap blog1-title">
                                <h3 class="title">أحدث المقالات</h3>
                                <a class="title-link" href="#">عرض الكل</a>
                            </div>


                            <div class="blog-posts index-post-wrap list-items articles-anime">

                              <?php $__currentLoopData = $articles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $article): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <article class="post hentry item-0">
                                    <a class="entry-thumbnail"
                                       href="<?php echo e(route('read.by.slug',['slug'=>$article->slug])); ?>"
                                       title="<?php echo e($article->title); ?>">
                                        <span class="thumbnail article-thumb"  style=" background: url('<?php echo e(asset($article->image)); ?>');"  ></span>
                                    </a>
                                    <div class="entry-header">
                                        <span class="entry-category"> <?php echo e($article->category->name); ?></span>
                                        <h2 class="entry-title">
                                            <a href="<?php echo e(route('read.by.slug',['slug'=>$article->slug])); ?>" rel="bookmark" title="<?php echo e($article->title); ?>"><?php echo e($article->title); ?></a></h2>
                                        <p class="entry-excerpt excerpt">
                                            <?php echo e($article->subtitle); ?>

                                        </p>
                                        <div class="entry-meta">
                                            <span class="entry-author mi"><span class="by sp">by</span><span class="author-name"><?php echo e($article->user->name); ?></span></span>
                                            <span class="entry-time mi"><span class="sp">-</span><time class="published" datetime="<?php echo e(substr($article->created_at,0,10)); ?>"> <?php echo e(substr($article->created_at,0,10)); ?>  </time></span>
                                        </div>
                                    </div>
                                </article>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            </div>
                            <div class="pagination" style="margin: 10px">
                                <?php echo $articles->links(); ?>

                            </div>



                        </div>
                    </div>
                </div>
            </div>
        </main>
        <!--aside-->
        <?php echo $__env->make('front/components/aside',['socials'=>$socials,'suggested'=>$suggested,'keywords'=>$keywords,'categories'=>$categories], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <!-- end aside -->
    </div>
</div>



<?php echo $__env->make('front/components/footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<script src='https://cdnjs.cloudflare.com/ajax/libs/jquery/3.5.1/jquery.min.js' type='text/javascript'></script>
<script>

    $(".mobile-menu-toggle").click(function (){
        $("body").addClass('nav-active');
    });

    $(".hide-mobile-menu").click(function (){
        $("body").removeClass('nav-active');
    });

    $("#show-search").click(function (){
        $("#main-search-wrap").css('display','block');
    });
    $("#hide-search").click(function (){
        $("#main-search-wrap").css('display','none');
    });
</script>

</body>

</html>
<?php /**PATH D:\my projects\laravel\BetaBlog\resources\views/front/home.blade.php ENDPATH**/ ?>