<?php $__env->startSection('styles'); ?>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/noUiSlider/15.7.1/nouislider.min.css" integrity="sha512-qveKnGrvOChbSzAdtSs8p69eoLegyh+1hwOMbmpCViIwj7rn4oJjdmMvWOuyQlTOZgTlZA0N2PXA7iA8/2TUYA==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <style>
        .p-image{
            width  : 332px;
            height : 332px;
        }
        .empty-items-card{
            background-color: #FAF8F4;
        }
        .card-filter{
            background-color: #F4F4F5;
            border: none;
        }

        #slider {
            height: 10px;
            width: 100%;

        }
        .noUi-horizontal .noUi-handle {
            width: 20px;
            height: 18px;
            right: -17px;
            top: -6px;
        }
        .noUi-connect {
            background: #383838;
        }

        .noUi-connects {
            border-radius: 1px;
            background: #BEBEBE;
        }

        .form-check-input:checked {
            background-color: #333333;
            border-color: var(--tblr-border-color-translucent);
        }


        .product p{
            color:#000;
            text-decoration: none;

        }
        .noUi-tooltip {
            display: none;
        }




    </style>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('page'); ?>

    <?php echo $__env->make('front-component.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>



    <section class="new-products-section mt-3">
        <div class="container">
            <div class="row mt-3">
                <div class="col-lg-12 col-md-12 col-sm-12">
                    <h1 class="text-start" style="font-weight: bold;"><?php echo e($category->name); ?></h1>
                </div>

                <?php if( count($products) != 0): ?>

                <div class="col-lg-3 col-md-4 col-sm-12">

                    <div class="card card-filter">
                        <div class="card-body">
                            <h1>filter by </h1>
                            <h1>Sizes</h1>

                            <label class="form-check">
                                <input class="form-check-input" type="checkbox" name="size[]" value="All">
                                <span class="form-check-label">All</span>
                            </label>
                            <?php $__currentLoopData = $uniqueSizes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $uniqueSize): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label class="form-check">
                                <input class="form-check-input" type="checkbox" name="size[]" value="<?php echo e($uniqueSize); ?>">
                                <span class="form-check-label"><?php echo e($uniqueSize); ?></span>
                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>



                            <br>
                            <h1>Price</h1>
                            <div id="slider"></div>
                            <div  class="col-12 d-flex justify-content-between">
                                <span id="min" >0</span>
                                <span id="max" > </span>
                            </div>

                            <br>
                            <br>
                            <br>


                        </div>
                    </div>

                    <div class="card card-filter mt-2">
                        <div class="card-body">
                            <h1>Sort By </h1>

                            <label class="form-check">
                                <input class="form-check-input" type="radio" name="sort"  value="A to Z">
                                <span class="form-check-label">A to Z</span>
                            </label>


                            <label class="form-check">
                                <input class="form-check-input" type="radio" name="sort" value="Z to A" >
                                <span class="form-check-label"> Z to A </span>
                            </label>

                            <label class="form-check">
                                <input class="form-check-input" type="radio" name="sort" value="Price Low to high" >
                                <span class="form-check-label"> Price Low to high </span>
                            </label>


                        </div>
                    </div>

                    <button onclick="doFilter()" href="#" class="btn btn-dark btn-square mt-2 w-100" style="background-color: #383838">
                        apply
                    </button>

                    <a  href="<?php echo e(route('categoryProducts',['categoryName'=>$category->name])); ?>" class="btn btn-outline-dark mt-2 w-100 " style="border-radius: 0">
                        clear filter
                    </a>

                </div>


                    <div id="products-container" class="col-lg-9 col-md-8 col-sm-12">
                        <div class="row">

                            <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col-lg-4 col-md-3 col-sm-6 col-6 ">
                                    <a href="<?php echo e(route('product.details',['id'=>$product->id])); ?>" style="text-decoration: none">
                                        <div class="product  p-5">
                                            <img src="<?php echo e(asset($product->image)); ?>" alt="">
                                            <p class="mb-0"><b> <?php echo e($product->name); ?> </b></p>
                                            <p class="mb-0"> <?php echo e($product->category->name); ?> </p>
                                            <p class="mb-0"> <?php echo e($product->redable_price); ?>   </p>
                                        </div>
                                    </a>

                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        </div>
                        <div class="col-lg-12 col-md-12 col-sm-12">
                                <?php echo $products->links(); ?>

                        </div>
                    </div>
                <?php else: ?>

                    <div class="col-lg-12 col-md-12 col-sm-12 d-flex justify-content-center align-items-center min-vh-50">

                        <?php echo $__env->make('front-component.empty', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                    </div>
                <?php endif; ?>

            </div>

        </div>
    </section>
    <br>
    <br>



    <?php echo $__env->make('front-component.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/noUiSlider/15.7.1/nouislider.min.js" integrity="sha512-UOJe4paV6hYWBnS0c9GnIRH8PLm2nFK22uhfAvsTIqd3uwnWsVri1OPn5fJYdLtGY3wB11LGHJ4yPU1WFJeBYQ==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
    <script>
        var slider = document.getElementById('slider');



        var valuesForSlider = [];
        var maxPrice = <?php echo e($maxPrice); ?>;
        maxPrice = Math.round(maxPrice / 10) * 10;

        $("#min").html(0);
        $("#max").html(maxPrice);

        var step = <?php echo e($step); ?>;
        step =  Math.round(step / 10) * 10;


        for (let i = 0; i <= maxPrice; i += step) {
            valuesForSlider.push(Math.round(i / 10) * 10);
        }

        var format = {
            to: function(value) {
                return valuesForSlider[Math.round(value / 10)]; // Divide the value by 10 to get the correct index
            },
            from: function(value) {
                return valuesForSlider.indexOf(Number(value)) * 10; // Multiply the index by 10 to get the correct value
            }
        };

        noUiSlider.create(slider, {
            start: [0, maxPrice],
            connect: true,
            range: {
                'min': 0,
                'max': maxPrice
            },
            step: step,
            tooltips: [true, true],


        });

        var tooltips = slider.querySelectorAll('.noUi-handle');

        tooltips.forEach(function(tooltip) {
            tooltip.addEventListener('mouseenter', function() {
                this.querySelector('.noUi-tooltip').style.display = 'block';
            });

            tooltip.addEventListener('mouseleave', function() {
                this.querySelector('.noUi-tooltip').style.display = 'none';
            });
        });

        function doFilter(){
            var sliderValues = slider.noUiSlider.get();
            console.log(sliderValues);
            var checkboxes = document.querySelectorAll('input[name="size[]"]');

            // Create an array to store the selected values
            var selectedValues = [];

            // Loop through the checkboxes and check if they are selected
            checkboxes.forEach(function(checkbox) {
                if (checkbox.checked) {
                    selectedValues.push(checkbox.value);
                }
            });

            console.log(selectedValues);

            var radioButtons = document.getElementsByName('sort');


            var sorted ;

            for (var i = 0; i < radioButtons.length; i++) {
                if (radioButtons[i].checked) {
                    sorted = radioButtons[i].value;
                    console.log(radioButtons[i].value);
                    break;
                }
            }


            var form = new FormData();


            form.append('range[]', JSON.stringify(sliderValues));
            form.append('size[]', JSON.stringify(selectedValues));
            form.append('sorted', sorted);
            form.append('category_id', <?php echo e($category->id); ?>);


            $.ajax({
                url: "<?php echo e(route('filter.products')); ?>", // Replace with the actual URL to submit the form
                type: 'POST',
                data: form,
                processData: false,
                contentType: false,
                success: function(response) {
                    // Success: handle the response here
                    console.log(response);
                    $("#products-container").html(response)
                },
                error: function() {
                    // Error: handle the error here
                    console.log('Error occurred.');
                }
            });



        }

    </script>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.front', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\my projects\laravel\sanam\resources\views/front/category-products.blade.php ENDPATH**/ ?>