<?php $__env->startSection('title', 'Admin Settings'); ?>

<?php $__env->startSection('header-top'); ?>

    <?php echo $__env->make('layouts.inc.top-large-bar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div class="page-wrapper ">
        <div class="wrapper">
            <!-- Page title -->
            <div class="page-header d-print-none">
                <div class="row align-items-center">
                    <div class="col">
                        <!-- Page pre-title -->

                        <h2 class="page-title">
                            <?php echo e(__('admin.workshops')); ?>

                        </h2>
                    </div>
                    <!-- Page title actions -->
                    <div class="col-auto ms-auto d-print-none">


                        <div class="btn-list">

                            <a href="#" class="btn btn-indigo d-none d-sm-inline-block" data-bs-toggle="modal"
                                data-bs-target="#modal-large">
                                <!-- Download SVG icon from http://tabler-icons.io/i/plus -->
                                <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24"
                                    viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none"
                                    stroke-linecap="round" stroke-linejoin="round">
                                    <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                    <line x1="12" y1="5" x2="12" y2="19" />
                                    <line x1="5" y1="12" x2="19" y2="12" />
                                </svg>
                                <?php echo e(__('admin.add_new_workshop')); ?>

                            </a>
                            <a href="#" class="btn btn-indigo d-sm-none btn-icon" data-bs-toggle="modal"
                                data-bs-target="#modal-large" aria-label="Create new report">
                                <!-- Download SVG icon from http://tabler-icons.io/i/plus -->
                                <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24"
                                    viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none"
                                    stroke-linecap="round" stroke-linejoin="round">
                                    <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                    <line x1="12" y1="5" x2="12" y2="19" />
                                    <line x1="5" y1="12" x2="19" y2="12" />
                                </svg>
                            </a>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="wrapper ">
        <div class="row">
            <div class="col-lg-12 col-md-12 col-sm-12">

                <div class="card">
                    <div class="card-body-s">

                        <div class="table-responsive">
                            <table class="table table-vcenter card-table">
                                <thead>
                                    <tr>
                                        <th><?php echo e(__('admin.id')); ?></th>
                                        <th><?php echo e(__('admin.name')); ?></th>
                                        <th><?php echo e(__('admin.category')); ?></th>
                                        <th><?php echo e(__('admin.price')); ?></th>

                                        <th><?php echo e(__('admin.is_free')); ?></th>
                                        <th> التفعيل </th>
                                        <th><?php echo e(__('admin.created_at')); ?></th>
                                        <th><?php echo e(__('admin.updated_at')); ?></th>
                                        <th><?php echo e(__('admin.actions')); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $workshops; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $workshop): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($workshop->id); ?></td>
                                            <td><?php echo e($workshop->name); ?></td>
                                            <td><?php echo e($workshop->category->name); ?></td>
                                            <td><?php echo e($workshop->price); ?></td>

                                            <td><?php echo e($workshop->is_free ? __('admin.yes') : __('admin.no')); ?></td>

                                            <td>
                                                <?php if($workshop->is_active == '0'): ?>
                                                    <div style="cursor: pointer;width:20px;height:20px;border-radius:10px;background:red;"
                                                        onclick="window.location.href='<?php echo e(route('admin.workshops.toggle', ['id' => $workshop->id, 'state' => '1'])); ?>'">
                                                    </div>
                                                <?php else: ?>
                                                    <div style="width:20px;height:20px;border-radius:10px;background:green;cursor: pointer;"
                                                        onclick="window.location.href='<?php echo e(route('admin.workshops.toggle', ['id' => $workshop->id, 'state' => '0'])); ?>'">
                                                    </div>
                                                <?php endif; ?>

                                            </td>
                                            <td><?php echo e($workshop->created_at->diffForHumans()); ?></td>
                                            <td><?php echo e($workshop->updated_at->diffForHumans()); ?></td>
                                            <td>
                                                <div class="dropdown">
                                                    <button class="btn dropdown-toggle align-text-top"
                                                        data-bs-toggle="dropdown" aria-expanded="false">
                                                        Actions
                                                    </button>
                                                    <div class="dropdown-menu dropdown-menu-end">
                                                        <a href="<?php echo e(route('admin.workshops.students', $workshop->id)); ?>"
                                                            class="dropdown-item"> <?php echo e(__('admin.students')); ?> </a>
                                                        <a href="<?php echo e(route('admin.workshops.joins', $workshop->id)); ?>"
                                                            class="dropdown-item"> طلبات الانضمام </a>
                                                        <a href="<?php echo e(route('admin.workshops.show', $workshop->id)); ?>"
                                                            class="dropdown-item"> <?php echo e(__('admin.coupons')); ?> </a>
                                                        <button type="button" class="dropdown-item"
                                                            onclick="edit('<?php echo e($workshop->id); ?>')"><?php echo e(__('admin.edit')); ?></button>
                                                        <a href="<?php echo e(route('admin.files.in.folders', rawurlencode('Virtual Court/workshop/w_' . $workshop->id))); ?>"
                                                            target="_blank" class="dropdown-item"> رفع الملفات </a>
                                                        <button type="button" class="dropdown-item"
                                                            onclick="deleteRecord('<?php echo e(route('admin.workshops.destroy', ['workshop' => $workshop->id])); ?>')"><?php echo e(__('admin.delete')); ?></button>
                                                    </div>
                                                </div>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                        
                        
                        
                        
                        
                    </div>

                </div>
            </div>
        </div>

        
        <div class="modal modal-blur fade" id="modal-large" tabindex="-1" role="dialog" aria-hidden="true">
            <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
                <div class="modal-content">

                    <div class="modal-header">
                        <h5 class="modal-title"><?php echo e(__('admin.create_new_workshop')); ?></h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <form action="<?php echo e(route('admin.workshops.store')); ?>" method="post" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <div class="modal-body scrollable-modal">
                            <div class="row mt-3">
                                <div class="col-12">
                                    <button type="button" onclick="setDir('ltr')" class="btn btn-light">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24"
                                            height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor"
                                            fill="none" stroke-linecap="round" stroke-linejoin="round">
                                            <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                            <line x1="4" y1="6" x2="20" y2="6" />
                                            <line x1="4" y1="12" x2="14" y2="12" />
                                            <line x1="4" y1="18" x2="18" y2="18" />
                                        </svg>
                                    </button>
                                    <button type="button" onclick="setDir('rtl')" class="btn btn-light">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24"
                                            height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor"
                                            fill="none" stroke-linecap="round" stroke-linejoin="round">
                                            <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                            <line x1="4" y1="6" x2="20" y2="6" />
                                            <line x1="10" y1="12" x2="20" y2="12" />
                                            <line x1="6" y1="18" x2="20" y2="18" />
                                        </svg>
                                    </button>
                                </div>
                                <div class="col-lg-12 col-md-12 col-sm-12 mt-2">
                                    <div class="form-group">
                                        <label><?php echo e(__('admin.name')); ?></label>
                                        <input class="form-control <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?> direc"
                                            type="text" name="name" placeholder="<?php echo e(__('admin.enter_name')); ?>">
                                        <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <small class="form-text text-danger"><?php echo e($message); ?></small>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>
                                <div class="col-lg-12 col-md-12 col-sm-12 mt-2">
                                    <div class="form-group">
                                        <label><?php echo e(__('admin.description')); ?></label>
                                        <textarea class="form-control <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?> direc" name="description"
                                            placeholder="<?php echo e(__('admin.description')); ?>"></textarea>
                                        <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <small class="form-text text-danger"><?php echo e($message); ?></small>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>
                                <div class="col-lg-6 col-md-6 col-sm-12 mt-2">
                                    <div class="form-group">
                                        <label><?php echo e(__('admin.image')); ?></label>
                                        <input class="form-control <?php $__errorArgs = ['image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" type="file"
                                            name="image">
                                        <?php $__errorArgs = ['image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <small class="form-text text-danger"><?php echo e($message); ?></small>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>
                                <div class="col-lg-6 col-md-6 col-sm-12 mt-2">
                                    <div class="form-group">
                                        <label><?php echo e(__('admin.pdf')); ?></label>
                                        <input class="form-control <?php $__errorArgs = ['pdf'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" type="file"
                                            name="pdf">
                                        <?php $__errorArgs = ['pdf'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <small class="form-text text-danger"><?php echo e($message); ?></small>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>

                                <div class="col-lg-6 col-md-6 col-sm-12 mt-2">
                                    <div class="form-group">
                                        <label><?php echo e(__('admin.price')); ?></label>
                                        <input class="form-control <?php $__errorArgs = ['price'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" type="text"
                                            name="price" placeholder="<?php echo e(__('admin.price')); ?>">
                                        <?php $__errorArgs = ['price'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <small class="form-text text-danger"><?php echo e($message); ?></small>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>

                                <div class="col-lg-6 col-md-6 col-sm-12 mt-2">
                                    <div class="form-group">
                                        <label><?php echo e(__('admin.is_free')); ?></label>
                                        <select class="form-control <?php $__errorArgs = ['is_free'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                            name="is_free">
                                            <option value="0"><?php echo e(__('admin.no')); ?></option>
                                            <option value="1"><?php echo e(__('admin.yes')); ?></option>
                                        </select>
                                        <?php $__errorArgs = ['is_free'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <small class="form-text text-danger"><?php echo e($message); ?></small>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>

                                <div class="col-lg-6 col-md-6 col-sm-12 mt-2">
                                    <div class="form-group">
                                        <label>التصنيف</label>
                                        <select class="form-select <?php $__errorArgs = ['category_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                            name="category_id">
                                            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($category->id); ?>"><?php echo e($category->name); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                        <?php $__errorArgs = ['category_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <small class="form-text text-danger"><?php echo e($message); ?></small>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>



                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn me-auto"
                                data-bs-dismiss="modal"><?php echo e(__('admin.close')); ?></button>
                            <button type="submit" class="btn btn-primary"> <?php echo e(__('admin.create_workshop')); ?> </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        

        <div class="modal modal-blur fade" id="edit-modal" tabindex="-1" role="dialog" aria-hidden="true">
            <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
                <div class="modal-content" id="edit-modal-content">

                </div>
            </div>
        </div>

        <?php echo $__env->make('components.remove-modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php $__env->stopSection(); ?>

    <?php $__env->startPush('scripts'); ?>
        <script>
            const dropdowns = document.querySelectorAll('.dropdown-toggle')
            const dropdown = [...dropdowns].map((dropdownToggleEl) => new bootstrap.Dropdown(dropdownToggleEl, {
                popperConfig(defaultBsPopperConfig) {
                    return {
                        ...defaultBsPopperConfig,
                        strategy: 'fixed'
                    };
                }
            }));

            let loader = `<?php echo $__env->make('components.loader', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>`;

            function edit(id) {
                $("#edit-modal-content").html(loader);
                $('#edit-modal').modal('show');
                $("#edit-modal-content").load(`admin/workshops/${id}/edit`);
            }


            function setDir(dir) {
                // Use querySelectorAll for more modern and efficient element selection
                const elements = document.querySelectorAll('.direc');

                if (elements.length === 0) {
                    console.warn("No elements found with class 'direc'.");
                    return; // Exit the function if no elements are found
                }

                if (dir.toLowerCase() === 'rtl') {
                    elements.forEach(element => element.setAttribute('dir', 'rtl'));
                } else if (dir.toLowerCase() === 'ltr') {
                    elements.forEach(element => element.setAttribute('dir', 'ltr'));
                } else {
                    console.warn("Invalid direction specified. Please use 'rtl' or 'ltr'.");
                }
            }
        </script>
        <script>
            function deleteRecord(action) {
                console.log(action);
                $("#remove-form").attr('action', action);
                $("#modal-danger").modal('show');
            }
        </script>
    <?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.tabler-vertical', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/virtualcourt/tls/resources/views/admin/workshops/index.blade.php ENDPATH**/ ?>