
<?php $__env->startSection('title','Admin Settings'); ?>

<?php $__env->startSection('header-top'); ?>

    <?php echo $__env->make('layouts.inc.top-large-bar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div class="page-wrapper ">
        <div class="wrapper">
            <!-- Page title -->
            <div class="page-header d-print-none">
                <div class="row align-items-center">
                    <div class="col">
                        <!-- Page pre-title -->

                        <h2 class="page-title">
                            <?php echo e(__('admin.coupon_codes')); ?>

                        </h2>
                    </div>
                    <!-- Page title actions -->
                    <div class="col-auto ms-auto d-print-none">


                        <div class="btn-list">

                            <a href="#" class="btn btn-indigo d-none d-sm-inline-block" data-bs-toggle="modal"
                               data-bs-target="#modal-large">
                                <!-- Download SVG icon from http://tabler-icons.io/i/plus -->
                                <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24"
                                     viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none"
                                     stroke-linecap="round" stroke-linejoin="round">
                                    <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
                                    <line x1="12" y1="5" x2="12" y2="19"/>
                                    <line x1="5" y1="12" x2="19" y2="12"/>
                                </svg>
                                <?php echo e(__('admin.add_new_coupon')); ?>

                            </a>
                            <a href="#" class="btn btn-indigo d-sm-none btn-icon" data-bs-toggle="modal"
                               data-bs-target="#modal-large" aria-label="Create new report">
                                <!-- Download SVG icon from http://tabler-icons.io/i/plus -->
                                <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24"
                                     viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none"
                                     stroke-linecap="round" stroke-linejoin="round">
                                    <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
                                    <line x1="12" y1="5" x2="12" y2="19"/>
                                    <line x1="5" y1="12" x2="19" y2="12"/>
                                </svg>
                            </a>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="wrapper ">
        <div class="row">
            <div class="col-lg-12 col-md-12 col-sm-12">

                <div class="card">
                    <div class="card-body-s">

                        <div class="table-responsive">
                            <table class="table table-striped">
                                <thead>
                                <tr>
                                    <th><?php echo e(__('admin.id')); ?></th>
                                    <th><?php echo e(__('admin.course')); ?></th>
                                    <th><?php echo e(__('admin.workshop')); ?></th>
                                    <th><?php echo e(__('admin.discount')); ?> (%)</th>
                                    <th><?php echo e(__('admin.apply_count')); ?></th>
                                    <th><?php echo e(__('admin.allowed_apply_count')); ?></th>
                                    <th><?php echo e(__('admin.coupon_code')); ?></th>
                                    <th><?php echo e(__('admin.actions')); ?></th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php $__currentLoopData = $couponCodes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $coupon): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($coupon->id); ?></td>
                                        <td><?php echo e($coupon->course ? $coupon->course->name : ' '); ?></td>
                                        <td><?php echo e($coupon->workshop ? $coupon->workshop->name : ' '); ?></td>
                                        <td><?php echo e($coupon->discount); ?>%</td>
                                        <td><?php echo e($coupon->apply_count); ?></td>
                                        <td><?php echo e($coupon->allowed_apply_count); ?></td>
                                        <td><?php echo e($coupon->coupon); ?></td>
                                        <td>
                                            <div class="dropdown">
                                                <button class="btn dropdown-toggle align-text-top" data-bs-toggle="dropdown" aria-expanded="false">
                                                    <?php echo e(__('admin.actions')); ?>

                                                </button>
                                                <div class="dropdown-menu dropdown-menu-end">
                                            <button type="button" class="dropdown-item" onclick="edit('<?php echo e($coupon->id); ?>')"> <?php echo e(__('admin.edit')); ?></button>
                                            <button type="button" onclick="deleteRecord('<?php echo e(route("admin.coupon_codes.destroy",["coupon_code"=>$coupon->id])); ?>')" class="dropdown-item"><?php echo e(__('admin.delete')); ?></button>
                                                </div>
                                            </div>

                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>

                        </div>
                        
                        
                        
                        
                        
                    </div>

                </div>
            </div>
        </div>

        
        <div class="modal modal-blur fade" id="modal-large" tabindex="-1" role="dialog" aria-hidden="true">
            <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title"><?php echo e(__('admin.create_new_coupon')); ?></h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <form action="<?php echo e(route('admin.coupon_codes.store')); ?>" method="post" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>

                        <?php if(isset($course)): ?>
                            <input name="course_id" value="<?php echo e($course->id); ?>" hidden>
                        <?php endif; ?>
                        <?php if(isset($workshop)): ?>
                            <input name="workshop_id" value="<?php echo e($workshop->id); ?>" hidden>
                        <?php endif; ?>

                        <div class="modal-body scrollable-modal">

                            <div class="row mt-3">


                                <div class="col-lg-12 col-md-12 col-sm-12 mt-2">
                                    <div class="form-group">
                                        <label><?php echo e(__('admin.discount')); ?> (%)</label>
                                        <input class="form-control <?php $__errorArgs = ['discount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" type="number" name="discount" placeholder="<?php echo e(__('admin.discount')); ?> (%)" value="<?php echo e(isset($coupon) ? $coupon->discount : old('discount')); ?>">
                                        <?php $__errorArgs = ['discount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <small class="form-text text-danger"><?php echo e($message); ?></small> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>

                                <div class="col-lg-12 col-md-12 col-sm-12 mt-2">
                                    <div class="form-group">
                                        <label><?php echo e(__('admin.allowed_apply_count')); ?></label>
                                        <input class="form-control <?php $__errorArgs = ['allowed_apply_count'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" type="number" name="allowed_apply_count" placeholder="<?php echo e(__('admin.allowed_apply_count')); ?>" value="<?php echo e(isset($coupon) ? $coupon->allowed_apply_count : old('allowed_apply_count')); ?>">
                                        <?php $__errorArgs = ['allowed_apply_count'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <small class="form-text text-danger"><?php echo e($message); ?></small> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>

                                <div class="col-lg-12 col-md-12 col-sm-12 mt-2">
                                    <div class="form-group">
                                        <label><?php echo e(__('admin.coupon_code')); ?></label>
                                        <input class="form-control <?php $__errorArgs = ['coupon'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" type="text" name="coupon" placeholder="<?php echo e(__('admin.coupon_code')); ?>" value="<?php echo e(isset($coupon) ? $coupon->coupon : old('coupon')); ?>">
                                        <?php $__errorArgs = ['coupon'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <small class="form-text text-danger"><?php echo e($message); ?></small> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>


                            </div>


                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn me-auto" data-bs-dismiss="modal">Close</button>
                            <button type="submit" class="btn btn-primary">
                                <?php echo e(__('admin.create_coupon')); ?>

                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        

        <div class="modal modal-blur fade" id="edit-modal" tabindex="-1" role="dialog" aria-hidden="true">
            <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
                <div class="modal-content" id="edit-modal-content">

                </div>
            </div>
        </div>

        <?php echo $__env->make('components.remove-modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php $__env->stopSection(); ?>

        <?php $__env->startPush('scripts'); ?>
            <script>

                const dropdowns = document.querySelectorAll('.dropdown-toggle')
                const dropdown = [...dropdowns].map((dropdownToggleEl) => new bootstrap.Dropdown(dropdownToggleEl, {
                    popperConfig(defaultBsPopperConfig) {
                        return { ...defaultBsPopperConfig, strategy: 'fixed' };
                    }
                }));

                let loader = `<?php echo $__env->make('components.loader', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>`;

                function edit(id) {
                    $("#edit-modal-content").html(loader);
                    $('#edit-modal').modal('show');
                    $("#edit-modal-content").load(`admin/coupon_codes/${id}/edit`);
                }


                function setDir(dir) {
                    // Use querySelectorAll for more modern and efficient element selection
                    const elements = document.querySelectorAll('.direc');

                    if (elements.length === 0) {
                        console.warn("No elements found with class 'direc'.");
                        return; // Exit the function if no elements are found
                    }

                    if (dir.toLowerCase() === 'rtl') {
                        elements.forEach(element => element.setAttribute('dir', 'rtl'));
                    } else if (dir.toLowerCase() === 'ltr') {
                        elements.forEach(element => element.setAttribute('dir', 'ltr'));
                    } else {
                        console.warn("Invalid direction specified. Please use 'rtl' or 'ltr'.");
                    }
                }
            </script>
            <script>
                function deleteRecord(action) {
                    console.log(action)
                    $("#remove-form").attr('action', action);
                    $("#modal-danger").modal('show');
                }

            </script>
    <?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.tabler-vertical', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/virtualcourt/tls/resources/views/admin/coupons/index.blade.php ENDPATH**/ ?>