<?php $__env->startSection('title','Admin Settings'); ?>

<?php $__env->startSection('header-top'); ?>
    <style>
        .number_box{
            background: #41494d;
            display: flex;
            justify-content: center;
            align-items: center;
            padding: 10px 5px;
            color: #fff;
            font-size: 20px;
            border-radius: 8px;
            width: 50px;
        }
    </style>
    <?php echo $__env->make('layouts.inc.top-large-bar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div class="page-wrapper ">
        <div class="wrapper">
            <!-- Page title -->
            <div class="page-header d-print-none">
                <div class="row align-items-center">
                    <div class="col">
                        <!-- Page pre-title -->

                        <h2 class="page-title">
                            Pull Options - <?php echo e($pullGame->name); ?>

                        </h2>
                    </div>
                    <!-- Page title actions -->
                    <div class="col-auto ms-auto d-print-none">


                        <div class="btn-list">

                            <a href="#" class="btn btn-indigo d-none d-sm-inline-block" data-bs-toggle="modal"
                               data-bs-target="#modal-large">
                                <!-- Download SVG icon from http://tabler-icons.io/i/plus -->
                                <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24"
                                     viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none"
                                     stroke-linecap="round" stroke-linejoin="round">
                                    <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
                                    <line x1="12" y1="5" x2="12" y2="19"/>
                                    <line x1="5" y1="12" x2="19" y2="12"/>
                                </svg>
                                 Create Option
                            </a>
                            <a href="#" class="btn btn-indigo d-sm-none btn-icon" data-bs-toggle="modal"
                               data-bs-target="#modal-large" aria-label="Create new report">
                                <!-- Download SVG icon from http://tabler-icons.io/i/plus -->
                                <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24"
                                     viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none"
                                     stroke-linecap="round" stroke-linejoin="round">
                                    <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
                                    <line x1="12" y1="5" x2="12" y2="19"/>
                                    <line x1="5" y1="12" x2="19" y2="12"/>
                                </svg>
                            </a>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="wrapper ">
        <div class="row">
            <div class="col-lg-12 col-md-12 col-sm-12">

                <div class="card">
                    <div class="card-body">

                        <div class="table-responsive">
                            <table class="table table-vcenter card-table">
                                <thead>
                                <tr>

                                    <th>id</th>
                                    <th>image</th>
                                    <th>name</th>
                                    <th>number</th>
                                    <th>user</th>
                                    <th>is master</th>
                                    <th>is profitable</th>
                                    <th>created at</th>
                                    <th>updated at</th>
                                    <th>Actions</th>

                                </tr>
                                </thead>
                                <tbody>


                                <?php $__currentLoopData = $options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($option->id); ?></td>

                                        <td>
                                            <?php if($option->image): ?>
                                            <img src="<?php echo e(asset($option->image)); ?>" width="50" alt="">
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <?php echo e($option->name); ?>

                                        </td>
                                        <td>
                                            <div class="number_box"><?php echo e($option->choice_number); ?></div>
                                        </td>
                                        <td>
                                            <?php if($option->user_id): ?>
                                                <?php echo e($option->user->name); ?>

                                            <?php endif; ?>
                                        </td>
                                        <td>

                                            <?php if($option->is_master == 1): ?>
                                                <span class="text-green"> yes </span>
                                            <?php else: ?>
                                                <span class="text-grey"> no </span>
                                            <?php endif; ?>

                                        </td>

                                        <td>
                                            <?php if($option->is_profitable == 1): ?>
                                                <span class="text-green"> yes </span>
                                            <?php else: ?>
                                                <span class="text-red"> no </span>
                                            <?php endif; ?>
                                        </td>

                                        <td><?php echo e($option->created_at->diffForHumans()); ?></td>
                                        <td><?php echo e($option->updated_at->diffForHumans()); ?></td>
                                        <td>
                                            <div class="dropdown"  >
                                                <button class="btn dropdown-toggle align-text-top" data-bs-toggle="dropdown" aria-expanded="false" >
                                                    Actions
                                                </button>
                                                <div class="dropdown-menu dropdown-menu-end" style="">




                                                    <button type="button"
                                                            onclick="deleteRecord('<?php echo e(route("admin.pull_game_options.destroy",["pull_game_option"=>$option->id])); ?>')"
                                                            class="dropdown-item">
                                                        Delete
                                                    </button>

                                                </div>
                                            </div>







                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                                </tbody>
                            </table>

                        </div>

                    </div>

                </div>
            </div>
        </div>

        
        <div class="modal modal-blur fade" id="modal-large" tabindex="-1" role="dialog" aria-hidden="true">
            <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Create New Option</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <form action="<?php echo e(route('admin.pull_game_options.store')); ?>" method="post" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <input name="pull_game_id" value="<?php echo e($pullGame->id); ?>" type="text" hidden>
                        <div class="modal-body scrollable-modal">

                            <div class="row mt-3">

                                <div class="col-12 ">

                                    <button type="button"  onclick="setDir('ltr')" class="btn btn-light ">
                                        <!-- Download SVG icon from http://tabler-icons.io/i/align-left -->
                                        <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><line x1="4" y1="6" x2="20" y2="6" /><line x1="4" y1="12" x2="14" y2="12" /><line x1="4" y1="18" x2="18" y2="18" /></svg>
                                    </button>
                                    <button type="button" onclick="setDir('rtl')" class="btn btn-light ">
                                        <!-- Download SVG icon from http://tabler-icons.io/i/align-right -->
                                        <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><line x1="4" y1="6" x2="20" y2="6" /><line x1="10" y1="12" x2="20" y2="12" /><line x1="6" y1="18" x2="20" y2="18" /></svg>
                                    </button>

                                </div>

                                <div class="col-lg-12 col-md-12 col-sm-12 mt-2">
                                    <div class="form-group">
                                        <label>name</label>
                                        <input class="form-control <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?> direc" type="text" name="name" placeholder="name">
                                        <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <small class="form-text  text-danger"><?php echo e($message); ?></small> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>


                                <div  class="col-lg-6 col-md-6 col-sm-12 col-12 mt-3 mb-3">
                                    <label class="row">
                                        <span class="col">is master</span>
                                            <span class="col-auto">
                                            <label class="form-check form-check-single form-switch">
                                              <input class="form-check-input" name="is_master" type="checkbox" checked="">
                                            </label>
                                          </span>
                                    </label>
                                </div>

                                <div class="col-lg-6 col-md-6 col-sm-12 col-12  mt-3 mb-3">
                                    <label class="row">
                                        <span class="col">is profitable</span>
                                        <span class="col-auto">
                                            <label class="form-check form-check-single form-switch">
                                              <input class="form-check-input" name="is_profitable" type="checkbox" checked="">
                                            </label>
                                        </span>
                                    </label>
                                </div>



                                <?php echo $__env->make('components.intelegent_image_uploader',['cssclass'=>'col-lg-12 col-md-12 col-sm-12','title'=>'image','image_input_name'=>'image'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            </div>


                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn me-auto" data-bs-dismiss="modal">Close</button>
                            <button type="submit" class="btn btn-primary" onclick="disableButton(this)">
                                Create Option
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        

        <div class="modal modal-blur fade" id="edit-modal" tabindex="-1" role="dialog" aria-hidden="true">
            <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
                <div class="modal-content" id="edit-modal-content">

                </div>
            </div>
        </div>

        <?php echo $__env->make('components.remove-modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php $__env->stopSection(); ?>

        <?php $__env->startPush('scripts'); ?>
            <script>

                const dropdowns = document.querySelectorAll('.dropdown-toggle')
                const dropdown = [...dropdowns].map((dropdownToggleEl) => new bootstrap.Dropdown(dropdownToggleEl, {
                    popperConfig(defaultBsPopperConfig) {
                        return { ...defaultBsPopperConfig, strategy: 'fixed' };
                    }
                }));

                let loader = `<?php echo $__env->make('components.loader', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>`;

                function edit(id) {
                    $("#edit-modal-content").html(loader);
                    $('#edit-modal').modal('show');
                    $("#edit-modal-content").load(`admin/lots/${id}/edit`);
                }


                function setDir(dir) {
                    // Use querySelectorAll for more modern and efficient element selection
                    const elements = document.querySelectorAll('.direc');

                    if (elements.length === 0) {
                        console.warn("No elements found with class 'direc'.");
                        return; // Exit the function if no elements are found
                    }

                    if (dir.toLowerCase() === 'rtl') {
                        elements.forEach(element => element.setAttribute('dir', 'rtl'));
                    } else if (dir.toLowerCase() === 'ltr') {
                        elements.forEach(element => element.setAttribute('dir', 'ltr'));
                    } else {
                        console.warn("Invalid direction specified. Please use 'rtl' or 'ltr'.");
                    }
                }
            </script>
            <script>
                function deleteRecord(action) {
                    console.log(action)
                    $("#remove-form").attr('action', action);
                    $("#modal-danger").modal('show');
                }

            </script>
    <?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.tabler-vertical', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\free lancing projects\laravel\taphone\resources\views/admin/pulls/options/index.blade.php ENDPATH**/ ?>