<?php $__env->startSection('styles'); ?>
    <style>

        .counter button{
            background-color: #CC7546;
            border: none;
            color:#fff;
            width: 30px;
            height: 30px;
            font-size: 20px;
            display: flex;
            justify-content: center;
            font-weight: bold;
        }
        .pointer{
            cursor: pointer;
        }
        .counter button:disabled {
            background-color:  #CC7546dd; /* Set your desired disabled color here */
            cursor: not-allowed; /* Optional: Change the cursor to show it's disabled */
        }
        .counter span{
            font-size: 26px;

        }
        .btn-dark{
            --tblr-btn-border-color: #3C3C39;
            --tblr-btn-hover-border-color: #3C3C39;
            --tblr-btn-active-border-color: #3C3C39;
            --tblr-btn-bg: #3C3C39;
            --tblr-btn-disabled-bg: #3C3C39;
        }
    </style>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('page'); ?>

    <?php echo $__env->make('front-component.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <div class="container ">
        <div class="row cart-row py-5 min-vh-70">
            <span <?php if(app()->getLocale() == "ar"): ?> dir="rtl" <?php endif; ?>  style="font-size: 28px; font-weight: bold"><?php echo app('translator')->get('front.CART'); ?>  </span>
            <div class="col-lg-8 p-4">


                <?php if(empty($products)): ?>

                      <div class="row">
                          <div class="card p-3 border-0 d-flex justify-content-center align-items-center text-center" style="background-color: #FAF8F4;min-width: 300px">

                              <div class="card-icon">

                                  <svg xmlns="http://www.w3.org/2000/svg" width="64.373" height="64.373" viewBox="0 0 64.373 64.373">
                                      <g id="nothing" transform="translate(0 0)">
                                          <path id="Path_142324" data-name="Path 142324" d="M40.519,68.308A20.449,20.449,0,0,1,68.306,40.52l5.8-5.8A28.419,28.419,0,0,0,34.721,74.106Z" transform="translate(-26.227 -26.229)" fill="#cc7546"/>
                                          <path id="Path_142325" data-name="Path 142325" d="M164.784,137A20.45,20.45,0,0,1,137,164.785l-5.8,5.8A28.418,28.418,0,0,0,170.582,131.2Z" transform="translate(-114.702 -114.704)" fill="#cc7546"/>
                                          <path id="Path_142326" data-name="Path 142326" d="M63.822.551a1.889,1.889,0,0,0-2.668,0l-60.6,60.6A1.887,1.887,0,0,0,3.22,63.82l60.6-60.6a1.889,1.889,0,0,0,0-2.668Z" transform="translate(0 0)" fill="#cc7546"/>
                                      </g>
                                  </svg>

                              </div>

                              <div class="text-center mt-2">
                                  <h1><?php echo app('translator')->get('front.Empty_Cart_Message_1'); ?></h1>
                                  <h1><?php echo app('translator')->get('front.Empty_Cart_Message_2'); ?></h1>

                                  <a href="<?php echo e(route('home')); ?>" class="btn btn-dark mt-2"> Home </a>

                              </div>
                          </div>
                      </div>
                <?php endif; ?>

                <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="row mb-5" style="background-color:#FAF8F4" id="item_row_<?php echo e($product->id); ?>">
                    <div class="col-md-5 p-3">
                        <img width="30%" src="<?php echo e(asset($product->image)); ?>"/>
                        <span class="fw-bold text-nowrap"><?php echo e($product->name); ?></span>
                    </div>
                    <div class="col-md-3 d-flex align-items-center justify-content-between counter">



                                <button id="decrease-btn" class="decrease-btn" data-product-id="<?php echo e($product->id); ?>" data-product-count="<?php echo e($product->user_quantity); ?>"   >-</button>
                                <span  class="count" id="count_<?php echo e($product->id); ?>" class="flex-1 text-center bg-white"> <?php echo e($product->user_quantity); ?> </span>
                                <button id="increase-btn" class="increase-btn number-btn no-radius" data-product-id="<?php echo e($product->id); ?>"  data-product-count="<?php echo e($product->user_quantity); ?>">+</button>



                    </div>
                    <div class="col-md-3 d-flex align-items-center justify-content-center">
                        <span class="text-nowrap" id="item_total_price_<?php echo e($product->id); ?>"> <?php echo e($product->total_price); ?>    </span>
                    </div>
                    <div class="col-md-1 mb-3 mb-md-0 mt-3 mt-md-0 d-flex align-items-center justify-content-center pointer">


                         <a href="<?php echo e(route('remove-item-from-cart',['product_id'=>$product->id])); ?>" class="icon-remove-button ">
                             <svg xmlns="http://www.w3.org/2000/svg" width="22.4" height="24" viewBox="0 0 22.4 24">
                                 <g id="Layer_2" data-name="Layer 2" transform="translate(-2 -1)">
                                     <path id="Path_142363" data-name="Path 142363" d="M2.8,6.6H4.4V22.984A2.824,2.824,0,0,0,7.216,25.8h12A2.824,2.824,0,0,0,22,22.984V6.6h1.6a.8.8,0,0,0,0-1.6H2.8a.8.8,0,1,0,0,1.6Zm17.6,0V22.984A1.216,1.216,0,0,1,19.184,24.2h-12A1.216,1.216,0,0,1,6,22.984V6.6Z" transform="translate(0 -0.8)" fill="#3c3c39"/>
                                     <path id="Path_142364" data-name="Path 142364" d="M11.8,2.6h6.4a.8.8,0,1,0,0-1.6H11.8a.8.8,0,1,0,0,1.6Z" transform="translate(-1.8)" fill="#3c3c39"/>
                                     <path id="Path_142365" data-name="Path 142365" d="M12.48,22.2a.8.8,0,0,0,.8-.8V11.8a.8.8,0,1,0-1.6,0v9.6A.8.8,0,0,0,12.48,22.2Z" transform="translate(-1.936 -2)" fill="#3c3c39"/>
                                     <path id="Path_142366" data-name="Path 142366" d="M19.12,22.2a.8.8,0,0,0,.8-.8V11.8a.8.8,0,1,0-1.6,0v9.6A.8.8,0,0,0,19.12,22.2Z" transform="translate(-3.264 -2)" fill="#3c3c39"/>
                                 </g>
                             </svg>
                         </a>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
            <div class="col-lg-4">
                <form id="form-authed-checkout" action="<?php echo e(route('checkout')); ?>" method="post">
                    <?php echo csrf_field(); ?>

                        <div class="row p-4">
                            <div class="col-12 mb-3">
                                <p class="fw-bold  <?php if(app()->getLocale() == "ar"): ?> text-right <?php endif; ?>"  <?php if(app()->getLocale() == "ar"): ?> dir="rtl" <?php endif; ?>> <?php echo app('translator')->get('front.Notes_Placeholder'); ?>  </p>
                                <textarea id="additional" name="additional_info" class="form-control no-radius mt-3" rows="4" placeholder="<?php echo app('translator')->get('front.Notes_Placeholder'); ?>" style="resize:none" <?php if(app()->getLocale() == "ar"): ?> dir="rtl" <?php endif; ?>></textarea>
                            </div>
                            <div class="col-12">
                                <div class="d-flex flex-column p-4" style="background-color:#FAF8F4" <?php if(app()->getLocale() == "ar"): ?> dir="rtl" <?php endif; ?>>
                                    <h5 class="fw-bolder" > <?php echo app('translator')->get('front.payment_details'); ?>  </h5>
                                    <div class="d-flex justify-content-between mb-2" >
                                        <span><?php echo app('translator')->get('front.sub_total'); ?> </span>
                                        <span id="total_amount" dir="ltr"><?php echo e($totalAmount); ?>  </span>
                                    </div>


                                    <?php if(auth()->guard()->check()): ?>

                                        <button id="proccessauthedbtn" onclick="submitFormFromDialog()"  type="button" class="btn btn-dark no-radius">

                                            <?php echo app('translator')->get('front.proceed_to_checkout'); ?>
                                        </button>

                                    <?php else: ?>

                                        <button onclick="showUserTypeDialgo()"  type="button" class="btn btn-dark no-radius">

                                            <?php echo app('translator')->get('front.proceed_to_checkout'); ?>
                                        </button>

                                    <?php endif; ?>




                                </div>
                            </div>
                        </div>

                </form>
            </div>
        </div>
    </div>


    <div id="modal-remove" class="modal modal-blur fade" id="modal-simple" tabindex="-1" style="display: none;" aria-hidden="true">
        <div  class="modal-dialog modal-sm modal-dialog-centered" role="document">
            <div class="modal-content">


                <div class="modal-body text-left py-4" <?php if(app()->getLocale() == "ar"): ?> dir="rtl" <?php endif; ?>>

                    <h3><?php echo e(__('front.remove_item_modal_title')); ?></h3>
                    <div class="text-muted"><?php echo e(__('front.remove_item_modal_confirmation')); ?></div>
                    <div class="w-100 mt-2">
                        <div class="row">
                            <div class="col">
                                <a href="#" class="btn w-100" data-bs-dismiss="modal">
                                    <?php echo e(__('front.remove_item_modal_no')); ?>

                                </a>
                            </div>
                            <div class="col">
                                <button id="btn-yes" href="#" class="btn btn-danger w-100" data-bs-dismiss="modal" style="background-color: #3C3C39;border:none;" >
                                    <?php echo e(__('front.remove_item_modal_yes')); ?>

                                </button>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>

    <div id="modal-choice" class="modal modal-blur fade"   tabindex="-1" style="display: none;" aria-hidden="true">
        <div  class="modal-dialog modal-sm modal-dialog-centered" role="document">
            <div class="modal-content">


                <div class="modal-body text-left py-4" <?php if(app()->getLocale() == "ar" ): ?> dir="rtl" <?php endif; ?>>
                    <h3><?php echo app('translator')->get('front.no_account_modal_title'); ?></h3>
                    <div class="text-muted"><?php echo app('translator')->get('front.no_account_modal_continue_guest'); ?></div>
                    <div class="text-muted"><?php echo app('translator')->get('front.no_account_modal_login_signup'); ?></div>
                    <div class="w-100 mt-2">
                        <div class="row">
                            <div class="col">
                                <button onclick="submitFormFromDialogGuest()" class="btn w-100" data-bs-dismiss="modal" style="<?php if(app()->getLocale() == "ar" ): ?> font-size: 12px <?php endif; ?>">
                                    <?php echo app('translator')->get('front.no_account_modal_continue_guest_btn'); ?>
                                </button>
                            </div>
                            <div class="col">
                                <button id="btn-yes" onclick="submitFormFromDialog()" class="btn btn-danger w-100" data-bs-dismiss="modal" style="background-color: #3C3C39;border:none; <?php if(app()->getLocale() == "ar" ): ?> font-size: 12px <?php endif; ?>"  >
                                    <?php echo app('translator')->get('front.no_account_modal_login_signup_btn'); ?>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>

    <?php echo $__env->make('front-component.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    <script>
        $(document).ready(function () {
            $(".decrease-btn").click(function () {
                var productId = $(this).data('product-id');
                var icount = parseInt( $("#count_" + productId).html());
                console.log(icount)
                if(icount === 1){
                    confirmRemove(productId);
                    return;
                }
                $("#decrease-btn").prop('disabled', true);
                $.ajax({
                    url: '/decrease-item-count',
                    type: 'POST',
                    data: {product_id: productId},
                    success: function (response) {
                        $("#decrease-btn").prop('disabled', false)
                        // Update the count and total price for the specific item
                        $("#count_" + productId).text(response.item_quantity);



                        $("#item_total_price_" + productId).text( response.item_total_price );
                        // Update the total amount
                        $("#total_amount").text( response.total_amount );
                        if (response.item_quantity <= 0) {
                            $("#item_row_" + productId).remove();
                        }
                    }
                });
            });

            $(".increase-btn").click(function () {
                var productId = $(this).data('product-id');
                $("#increase-btn").prop('disabled',true)
                $.ajax({
                    url: '/increase/cart/item',
                    type: 'POST',
                    data: {product_id: productId},
                    success: function (response) {
                        $("#increase-btn").prop('disabled',false)
                        // Update the count and total price for the specific item
                        $("#count_" + productId).text(response.item_quantity);

                        $("#item_total_price_" + productId).text( response.item_total_price);
                        // Update the total amount
                        $("#total_amount").text(response.total_amount);



                    }
                });
            });
        });


        function formatNumber(number) {
            return new Intl.NumberFormat('en-US', { minimumFractionDigits: 2 }).format(number);
        }

        function confirmRemove(productId){
            $("#modal-remove").modal('show');

            $('#btn-yes').on('click', function () {
                $('#btn-yes').off('click');
                $.ajax({
                    url: '/decrease-item-count',
                    type: 'POST',
                    data: {product_id: productId},
                    success: function (response) {
                        // Update the count and total price for the specific item
                        $("#count_" + productId).text(response.item_quantity);
                        $("#item_total_price_" + productId).text(response.item_total_price);
                        // Update the total amount
                        $("#total_amount").text(response.total_amount);
                        if (response.item_quantity <= 0) {
                            $("#item_row_" + productId).remove();
                        }
                    }
                });
                $('#modal-remove').modal('hide');
            });



        }

        function showUserTypeDialgo(){
            $("#modal-choice").modal('show')
        }

        function submitFormFromDialog(){

            var additionalInfo = $('#additional').val(); // Replace with your actual additional info

            $("#proccessauthedbtn").prop('disabled',true)

            $.ajax({
                url: "<?php echo e(route('set.additional.note')); ?>",
                method: "POST",
                data: {
                    additional_info: additionalInfo
                },
                dataType: "json",
                success: function (response) {
                    $("#proccessauthedbtn").prop('disabled',false)
                    if (response.redirect) {
                        // Redirect the user
                        window.location.href = response.redirect;
                    } else {
                        // Handle other responses if needed
                    }
                },
                error: function (xhr, status, error) {
                    console.error(xhr.responseText);
                    $("#proccessauthedbtn").prop('disabled',false)
                    // Handle the error here if needed
                }
            });

        }

        function submitFormFromDialogGuest(){

            var additionalInfo = $('#additional').val(); // Replace with your actual additional info

            $.ajax({
                url: "<?php echo e(route('set.additional.note')); ?>",
                method: "POST",
                data: {
                    additional_info: additionalInfo,
                    guest : 'yes'
                },
                dataType: "json",
                success: function (response) {
                    if (response.redirect) {
                        // Redirect the user
                        window.location.href = response.redirect;
                    } else {
                        // Handle other responses if needed
                    }
                },
                error: function (xhr, status, error) {
                    console.error(xhr.responseText);
                    // Handle the error here if needed
                }
            });

        }

    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.front', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\my projects\laravel\sanam\resources\views/front/cart.blade.php ENDPATH**/ ?>