<!doctype html>
<html lang="en">
<head>
    <meta charset="utf-8"/>
    <meta name="viewport" content="width=device-width, initial-scale=1, viewport-fit=cover"/>
    <meta http-equiv="X-UA-Compatible" content="ie=edge"/>
    <title>@yield('title')</title>
    <!-- CSS files -->
    <base href="/">
    <link href="{{asset('tabler/dist/css/tabler.min.css')}}" rel="stylesheet"/>
    <link href="{{asset('tabler/dist/css/tabler-vendors.min.css')}}" rel="stylesheet"/>
    <link href="{{asset('tabler/dist/css/demo.min.css')}}" rel="stylesheet"/>
    <link href="{{asset("css/style.css")}}" rel="stylesheet"/>
    <link href='https://unpkg.com/boxicons@2.1.4/css/boxicons.min.css' rel='stylesheet'>
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@200;300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        body{
            font-family: 'Cairo', sans-serif;
        }
    </style>
    
    @if(auth()->user()->theme != "vertical")
        <link href="{{asset("rtl.css")}}" rel="stylesheet"/>
    @endif
    
    @stack('styles')

    <script>
        function disableButton(button) {
            button.disabled = true;
            button.textContent = "Submitting...";

            const form = button.closest('form');
            if (form) {
                form.submit();
            }
        }
    </script>

</head>
<body >
<div class="wrapper">
        @include('layouts.inc.vertical-header')
    <div class="page-wrapper">

        <div class="container-fluid">
             @yield('header-top')
        </div>
        <div class="page-body">
            <div class="container-fluid">
             @yield('content')
            </div>
        </div>
         @include('layouts.inc.vertical-footer')
    </div>
</div>

<!-- Libs JS -->
<script src="{{asset("js/jquery-3.6.1.min.js")}}"></script>
<script src="{{asset('tabler/dist/libs/apexcharts/dist/apexcharts.min.js')}}"></script>
<!-- Tabler Core -->
<script src="{{asset('tabler/dist/js/tabler.min.js')}}"></script>
@stack('scripts')
<script src="{{asset('tabler/dist/js/demo.min.js')}}"></script>
@include('sweetalert::alert')
<script>
    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });

</script>
</body>
</html>
