 
@include('front.inc.header')
<div class="breadcumb-wrapper " data-bg-src="https://virtual-court.net/frontassets/img/bg/breadcumb-bg.jpg" data-overlay="title" data-opacity="8">
    <div class="breadcumb-shape" data-bg-src="https://virtual-court.net/frontassets/img/bg/breadcumb_shape_1_1.png">
    </div>
    <div class="shape-mockup breadcumb-shape2 jump d-lg-block d-none" data-right="30px" data-bottom="30px">
        <img src="https://virtual-court.net/frontassets/img/bg/breadcumb_shape_1_2.png" alt="shape">
    </div>
    <div class="shape-mockup breadcumb-shape3 jump-reverse d-lg-block d-none" data-left="50px" data-bottom="80px">
        <img src="https://virtual-court.net/frontassets/img/bg/breadcumb_shape_1_3.png" alt="shape">
    </div>
    <div class="container">
        <div class="breadcumb-content text-center">
            <h1 class="breadcumb-title">الكورسات</h1>
            <ul class="breadcumb-menu">
                <li> الكورسات </li>
                <li><a href="index.html">الرئيسية</a></li>
            </ul>
        </div>
    </div>
</div>
<!--==============================
Course Area
==============================-->
<section class="space-top space-extra-bottom">
    <div class="container">
        <div class="th-sort-bar">
            <div class="row justify-content-between align-items-center">
                <div class="col-md-auto">
                    <span class="course-result-count">لقد وجدنا <span class="text-theme">{{\App\Models\Course::count()}} كورس</span> تدريبي لأجلك</span>
                </div>
                <div class="col-md-auto">
                    <div class="nav" role=tablist>
                        <a href="#" class="active" id="tab-course-grid" data-bs-toggle="tab" data-bs-target="#tab-grid" role="tab" aria-controls="tab-grid" aria-selected="true"><i class="fa-solid fa-grid-2"></i> شبكة</a>
                        <a href="#" id="tab-course-list" data-bs-toggle="tab" data-bs-target="#tab-list" role="tab" aria-controls="tab-grid" aria-selected="false"><i class="fas fa-list"></i> قائمة</a>
                    </div>
                </div>
            </div>
        </div>
        <div class="tab-content" id="nav-tabContent">
            <div class="tab-pane fade active show" id="tab-grid" role="tabpanel" aria-labelledby="tab-course-grid">
                <div class="row gy-4 mb-30">

                    @foreach(\App\Models\Course::orderBy('id','desc')->get() as $course)
                    <div class="col-md-6 col-lg-4 col-xxl-3 filter-item cat1 cat3">
                        <div class="course-box2 style2">
                            <div class="course-img">
                                <img src="{{asset($course->image)}}" alt="course">
                                <span class="tag">
                                    @if($course->is_free)
                                        Free
                                        @else
                                        {{$course->price}}
                                    @endif
                                </span>
                            </div>
                            <div class="course-content">
                                <div class="course-author">
                                    <div class="author-info">
                                        <img src="{{asset($course->author->image)}}" alt="author">
                                        <a href="#" class="author-name">{{$course->author->name}}</a>
                                    </div>
                                    <div class="course-rating">
                                        <div class="star-rating" role="img" aria-label="Rated 4.00 out of 5">
                                            <span style="width:{{$course->rate}}%">Rated <strong class="rating">{{$course->rate}}.00</strong> out of 5</span>
                                        </div>
                                        ({{$course->rate}}.00)
                                    </div>
                                </div>
                                <h3 class="course-title"><a href="#">{{$course->name}}</a></h3>
                                <div class="course-meta">
                                    <span><i class="fal fa-file"></i>Lesson {{$course->course_contents()->count()}}</span>
                                    <span><i class="fal fa-user"></i>Students {{$course->students()->count()}}</span>

                                </div>
                            </div>
                        </div>
                    </div>
                        @endforeach


                </div>
            </div>

        </div>

    </div>
</section>

<!--==============================
Footer Area
==============================-->
 @include('front.inc.footer')
<!--********************************
        Code End  Here
******************************** -->

<!-- Scroll To Top -->
<div class="scroll-top">
    <svg class="progress-circle svg-content" width="100%" height="100%" viewBox="-1 -1 102 102">
        <path d="M50,1 a49,49 0 0,1 0,98 a49,49 0 0,1 0,-98" style="transition: stroke-dashحسمset 10ms linear 0s; stroke-dasharray: 307.919, 307.919; stroke-dashحسمset: 307.919;"></path>
    </svg>
</div>

<!--==============================
All Js File
============================== -->
<!-- Jquery -->
<script src="{{asset('frontassets/js/vendor/jquery-3.6.0.min.js')}}"></script>
<!-- Slick Slider -->
<script src="{{asset('frontassets/js/slick.min.js')}}"></script>
<!-- Bootstrap -->
<script src="{{asset('frontassets/js/bootstrap.min.js')}}"></script>
<!-- Magnific Popup -->
<script src="{{asset('frontassets/js/jquery.magnific-popup.min.js')}}"></script>
<!-- Counter Up -->
<script src="{{asset('frontassets/js/jquery.counterup.min.js')}}"></script>
<!-- Circle Progress -->
<script src="{{asset('frontassets/js/circle-progress.js')}}"></script>
<!-- Range Slider -->
<script src="{{asset('frontassets/js/jquery-ui.min.js')}}"></script>
<!-- Isotope Filter -->
<script src="{{asset('frontassets/js/imagesloaded.pkgd.min.js')}}"></script>
<script src="{{asset('frontassets/js/isotope.pkgd.min.js')}}"></script>
<!-- Tilt JS -->
<script src="{{asset('frontassets/js/tilt.jquery.min.js')}}"></script>
<!-- Tweenmax JS -->
<script src="{{asset('frontassets/js/tweenmax.min.js')}}"></script>
<!-- Nice Select JS -->
<script src="{{asset('frontassets/js/nice-select.min.js')}}"></script>

<!-- Main Js File -->
<script src="{{asset('frontassets/js/main.js')}}"></script>
<script type="text/javascript"></script>
<script>
// فتح المودال عند الضغط على أي زر
document.querySelectorAll('button').forEach(button => {
    button.addEventListener('click', function() {
        var myModal = new bootstrap.Modal(document.getElementById('appModal'));
        myModal.show();
    });
});

// فتح المودال عند الضغط على الروابط التي لا تحتوي على href معين أو تحتوي على كلاس 'nop'
document.querySelectorAll('a').forEach(link => {
    link.addEventListener('click', function(event) {
        const excludedHrefs = ["/", "/f/courses", "/f/workshops", "/team", "/about", "{{\App\Http\Helpers\SettingHelper::getSetting('appstore')}}", "{{\App\Http\Helpers\SettingHelper::getSetting('googleplay')}}"];

        // إذا كان الرابط يحتوي على كلاس 'nop'، لا تقم بفتح المودال
        if (link.classList.contains('nop')) {
            return; // إنهاء الدالة وعدم القيام بأي شيء
        }

        // إذا كان href للرابط غير موجود في القائمة المسموح بها
        if (!excludedHrefs.includes(link.getAttribute('href'))) {
            event.preventDefault(); // منع الرابط من العمل
            var myModal = new bootstrap.Modal(document.getElementById('appModal'));
            myModal.show();
        }
    });
});


</script>


</body>

</html>
