@extends('layouts.tabler-vertical')
@section('title','Admin Profile')

@section('header-top')

    @include('layouts.inc.top-large-bar')

@endsection
@section('content')
    <div class="wrapper">

        <div class="row mt-3" >

            <div class="col-lg-12 col-md-12 col-sm-12">
                <div class="card">
                    <div class="card-body">
                        <h4 class="text-primary mb-3">@lang('admin.update_your_profile')</h4>

                        <form action="{{route('admin.users.profile')}}" method="POST" enctype="multipart/form-data">
                            @csrf

                            <div class="text-center m-3  ">

                                <img onclick="document.getElementById('img_inp').click()" id="user_profile_image" src="{{asset(auth()->user()->image)}}" width="130px" height="130px" class="rounded-circle" style="border: 2px solid #eee;" alt="">


                            <div class="row m-3 justify-content-center">
                                <h3 class="user_profile_name"> {{auth()->user()->name}} </h3>
                                <div class="mt-1">
                                    <span class="badge bg-green-lt">{{auth()->user()->role->name}}</span>
                                </div>
                            </div>
                            </div>
                            <div class="row">

                                <input id="img_inp" type="file" accept="image/*" name="image" class="d-none">

                                <div class="col-lg-4 col-md-6 col-sm-12">
                                    <div class="form-group">
                                        <label>@lang('admin.your_name')</label>
                                        <input id="name_inp" class="form-control" type="text" value="{{auth()->user()->name}}" name="name" placeholder="@lang('admin.user_name_placeholder')">
                                        @error('name') <small  class="form-text  text-danger">{{ $message }}</small>  @enderror
                                    </div>
                                </div>
                                <div class="col-lg-4 col-md-6 col-sm-12">
                                    <div class="form-group">
                                        <label>@lang('admin.your_email')</label>
                                        <input id="email_inp" class="form-control" type="text" value="{{auth()->user()->email}}" name="email" placeholder="@lang('admin.user_email_placeholder')">
                                        @error('email') <small  class="form-text  text-danger">{{ $message }}</small>  @enderror
                                    </div>
                                </div>
                                <div class="col-lg-4 col-md-6 col-sm-12">
                                    <div class="form-group">
                                        <label>@lang('admin.type_new_password')</label>
                                        <input class="form-control" type="text" name="password" placeholder="@lang('admin.password_placeholder')">
                                        @error('password') <small  class="form-text  text-danger">{{ $message }}</small>  @enderror
                                    </div>
                                </div>

                                <div class="col-lg-12 col-md-12 mt-3 col-sm-12">
                                    <div class="form-group">
                                        <label>@lang('admin.type_your_bio')</label>
                                        <textarea class="form-control" type="text" name="bio" placeholder="@lang('admin.bio_placeholder')">{{auth()->user()->bio}}</textarea>
                                        @error('bio') <small  class="form-text  text-danger">{{ $message }}</small>  @enderror
                                    </div>
                                </div>

                            </div>



                            <div class=" wrapper mt-3 text-right justify-content-end" >
                                <button type="submit" class="btn btn-primary">  @lang('admin.save_changes') </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

        </div>
    </div>
@endsection
@section('scripts')
    <script>
        let imgInp=document.getElementById('img_inp');
        let user_profile_image=document.getElementById('user_profile_image');

        let name_inp=document.getElementById('name_inp');
        imgInp.onchange = evt => {
            const [file] = imgInp.files
            if (file) {
                user_profile_image.src = URL.createObjectURL(file)
            }
        }
        const inputHandler = function(e) {

                Array.prototype.forEach.call(document.getElementsByClassName("user_profile_name"), function(element) {
                    // Use `element` here
                    element.innerHTML = e.target.value;
                });

        }
        name_inp.addEventListener('input', inputHandler);
        name_inp.addEventListener('propertychange', inputHandler);


    </script>
@endsection
