@extends('layouts.tabler-vertical')
@section('title','Admin Settings')



@section('header-top')

    @include('layouts.inc.top-large-bar')
    <div class="page-wrapper ">
        <div class="wrapper">
            <!-- Page title -->
            <div class="page-header d-print-none">
                <div class="row align-items-center">
                    <div class="col">
                        <!-- Page pre-title -->

                        <h2 class="page-title">
                            Lot Subscribers
                        </h2>
                    </div>
                    <!-- Page title actions -->
                    <div class="col-auto ms-auto d-print-none">
                    <form action="{{route('admin.subscribers.winner')}}" method="POST">
                        @csrf


                        <input name="lot_id" value="{{$lot->id}}" hidden>
                        <button class="btn btn-indigo"> Pick a winner </button>

                    </form>
                    </div>

                </div>
            </div>
        </div>
    </div>
@endsection

@section('content')
    <div class="wrapper ">
        <div class="row">
            <div class="col-lg-12 col-md-12 col-sm-12">

                <div class="card">
                    <div class="card-body">

                        <div class="table-responsive">
                            <table class="table table-vcenter card-table">
                                <thead>
                                <tr>
                                    <th>id</th>
                                    <th>user_id</th>
                                    <th>user_name</th>
                                    <th>amount</th>
                                    <th>created at</th>
                                    <th>updated at</th>
                                    <th>action</th>
                                </tr>
                                </thead>
                                <tbody>


                                @foreach($subscribers as $subscriber)
                                    <tr>
                                        <td> {{ $subscriber->id }} </td>
                                        <td> {{ $subscriber->user_id }}  </td>
                                        <td> {{ $subscriber->user->name }}     </td>
                                        <td> {{ $subscriber->amount }}     </td>
                                        <td> {{ $subscriber->created_at }} </td>
                                        <td> {{ $subscriber->updated_at->diffForHumans() }} </td>
                                        <td>
                                            <form action="{{route('admin.subscribers.make.winner')}}" method="POST">
                                                @csrf


                                                <input name="lot_id" value="{{$lot->id}}" hidden>
                                                <input name="user_id" value="{{$subscriber->user_id}}" hidden>
                                                <button class="btn btn-indigo"> make a winner </button>

                                            </form>

                                        </td>
                                    </tr>
                                @endforeach


                                </tbody>
                            </table>

                        </div>
                    </div>

                </div>
            </div>
        </div>





        @endsection

        @push('scripts')


         @endpush
