@extends('layouts.tabler-vertical')
@section('title', 'Admin Settings')



@section('header-top')
    <style>
        .shrink-text {
            overflow: hidden;
            text-overflow: ellipsis;
            white-space: nowrap;
            display: inline-block;
            max-width: 150px;
            width: 86px;
            height: 17px;
        }
    </style>
    @include('layouts.inc.top-large-bar')
    <div class="page-wrapper ">
        <div class="wrapper">
            <!-- Page title -->


            <div class="page-header d-print-none">
                <div class="row align-items-center">
                    <div class="col">
                        <!-- Page pre-title -->

                        <h2 class="page-title">
                            {{ __('admin.settings') }}
                        </h2>
                    </div>

                    <div class="col">
                        <a href="{{ route('admin.settings.index', ['type' => 'app']) }}"
                            class="btn btn-outline-warning ms-2">{{__('app')}}</a>
                    </div>

                    <div class="col">
                        <a href="{{ route('admin.settings.index', ['type' => 'dash']) }}"
                            class="btn btn-outline-success ms-2">{{__('dash')}}</a>
                    </div>

                    <!-- Page title actions -->
                    <div class="col-auto ms-auto d-print-none">
                        <div class="btn-list">

                            <a href="#" class="btn btn-indigo d-none d-sm-inline-block" data-bs-toggle="modal"
                                data-bs-target="#modal-large">
                                <!-- Download SVG icon from http://tabler-icons.io/i/plus -->
                                <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24"
                                    viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none"
                                    stroke-linecap="round" stroke-linejoin="round">
                                    <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                    <line x1="12" y1="5" x2="12" y2="19" />
                                    <line x1="5" y1="12" x2="19" y2="12" />
                                </svg>
                                {{ __('admin.create_new_record') }}
                            </a>
                            <a href="#" class="btn btn-indigo d-sm-none btn-icon" data-bs-toggle="modal"
                                data-bs-target="#modal-large" aria-label="Create new report">
                                <!-- Download SVG icon from http://tabler-icons.io/i/plus -->
                                <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24"
                                    viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none"
                                    stroke-linecap="round" stroke-linejoin="round">
                                    <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                    <line x1="12" y1="5" x2="12" y2="19" />
                                    <line x1="5" y1="12" x2="19" y2="12" />
                                </svg>
                            </a>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('content')
    <div class="wrapper ">
        <div class="row">
            <div class="col-lg-12 col-md-12 col-sm-12">

                <div class="card">
                    <div class="card-body">

                        <h3> {{ __('admin.project_variables') }} </h3>


                        <div class="table-responsive">
                            <table class="table table-vcenter card-table">
                                <thead>
                                    <tr>
                                        <th>{{ __('admin.key') }}</th>
                                        <th>{{ __('admin.value') }}</th>
                                        <th>{{ __('admin.type') }}</th>
                                        <th>{{ __('admin.description') }}</th>
                                        <th>{{ __('admin.created_at') }}</th>
                                        <th>{{ __('admin.updated_at') }}</th>
                                        <th>{{ __('admin.actions') }}</th>
                                    </tr>
                                </thead>
                                <tbody>


                                    @foreach ($settings as $setting)
                                        <tr>
                                            <td> {{ $setting->key }} </td>
                                            <td>
                                                <span> {{ $setting->value }} </span>
                                            </td>

                                            <td> {{ $setting->type }} </td>
                                            <td> {{ $setting->description }} </td>

                                            <td>{{ $setting->created_at->diffForHumans() }}</td>
                                            <td>{{ $setting->updated_at->diffForHumans() }}</td>
                                            <td>

                                                <button type="button" href="#" class="btn btn-ghost-success "
                                                    onclick="edit('{{ $setting->id }}')">
                                                    {{ __('admin.edit') }}
                                                </button>

                                            </td>
                                        </tr>
                                    @endforeach


                                </tbody>
                            </table>

                        </div>
                    </div>

                </div>
            </div>
        </div>

        {{--        modals --}}
<div class="modal modal-blur fade" id="modal-large" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"> {{ __('admin.create_new_setting') }} </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form action="{{ route('admin.settings.store') }}" method="post">
                @csrf
                <div class="modal-body scrollable-modal">
                    <div class="row mt-3">

                        <div class="col-lg-12 col-md-12 col-sm-12">
                            <div class="form-group">
                                <label>{{ __('admin.key') }}</label>
                                <input class="form-control" type="text" name="key" required>
                                @error('key')
                                    <small class="form-text text-danger">{{ $message }}</small>
                                @enderror
                            </div>
                        </div>

                        <div class="col-lg-12 col-md-12 col-sm-12 mt-2">
                            <div class="form-group">
                                <label>{{ __('admin.value') }}</label>
                                <textarea class="form-control" rows="5" name="value" required></textarea>
                                @error('value')
                                    <small class="form-text text-danger">{{ $message }}</small>
                                @enderror
                            </div>
                        </div>

                        <div class="col-lg-12 col-md-12 col-sm-12 mt-2">
                            <div class="form-group">
                                <label>{{ __('admin.type') }}</label>
                                <select class="form-control" name="type">
                                    <option value="app">app</option>
                                    <option value="dash">dash</option>
                                </select>
                                @error('type')
                                    <small class="form-text text-danger">{{ $message }}</small>
                                @enderror
                            </div>
                        </div>

                        <div class="col-lg-12 col-md-12 col-sm-12 mt-2">
                            <div class="form-group">
                                <label>{{ __('admin.description') }}</label>
                                <input class="form-control" type="text" name="description">
                                @error('description')
                                    <small class="form-text text-danger">{{ $message }}</small>
                                @enderror
                            </div>
                        </div>

                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn me-auto" data-bs-dismiss="modal">
                        {{ __('admin.close') }}
                    </button>
                    <button type="submit" class="btn btn-primary">
                        {{ __('admin.create_setting') }}
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

        {{--        edit modal --}}

        <div class="modal modal-blur fade" id="edit-modal" tabindex="-1" role="dialog" aria-hidden="true">
            <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
                <div class="modal-content" id="edit-modal-content">

                </div>
            </div>
        </div>


    @endsection

    @push('scripts')
        <script>
            let loader = `@include('components.loader')`;

            function edit(id) {
                $("#edit-modal-content").html(loader);
                $('#edit-modal').modal('show');
                $("#edit-modal-content").load(`admin/settings/${id}/edit`);
            }
        </script>
    @endpush
