<div class="modal-header">
    <h5 class="modal-title">{{ __('admin.edit_setting') }}</h5>
    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
</div>

<form action="{{ route('admin.settings.update', ['setting' => $setting->id]) }}" method="post">
    @csrf
    @method('PUT')
    <div class="modal-body scrollable-modal">

        <div class="row mt-3">

            <div class="col-lg-12 col-md-12 col-sm-12">
                <div class="form-group">
                    <label>{{ __('admin.key') }}</label>
                    <input class="form-control" type="text" value="{{ $setting->key }}" disabled
                        placeholder="{{ __('admin.key') }}">
                </div>
            </div>
            <div class="col-lg-12 col-md-12 col-sm-12 mt-2">
                <div class="form-group">
                    <label>{{ __('admin.value') }}</label>
                    <textarea class="form-control" type="text" rows="5" name="value" required
                        placeholder="{{ __('admin.value') }}">{{ $setting->value }}</textarea>
                    @error('value')
                        <small class="form-text  text-danger">{{ $message }}</small>
                    @enderror
                </div>
            </div>

            <div class="col-lg-12 col-md-12 col-sm-12 mt-2">
                <div class="form-group">
                    <label>{{ __('admin.type') }}</label>

                    <select class="form-control" name="type">
                        <option value="app" @if ($setting->type == 'app') selected @endif>app</option>
                        <option value="dash" @if ($setting->type == 'dash') selected @endif>dash</option>
                    </select>

                    @error('type')
                        <small class="form-text  text-danger">{{ $message }}</small>
                    @enderror
                </div>
            </div>

            <div class="col-lg-12 col-md-12 col-sm-12 mt-2">
                <div class="form-group">
                    <label>{{ __('admin.description') }}</label>

                    <input class="form-control" type="text" name="description" value="{{ $setting->description }}"
                        placeholder="{{ __('admin.description') }}">

                    @error('description')
                        <small class="form-text  text-danger">{{ $message }}</small>
                    @enderror
                </div>
            </div>


        </div>


    </div>
    <div class="modal-footer">
        <button type="button" class="btn me-auto" data-bs-dismiss="modal">{{ __('admin.close') }}</button>
        <button type="submit" class="btn btn-primary"> {{ __('admin.update_setting') }} </button>
    </div>
</form>
