@extends('layouts.tabler-vertical')
@section('title','Admin Settings')

@section('header-top')

    @include('layouts.inc.top-large-bar')
    <div class="page-wrapper ">
        <div class="wrapper">
            <!-- Page title -->
            <div class="page-header d-print-none">
                <div class="row align-items-center">
                    <div class="col">
                        <!-- Page pre-title -->

                        <h2 class="page-title">
                            Quiz Questions
                        </h2>
                    </div>
                    <!-- Page title actions -->
                    <div class="col-auto ms-auto d-print-none">


                        <div class="btn-list">

                            <a href="#" class="btn btn-indigo d-none d-sm-inline-block" data-bs-toggle="modal"
                               data-bs-target="#modal-large">
                                <!-- Download SVG icon from http://tabler-icons.io/i/plus -->
                                <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24"
                                     viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none"
                                     stroke-linecap="round" stroke-linejoin="round">
                                    <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
                                    <line x1="12" y1="5" x2="12" y2="19"/>
                                    <line x1="5" y1="12" x2="19" y2="12"/>
                                </svg>
                                Add Quiz Questions
                            </a>
                            <a href="#" class="btn btn-indigo d-sm-none btn-icon" data-bs-toggle="modal"
                               data-bs-target="#modal-large" aria-label="Create new report">
                                <!-- Download SVG icon from http://tabler-icons.io/i/plus -->
                                <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24"
                                     viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none"
                                     stroke-linecap="round" stroke-linejoin="round">
                                    <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
                                    <line x1="12" y1="5" x2="12" y2="19"/>
                                    <line x1="5" y1="12" x2="19" y2="12"/>
                                </svg>
                            </a>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('content')
    <div class="wrapper ">
        <div class="row">
            <div class="col-lg-12 col-md-12 col-sm-12">

                <div class="card">
                    <div class="card-body-s">
                        <div class="table-responsive">
                            <table class="table table-vcenter card-table">
                                <thead>
                                <tr>
                                    <th>id</th>

                                    <th>question</th>
                                    <th>answer a</th>
                                    <th>answer b</th>
                                    <th>answer c</th>
                                    <th>answer d</th>
                                    <th>correct answer</th>
                                    <th>updated at</th>
                                    <th class="w-1"> actions </th>
                                </tr>
                                </thead>
                                <tbody>
                                @foreach($questions as $question)
                                    <tr>
                                        <td>{{$question->id}}</td>

                                        <td class="text-muted">  {{$question->question}} </td>
                                        <td class="text-muted">  {{$question->answer_a}} </td>
                                        <td class="text-muted">  {{$question->answer_b}} </td>
                                        <td class="text-muted">  {{$question->answer_c}} </td>
                                        <td class="text-muted">  {{$question->answer_d}} </td>
                                        <td class="text-muted">  {{$question->correct_answer}} </td>
                                        <td class="text-muted">  {{$question->updated_at->diffForHumans()}} </td>


                                        <td>

                                            <div class="dropdown"  >
                                                <button class="btn dropdown-toggle align-text-top" data-bs-toggle="dropdown" aria-expanded="false" >
                                                    Actions
                                                </button>
                                                <div class="dropdown-menu dropdown-menu-end" style="">

                                                        <button onclick="edit('{{$question->id}}')" class="dropdown-item"  > <i class='bx bxs-edit' ></i> &nbsp; edit</button>

                                                        <button onclick="deleteRecord('{{route('admin.quiz_questions.destroy',['quiz_question'=>$question->id])}}')"  class="dropdown-item"  > <i class='bx bx-trash' ></i> &nbsp;  delete</button>

                                                </div>
                                            </div>

                                        </td>
                                    </tr>
                                @endforeach


                                </tbody>
                            </table>
                        </div>

                                                <div class="row">
                                                    <div class="pagination">
                                                        {!! $questions->links('pagination::bootstrap-4') !!}
                                                    </div>
                                                </div>
                    </div>

                </div>
            </div>
        </div>

        {{--        modals--}}
        <div class="modal modal-blur fade" id="modal-large" tabindex="-1" role="dialog" aria-hidden="true">
            <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Create New question</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <form action="{{route('admin.quiz_questions.store')}}" method="post" enctype="multipart/form-data">
                        @csrf
                        <input name="course_test_id" value="{{$test->id}}" hidden>
                        <div class="modal-body scrollable-modal">

                            <div class="row mt-3">

                                <div class="col-12 ">

                                    <button type="button"  onclick="setDir('ltr')" class="btn btn-light ">
                                        <!-- Download SVG icon from http://tabler-icons.io/i/align-left -->
                                        <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><line x1="4" y1="6" x2="20" y2="6" /><line x1="4" y1="12" x2="14" y2="12" /><line x1="4" y1="18" x2="18" y2="18" /></svg>
                                    </button>
                                    <button type="button" onclick="setDir('rtl')" class="btn btn-light ">
                                        <!-- Download SVG icon from http://tabler-icons.io/i/align-right -->
                                        <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><line x1="4" y1="6" x2="20" y2="6" /><line x1="10" y1="12" x2="20" y2="12" /><line x1="6" y1="18" x2="20" y2="18" /></svg>
                                    </button>

                                </div>

                                <div class="col-lg-12 col-md-12 col-sm-12">
                                    <div class="form-group">
                                        <label class="form-label">question</label>
                                        <input class="form-control" type="text" name="question" placeholder="question">
                                        @error('question') <small  class="form-text  text-danger">{{ $message }}</small> @enderror
                                    </div>
                                </div>
                                <div class="col-lg-12 col-md-12 col-sm-12">
                                    <div class="form-group">
                                        <label class="form-label">answer a </label>
                                        <div class="input-group mb-2">
                                            <span class="input-group-text"> a </span>
                                            <input type="text" name="answer_a" class="form-control" placeholder="answer a" autocomplete="off">
                                        </div>
                                        @error('answer_a') <small  class="form-text  text-danger">{{ $message }}</small> @enderror
                                    </div>
                                </div>
                                <div class="col-lg-12 col-md-12 col-sm-12">
                                    <div class="form-group">
                                        <label class="form-label">answer b </label>
                                        <div class="input-group mb-2">
                                            <span class="input-group-text"> b </span>
                                            <input type="text" name="answer_b" class="form-control" placeholder="answer b" autocomplete="off">
                                        </div>
                                        @error('answer_b') <small  class="form-text  text-danger">{{ $message }}</small> @enderror
                                    </div>
                                </div>
                                <div class="col-lg-12 col-md-12 col-sm-12">
                                    <div class="form-group">
                                        <label class="form-label">answer c </label>
                                        <div class="input-group mb-2">
                                            <span class="input-group-text"> c </span>
                                            <input type="text" name="answer_c" class="form-control" placeholder="answer c" autocomplete="off">
                                        </div>
                                        @error('answer_c') <small  class="form-text  text-danger">{{ $message }}</small> @enderror
                                    </div>
                                </div>
                                <div class="col-lg-12 col-md-12 col-sm-12">
                                    <div class="form-group">
                                        <label class="form-label">answer d </label>
                                        <div class="input-group mb-2">
                                            <span class="input-group-text"> d </span>
                                            <input type="text" name="answer_d" class="form-control" placeholder="answer d" autocomplete="off">
                                        </div>
                                        @error('answer_d') <small  class="form-text  text-danger">{{ $message }}</small> @enderror
                                    </div>
                                </div>
                                <div class="col-lg-12 col-md-12 col-sm-12">
                                    <div class="form-group">
                                        <label class="form-label"> correct answer </label>
                                        <select name="correct_answer" class="form-select">
                                            <option value="answer_a"> answer a </option>
                                            <option value="answer_b"> answer b </option>
                                            <option value="answer_c"> answer c </option>
                                            <option value="answer_d"> answer d </option>
                                        </select>
                                        @error('correct_answer') <small  class="form-text  text-danger">{{ $message }}</small> @enderror
                                    </div>
                                </div>
                            </div>


                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn me-auto" data-bs-dismiss="modal">Close</button>
                            <button type="submit" class="btn btn-primary">
                                Create Quiz Question
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        {{--        edit modal--}}

        <div class="modal modal-blur fade" id="edit-modal" tabindex="-1" role="dialog" aria-hidden="true">
            <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
                <div class="modal-content" id="edit-modal-content">

                </div>
            </div>
        </div>

        @include('components.remove-modal')
        @endsection

        @push('scripts')
            <script>

                const dropdowns = document.querySelectorAll('.dropdown-toggle')
                const dropdown = [...dropdowns].map((dropdownToggleEl) => new bootstrap.Dropdown(dropdownToggleEl, {
                    popperConfig(defaultBsPopperConfig) {
                        return { ...defaultBsPopperConfig, strategy: 'fixed' };
                    }
                }));

                let loader = `@include('components.loader')`;

                function edit(id) {
                    $("#edit-modal-content").html(loader);
                    $('#edit-modal').modal('show');
                    $("#edit-modal-content").load(`admin/quiz_questions/${id}/edit`);
                }


                function setDir(dir) {
                    // Use querySelectorAll for more modern and efficient element selection
                    const elements = document.querySelectorAll('.direc');

                    if (elements.length === 0) {
                        console.warn("No elements found with class 'direc'.");
                        return; // Exit the function if no elements are found
                    }

                    if (dir.toLowerCase() === 'rtl') {
                        elements.forEach(element => element.setAttribute('dir', 'rtl'));
                    } else if (dir.toLowerCase() === 'ltr') {
                        elements.forEach(element => element.setAttribute('dir', 'ltr'));
                    } else {
                        console.warn("Invalid direction specified. Please use 'rtl' or 'ltr'.");
                    }
                }
            </script>
            <script>
                function deleteRecord(action) {
                    console.log(action)
                    $("#remove-form").attr('action', action);
                    $("#modal-danger").modal('show');
                }

            </script>
    @endpush
