@extends('layouts.tabler-vertical')
@section('title', 'Admin Settings')

@section('header-top')

    @include('layouts.inc.top-large-bar')
    <div class="page-wrapper ">
        <div class="wrapper">
            <!-- Page title -->
            <div class="page-header d-print-none">
                <div class="row align-items-center">
                    <div class="col">
                        <!-- Page pre-title -->

                        <h2 class="page-title">
                            {{ __('admin.courses') }}
                        </h2>
                    </div>
                    <!-- Page title actions -->
                    <div class="col-auto ms-auto d-print-none">


                        <div class="btn-list">

                            <a href="#" class="btn btn-indigo d-none d-sm-inline-block" data-bs-toggle="modal"
                                data-bs-target="#modal-large">
                                <!-- Download SVG icon from http://tabler-icons.io/i/plus -->
                                <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24"
                                    viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none"
                                    stroke-linecap="round" stroke-linejoin="round">
                                    <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                    <line x1="12" y1="5" x2="12" y2="19" />
                                    <line x1="5" y1="12" x2="19" y2="12" />
                                </svg>
                                {{ __('admin.add_new_course') }}
                            </a>
                            <a href="#" class="btn btn-indigo d-sm-none btn-icon" data-bs-toggle="modal"
                                data-bs-target="#modal-large" aria-label="Create new report">
                                <!-- Download SVG icon from http://tabler-icons.io/i/plus -->
                                <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24"
                                    viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none"
                                    stroke-linecap="round" stroke-linejoin="round">
                                    <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                    <line x1="12" y1="5" x2="12" y2="19" />
                                    <line x1="5" y1="12" x2="19" y2="12" />
                                </svg>
                            </a>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('content')
    <div class="wrapper ">
        <div class="row">
            <div class="col-lg-12 col-md-12 col-sm-12">

                <div class="card">
                    <div class="card-body-s">

                        <div class="table-responsive">
                            <table class="table table-vcenter card-table">
                                <thead>
                                    <tr>
                                        <th>{{ __('admin.id') }}</th>
                                        <th>{{ __('admin.name') }}</th>
                                        <th>{{ __('admin.category') }}</th>
                                        <th>{{ __('admin.price') }}</th>
                                        <th>{{ __('admin.hours') }}</th>
                                        <th>{{ __('admin.teacher_name') }}</th>
                                        <th>{{ __('admin.is_free') }}</th>
                                        <th> التفعيل </th>
                                        <th>{{ __('admin.created_at') }}</th>
                                        <th>{{ __('admin.updated_at') }}</th>
                                        <th>{{ __('admin.actions') }}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($courses as $course)
                                        <tr>
                                            <td>{{ $course->id }}</td>
                                            <td>{{ $course->name }}</td>
                                            <td>{{ $course->category->name }}</td>
                                            <td>{{ $course->price }}</td>

                                            <td>{{ $course->hours ?? __('admin.not_specified') }}</td>
                                            <td>{{ $course->author ? $course->author->name : ' ' }}</td>
                                            <td>{{ $course->is_free ? __('admin.free') : __('admin.paid') }}</td>
                                            <td>
                                                @if ($course->is_active == '0')
                                                    <a
                                                        href="{{ route('admin.courses.toggle', ['id' => $course->id, 'state' => '1']) }}">
                                                        <span class="form-colorinput-color bg-red rounded-circle"></span>
                                                    </a>
                                                @else
                                                    <a
                                                        href="{{ route('admin.courses.toggle', ['id' => $course->id, 'state' => '0']) }}">
                                                        <span class="form-colorinput-color bg-lime rounded-circle"></span>
                                                    </a>
                                                @endif

                                            </td>
                                            <td>{{ $course->created_at->diffForHumans() }}</td>
                                            <td>{{ $course->updated_at->diffForHumans() }}</td>
                                            <td>
                                                <div class="dropdown">
                                                    <button class="btn dropdown-toggle align-text-top"
                                                        data-bs-toggle="dropdown" aria-expanded="false">
                                                        {{ __('admin.actions') }}
                                                    </button>
                                                    <div class="dropdown-menu dropdown-menu-end">

                                                        <a href="{{ route('admin.courses.content', $course->id) }}"
                                                            class="dropdown-item"> {{ __('admin.contents') }} </a>
                                                        <a href="{{ route('admin.courses.joins', $course->id) }}"
                                                            class="dropdown-item"> طلبات الانضمام </a>
                                                        <a href="{{ route('admin.courses.students.show', $course->id) }}"
                                                            class="dropdown-item"> {{ __('admin.students') }} </a>
                                                        <a href="{{ route('admin.courses.show', $course->id) }}"
                                                            class="dropdown-item"> {{ __('admin.coupons') }} </a>
                                                        <a href="{{ route('admin.courses.exam', $course->id) }}"
                                                            class="dropdown-item"> {{ __('admin.exam') }} </a>
                                                        <a href="{{ route('admin.files.in.folders', rawurlencode('Virtual Court/courses/c_' . $course->id)) }}"
                                                            target="_blank" class="dropdown-item"> رفع الملفات </a>
                                                        <button type="button" class="dropdown-item"
                                                            onclick="edit('{{ $course->id }}')">{{ __('admin.edit') }}</button>
                                                        <button type="button"
                                                            onclick="deleteRecord('{{ route('admin.courses.destroy', ['course' => $course->id]) }}')"
                                                            class="dropdown-item">{{ __('admin.delete') }}</button>
                                                    </div>
                                                </div>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                        <div class="row">
                            <div class="pagination">
                                {!! $courses->links('pagination::bootstrap-4') !!}
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>

        {{--        modals --}}
        <div class="modal modal-blur fade" id="modal-large" tabindex="-1" role="dialog" aria-hidden="true">
            <div class="modal-dialog modal-xl modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">{{ __('admin.create_new_course') }}</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <form action="{{ route('admin.courses.store') }}" method="post" enctype="multipart/form-data">
                        @csrf
                        <div class="modal-body scrollable-modal">
                            <div class="row mt-3">

                                <div class="col-12 ">

                                    <button type="button" onclick="setDir('ltr')" class="btn btn-light ">
                                        <!-- Download SVG icon from http://tabler-icons.io/i/align-left -->
                                        <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24"
                                            height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor"
                                            fill="none" stroke-linecap="round" stroke-linejoin="round">
                                            <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                            <line x1="4" y1="6" x2="20" y2="6" />
                                            <line x1="4" y1="12" x2="14" y2="12" />
                                            <line x1="4" y1="18" x2="18" y2="18" />
                                        </svg>
                                    </button>
                                    <button type="button" onclick="setDir('rtl')" class="btn btn-light ">
                                        <!-- Download SVG icon from http://tabler-icons.io/i/align-right -->
                                        <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24"
                                            height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor"
                                            fill="none" stroke-linecap="round" stroke-linejoin="round">
                                            <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                            <line x1="4" y1="6" x2="20" y2="6" />
                                            <line x1="10" y1="12" x2="20" y2="12" />
                                            <line x1="6" y1="18" x2="20" y2="18" />
                                        </svg>
                                    </button>

                                </div>

                                <div class="col-lg-12 col-md-12 col-sm-12 mt-2">
                                    <div class="form-group">
                                        <label>{{ __('admin.name') }}</label>
                                        <input class="form-control @error('name') is-invalid @enderror direc"
                                            type="text" name="name" placeholder="Name">
                                        @error('name')
                                            <small class="form-text text-danger">{{ $message }}</small>
                                        @enderror
                                    </div>
                                </div>
                                <div class="col-lg-12 col-md-12 col-sm-12 mt-2">
                                    <div class="form-group">
                                        <label>{{ __('admin.description') }}</label>
                                        <textarea class="form-control @error('description') is-invalid @enderror direc" name="description"
                                            placeholder="Description"></textarea>
                                        @error('description')
                                            <small class="form-text text-danger">{{ $message }}</small>
                                        @enderror
                                    </div>
                                </div>


                                <div class="col-lg-4 col-md-6 col-sm-12 mt-2">
                                    <div class="form-group">
                                        <label>{{ __('admin.price') }}</label>
                                        <input class="form-control @error('price') is-invalid @enderror direc"
                                            type="text" name="price" placeholder="{{ __('admin.price') }}">
                                        @error('price')
                                            <small class="form-text text-danger">{{ $message }}</small>
                                        @enderror
                                    </div>
                                </div>

                                <div class="col-lg-4 col-md-6 col-sm-12 mt-2">
                                    <div class="form-group">
                                        <label>عدد الساعات</label>
                                        <input class="form-control @error('hours') is-invalid @enderror direc"
                                            type="number" name="hours" placeholder="Hours (Optional)">
                                        @error('hours')
                                            <small class="form-text text-danger">{{ $message }}</small>
                                        @enderror
                                    </div>
                                </div>
                                <div class="col-lg-4 col-md-6 col-sm-12 mt-2">
                                    <div class="form-group">
                                        <label>{{ __('admin.category') }}</label>
                                        <select class="form-select direc" name="category_id">

                                            @foreach ($categories as $category)
                                                <option value="{{ $category->id }}">{{ $category->name }}</option>
                                            @endforeach
                                        </select>
                                        @error('category_id')
                                            <small class="form-text text-danger">{{ $message }}</small>
                                        @enderror
                                    </div>
                                </div>
                                <div class="col-lg-4 col-md-6 col-sm-12 mt-2">
                                    <div class="form-group">
                                        <label>{{ __('admin.author') }}</label>
                                        <select class="form-select @error('author_id') is-invalid @enderror direc"
                                            name="author_id">

                                            @foreach (\App\Models\User::where('role_id', 3)->select(['id', 'name'])->get() as $user)
                                                <option value="{{ $user->id }}">{{ $user->name }}</option>
                                            @endforeach


                                        </select>
                                        @error('author_id')
                                            <small class="form-text text-danger">{{ $message }}</small>
                                        @enderror
                                    </div>
                                </div>

                                <div class="col-lg-4 col-md-6 col-sm-12 mt-2">
                                    <div class="form-group">
                                        <label>{{ __('admin.course_image') }}</label>
                                        <input class="form-control @error('image') is-invalid @enderror direc"
                                            type="file" name="image" placeholder="{{ __('admin.course_image') }}">
                                        @error('image')
                                            <small class="form-text text-danger">{{ $message }}</small>
                                        @enderror
                                    </div>
                                </div>

                                <div class="col-lg-6 col-md-6 col-sm-12 mt-2">
                                    <div class="form-group">
                                        <label>{{ __('admin.course_pdf') }}</label>
                                        <input class="form-control @error('pdf') is-invalid @enderror direc"
                                            type="file" name="pdf" placeholder="{{ __('admin.course_pdf') }}">
                                        @error('pdf')
                                            <small class="form-text text-danger">{{ $message }}</small>
                                        @enderror
                                    </div>
                                </div>

                                <div class="col-lg-6 col-md-6 col-sm-12 mt-2">
                                    <div class="form-group">
                                        <label>{{ __('admin.is_free') }}</label>
                                        <select class="form-select @error('is_free') is-invalid @enderror direc"
                                            name="is_free">
                                            <option value="0">{{ __('admin.no') }}</option>
                                            <option value="1">{{ __('admin.yes') }}</option>
                                        </select>
                                        @error('is_free')
                                            <small class="form-text text-danger">{{ $message }}</small>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn me-auto"
                                data-bs-dismiss="modal">{{ __('admin.close') }}</button>
                            <button type="submit" class="btn btn-primary">
                                {{ __('admin.create_course') }}
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        {{--        edit modal --}}

        <div class="modal modal-blur fade" id="edit-modal" tabindex="-1" role="dialog" aria-hidden="true">
            <div class="modal-dialog modal-xl modal-dialog-centered" role="document">
                <div class="modal-content" id="edit-modal-content">

                </div>
            </div>
        </div>

        @include('components.remove-modal')
    @endsection

    @push('scripts')
        <script>
            const dropdowns = document.querySelectorAll('.dropdown-toggle')
            const dropdown = [...dropdowns].map((dropdownToggleEl) => new bootstrap.Dropdown(dropdownToggleEl, {
                popperConfig(defaultBsPopperConfig) {
                    return {
                        ...defaultBsPopperConfig,
                        strategy: 'fixed'
                    };
                }
            }));

            let loader = `@include('components.loader')`;

            function edit(id) {
                $("#edit-modal-content").html(loader);
                $('#edit-modal').modal('show');
                $("#edit-modal-content").load(`admin/courses/${id}/edit`);
            }


            function setDir(dir) {
                // Use querySelectorAll for more modern and efficient element selection
                const elements = document.querySelectorAll('.direc');

                if (elements.length === 0) {
                    console.warn("No elements found with class 'direc'.");
                    return; // Exit the function if no elements are found
                }

                if (dir.toLowerCase() === 'rtl') {
                    elements.forEach(element => element.setAttribute('dir', 'rtl'));
                } else if (dir.toLowerCase() === 'ltr') {
                    elements.forEach(element => element.setAttribute('dir', 'ltr'));
                } else {
                    console.warn("Invalid direction specified. Please use 'rtl' or 'ltr'.");
                }
            }
        </script>
        <script>
            function deleteRecord(action) {
                console.log(action)
                $("#remove-form").attr('action', action);
                $("#modal-danger").modal('show');
            }
        </script>
    @endpush
