<div class="modal-header">
    <h5 class="modal-title"> {{ __('admin.edit_course') }} </h5>
    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
</div>
<form action="{{route('admin.courses.update',['course'=>$course->id])}}" method="post" enctype="multipart/form-data">
    @csrf
    @method('PUT')
    <div class="modal-body scrollable-modal">
        <div class="row ">
            <div class="col-12 mt-2">
                <button type="button" onclick="setDir('ltr')" class="btn btn-light ">
                    <!-- Download SVG icon from http://tabler-icons.io/i/align-left -->
                    <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round">
                        <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
                        <line x1="4" y1="6" x2="20" y2="6" />
                        <line x1="4" y1="12" x2="14" y2="12" />
                        <line x1="4" y1="18" x2="18" y2="18" />
                    </svg>
                </button>
                <button type="button" onclick="setDir('rtl')" class="btn btn-light ">
                    <!-- Download SVG icon from http://tabler-icons.io/i/align-right -->
                    <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round">
                        <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
                        <line x1="4" y1="6" x2="20" y2="6" />
                        <line x1="10" y1="12" x2="20" y2="12" />
                        <line x1="6" y1="18" x2="20" y2="18" />
                    </svg>
                </button>
            </div>

            <div class="col-lg-12 col-md-12 col-sm-12 mt-2">
                <div class="form-group">
                    <label>{{ __('admin.name') }}</label>
                    <input class="form-control @error('name') is-invalid @enderror direc" type="text" name="name" placeholder="{{ __('admin.name') }}" value="{{$course->name}}">
                    @error('name') <small class="form-text text-danger">{{ $message }}</small> @enderror
                </div>
            </div>

            <div class="col-lg-12 col-md-12 col-sm-12 mt-2">
                <div class="form-group">
                    <label>{{ __('admin.description') }}</label>
                    <textarea class="form-control @error('description') is-invalid @enderror direc" name="description" placeholder="{{ __('admin.description') }}">{{$course->description}}</textarea>
                    @error('description') <small class="form-text text-danger">{{ $message }}</small> @enderror
                </div>
            </div>

            <div class="col-lg-4 col-md-6 col-sm-12 mt-2">
                <div class="form-group">
                    <label>{{ __('admin.price') }}</label>
                    <input class="form-control @error('price') is-invalid @enderror direc" type="text" name="price" placeholder="{{ __('admin.price') }}" value="{{$course->price}}">
                    @error('price') <small class="form-text text-danger">{{ $message }}</small> @enderror
                </div>
            </div>


            <div class="col-lg-4 col-md-6 col-sm-12 mt-2">
                <div class="form-group">
                    <label>{{ __('admin.course_pdf') }}</label>
                    <input class="form-control @error('pdf') is-invalid @enderror direc" type="file" name="pdf" placeholder="{{ __('admin.course_pdf') }}">
                    @error('pdf') <small class="form-text text-danger">{{ $message }}</small> @enderror
                </div>
            </div>
            <div class="col-lg-4 col-md-6 col-sm-12 mt-2">
                <div class="form-group">
                    <label>عدد الساعات المتوقع</label>
                    <input class="form-control @error('hours') is-invalid @enderror direc" type="text" name="hours" placeholder="عدد الساعات" value="{{$course->hours}}">
                    @error('hours') <small class="form-text text-danger">{{ $message }}</small> @enderror
                </div>
            </div>
            <div class="col-lg-4 col-md-6 col-sm-12 mt-2">
                <div class="form-group">
                    <label>{{ __('admin.category') }}</label>
                    <select class="form-select direc" name="category_id">

                        @foreach($categories as $category)
                            <option @if($category->id == $course->category_id) selected @endif value="{{$category->id}}">{{$category->name}}</option>
                        @endforeach
                    </select>
                    @error('category_id') <small class="form-text text-danger">{{ $message }}</small> @enderror
                </div>
            </div>
            <div class="col-lg-4 col-md-6 col-sm-12 mt-2">
                <div class="form-group">
                    <label>{{ __('admin.is_free') }}</label>
                    <select class="form-select @error('is_free') is-invalid @enderror direc" name="is_free">
                        <option value="0" {{$course->is_free == 0 ? 'selected' : ''}}>{{ __('admin.no') }}</option>
                        <option value="1" {{$course->is_free == 1 ? 'selected' : ''}}>{{ __('admin.yes') }}</option>
                    </select>
                    @error('is_free') <small class="form-text text-danger">{{ $message }}</small> @enderror
                </div>
            </div>




            <div class="col-lg-4 col-md-6 col-sm-12 mt-2">
                <div class="form-group">
                    <label>{{ __('admin.course_image') }}</label>
                    <input class="form-control @error('image') is-invalid @enderror direc" type="file" name="image">
                    @error('image') <small class="form-text text-danger">{{ $message }}</small> @enderror
                    <img src="{{ asset($course->image) }}" alt="Course Image" class="img-thumbnail mt-2" width="100">
                </div>
            </div>
            <div class="col-lg-4 col-md-6 col-sm-12 mt-2">
                <div class="form-group">
                    <label>{{ __('admin.is_exam_active') }}</label>
                    <select class="form-select @error('is_exam_active') is-invalid @enderror direc" name="is_exam_active">
                        <option value="0" {{$course->is_exam_active == 0 ? 'selected' : ''}}>{{ __('admin.no') }}</option>
                        <option value="1" {{$course->is_exam_active == 1 ? 'selected' : ''}}>{{ __('admin.yes') }}</option>
                    </select>
                    @error('is_exam_active') <small class="form-text text-danger">{{ $message }}</small> @enderror
                </div>
            </div>
            <div class="col-lg-4 col-md-6 col-sm-12 mt-2">
                <div class="form-group">
                    <label>{{ __('admin.author') }}</label>
                    <select class="form-select @error('author_id') is-invalid @enderror direc" name="author_id">

                        @foreach(\App\Models\User::where('role_id',3)->select(['id','name'])->get() as $user)
                            <option @if($user->id == $course->author_id) selected @endif value="{{$user->id}}">{{$user->name}}</option>
                        @endforeach


                    </select>
                    @error('author_id') <small class="form-text text-danger">{{ $message }}</small> @enderror
                </div>
            </div>

                <div class="col-lg-12 col-md-12 col-sm-12 mt-2">
                                    <div class="form-group">
                                        <label>الفيديو التعريفي</label>
                                        <input class="form-control @error('promo_link') is-invalid @enderror direc" type="text" name="promo_link" value="{{$course->promo_link}}" placeholder="رابط الفيديو التعريفي">
                                        @error('promo_link') <small class="form-text text-danger">{{ $message }}</small> @enderror
                                    </div>
                                </div>


        </div>
    </div>
    <div class="modal-footer">
        <button type="button" class="btn me-auto" data-bs-dismiss="modal">{{ __('admin.close') }}</button>
        <button type="submit" class="btn btn-primary">{{ __('admin.save') }}</button>
    </div>
</form>
