@extends('layouts.tabler-vertical')
@section('title','Admin Settings')

@section('header-top')

    @include('layouts.inc.top-large-bar')
    <div class="page-wrapper ">
        <div class="wrapper">
            <!-- Page title -->
            <div class="page-header d-print-none">
                <div class="row align-items-center">
                    <div class="col">
                        <!-- Page pre-title -->

                        <h2 class="page-title">
                           محتويات الكورس
                        </h2>
                    </div>
                    <!-- Page title actions -->
                    <div class="col-auto ms-auto d-print-none">


                        <div class="btn-list">

                            <a href="#" class="btn btn-indigo d-none d-sm-inline-block" data-bs-toggle="modal"
                               data-bs-target="#modal-large">
                                <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24"
                                     viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none"
                                     stroke-linecap="round" stroke-linejoin="round">
                                    <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
                                    <line x1="12" y1="5" x2="12" y2="19"/>
                                    <line x1="5" y1="12" x2="19" y2="12"/>
                                </svg>
                                إضافة درس جديد
                            </a>
                            <a href="#" class="btn btn-indigo d-sm-none btn-icon" data-bs-toggle="modal"
                               data-bs-target="#modal-large" aria-label="Create new lesson">
                                <!-- Download SVG icon from http://tabler-icons.io/i/plus -->
                                <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24"
                                     viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none"
                                     stroke-linecap="round" stroke-linejoin="round">
                                    <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
                                    <line x1="12" y1="5" x2="12" y2="19"/>
                                    <line x1="5" y1="12" x2="19" y2="12"/>
                                </svg>
                            </a>

                            <a href="#" class="btn btn-indigo d-none d-sm-inline-block" data-bs-toggle="modal"
                               data-bs-target="#modal-large-quiz">
                                <!-- Download SVG icon from http://tabler-icons.io/i/plus -->
                                <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24"
                                     viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none"
                                     stroke-linecap="round" stroke-linejoin="round">
                                    <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
                                    <line x1="12" y1="5" x2="12" y2="19"/>
                                    <line x1="5" y1="12" x2="19" y2="12"/>
                                </svg>
                                إضافة كويز جديد
                            </a>
                            <a href="#" class="btn btn-indigo d-sm-none btn-icon" data-bs-toggle="modal"
                               data-bs-target="#modal-large-quiz" aria-label="Create new quiz">
                                <!-- Download SVG icon from http://tabler-icons.io/i/plus -->
                                <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24"
                                     viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none"
                                     stroke-linecap="round" stroke-linejoin="round">
                                    <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
                                    <line x1="12" y1="5" x2="12" y2="19"/>
                                    <line x1="5" y1="12" x2="19" y2="12"/>
                                </svg>
                            </a>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('content')
    <div class="wrapper ">
        <div class="row">
            <div class="col-12">
               <h2> {{ $course->name }} </h2>
            </div>
            <div class="col-lg-12 col-md-12 col-sm-12">

                <div class="card">
                    <div class="card-body-s">
                        <div class="card">

                            <div class="list-group list-group-flush overflow-auto" style="max-height: 35rem">

                                @foreach ($courseContents as $content)

                                    @if ($content->contentable instanceof App\Models\Lesson)


                                        <div class="list-group-item">
                                            <div class="row">
                                                <div class="col-auto">
                                                    <a href="#">
                                                        <span class="avatar">
                                                         <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M15 10l4.553 -2.276a1 1 0 0 1 1.447 .894v6.764a1 1 0 0 1 -1.447 .894l-4.553 -2.276v-4z" /><rect x="3" y="6" width="12" height="12" rx="2" /></svg>
                                                        </span>
                                                    </a>
                                                </div>
                                                <div class="col text-truncate">
                                                    <a href="{{$content->contentable->url}}" target="_blank" class="text-body d-block">
                                                                           <span class="text-blue"><i class='bx bx-link'></i>
                                                                               {{$content->contentable->title}}
                                                                           </span>

                                                    </a>
                                                    <div class="text-muted text-truncate mt-n1">{{$content->contentable->description}}</div>
                                                    @if($content->contentable->active)
                                                        <span class="text-success"> active </span>
                                                    @else
                                                        <span class="text-danger"> not active </span> -
                                                    @endif

                                                    @if($content->contentable->is_free)
                                                        <span class="text-success"> free </span>
                                                    @else
                                                        <span class="text-danger"> payed </span>
                                                    @endif

                                                </div>
                                                <div class="col-auto">
                                                    <button class="btn btn-outline-indigo"  onclick="edit('{{ $content->id }}')">edit</button>
                                                    <button class="btn btn-red" onclick="deleteRecord('{{ route('admin.course_contents.destroy', ['course_content' => $content->id]) }}')">delete</button>
                                                </div>
                                            </div>
                                        </div>
                                 @else
                                        <div class="list-group-item">
                                            <div class="row">
                                                <div class="col-auto">
                                                    <a href="#">
                                                        <span class="avatar">
                                                            <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M8 8a3.5 3 0 0 1 3.5 -3h1a3.5 3 0 0 1 3.5 3a3 3 0 0 1 -2 3a3 4 0 0 0 -2 4" /><line x1="12" y1="19" x2="12" y2="19.01" /></svg>
                                                        </span>
                                                    </a>
                                                </div>
                                                <div class="col text-truncate">
                                                    <a href="{{route('admin.courses.quiz.show',['quizId'=>$content->contentable->id])}}" class="text-body d-block">
                                                        <span class="text-blue"><i class='bx bx-link'></i>
                                                        {{$content->contentable->title}}</span>
                                                    </a>
                                                    @if($content->contentable->active)
                                                        <span class="text-success"> active </span>
                                                    @else
                                                        <span class="text-danger"> not active </span> -
                                                    @endif
                                                 </div>

                                                <div class="col-auto">
                                                    <button class="btn btn-outline-indigo"  onclick="editTest('{{ $content->id }}')">edit</button>
                                                    <button class="btn btn-red" onclick="deleteRecord('{{ route('admin.course_contents.destroy', ['course_content' => $content->id]) }}')">delete</button>
                                                </div>
                                            </div>
                                        </div>
                                 @endif

                                @endforeach

                        </div>

                    </div>

                </div>
            </div>
        </div>
    </div>

        {{--        modals--}}
        <div class="modal modal-blur fade" id="modal-large" tabindex="-1" role="dialog" aria-hidden="true">
            <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">إضافة درس جديد</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <form action="{{route('admin.course_contents.store')}}" method="post" enctype="multipart/form-data">
                        @csrf
                        <input type="hidden" hidden name="content_tp" value="lesson">
                        <input type="hidden" hidden name="course_id" value="{{$course->id}}">
                        <div class="modal-body scrollable-modal">
                            <div class="row mt-3">

                                <div class="col-12 ">

                                    <button type="button"  onclick="setDir('ltr')" class="btn btn-light ">
                                        <!-- Download SVG icon from http://tabler-icons.io/i/align-left -->
                                        <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><line x1="4" y1="6" x2="20" y2="6" /><line x1="4" y1="12" x2="14" y2="12" /><line x1="4" y1="18" x2="18" y2="18" /></svg>
                                    </button>
                                    <button type="button" onclick="setDir('rtl')" class="btn btn-light ">
                                        <!-- Download SVG icon from http://tabler-icons.io/i/align-right -->
                                        <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><line x1="4" y1="6" x2="20" y2="6" /><line x1="10" y1="12" x2="20" y2="12" /><line x1="6" y1="18" x2="20" y2="18" /></svg>
                                    </button>

                                </div>

                                <div class="col-lg-12 col-md-12 col-sm-12 mt-2">
                                    <div class="form-group">
                                        <label>العنوان</label>
                                        <input class="form-control @error('title') is-invalid @enderror direc" type="text" name="title" placeholder="اسم الدرس">
                                        @error('title') <small class="form-text text-danger">{{ $message }}</small> @enderror
                                    </div>
                                </div>
                                <div class="col-lg-12 col-md-12 col-sm-12 mt-2">
                                    <div class="form-group">
                                        <label>الوصف</label>
                                        <textarea class="form-control @error('description') is-invalid @enderror direc" name="description" placeholder="وصف الدرس"></textarea>
                                        @error('description') <small class="form-text text-danger">{{ $message }}</small> @enderror
                                    </div>
                                </div>


                                <div class="col-lg-6 col-md-6 col-sm-12 mt-2">
                                    <div class="form-group">
                                        <label>رابط الفيديو</label>
                                        <input class="form-control @error('price') is-invalid @enderror direc" type="text" name="link" placeholder="ادخل رابك الفيديو">
                                        @error('link') <small class="form-text text-danger">{{ $message }}</small> @enderror
                                    </div>
                                </div>



                                <div class="col-lg-6 col-md-6 col-sm-12 mt-2">
                                    <div class="form-group">
                                        <label>هل هو مجاني</label>
                                        <select class="form-select @error('is_free') is-invalid @enderror direc" name="is_free">
                                            <option value="0">لا</option>
                                            <option value="1">نعم</option>
                                        </select>
                                        @error('is_free') <small class="form-text text-danger">{{ $message }}</small> @enderror
                                    </div>
                                </div>

                                <div class="col-lg-6 col-md-6 col-sm-12 mt-2">
                                    <div class="form-group">
                                        <label>هل هو نشط</label>
                                        <select class="form-select @error('active') is-invalid @enderror direc" name="active">
                                            <option value="0">لا</option>
                                            <option value="1">نعم</option>
                                        </select>
                                        @error('active') <small class="form-text text-danger">{{ $message }}</small> @enderror
                                    </div>
                                </div>

                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn me-auto" data-bs-dismiss="modal">إلغاء</button>
                            <button type="submit" class="btn btn-primary">
                                إضافة الدرس
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        {{--        modals--}}
        <div class="modal modal-blur fade" id="modal-large-quiz" tabindex="-1" role="dialog" aria-hidden="true">
            <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">إضافة كويز جديد</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <form action="{{route('admin.course_contents.store')}}" method="post" enctype="multipart/form-data">
                        @csrf
                        <input type="hidden" hidden name="content_tp" value="course_test">
                        <input type="hidden" hidden name="course_id" value="{{$course->id}}">
                        <div class="modal-body scrollable-modal">
                            <div class="row mt-3">

                                <div class="col-12 ">

                                    <button type="button"  onclick="setDir('ltr')" class="btn btn-light ">
                                        <!-- Download SVG icon from http://tabler-icons.io/i/align-left -->
                                        <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><line x1="4" y1="6" x2="20" y2="6" /><line x1="4" y1="12" x2="14" y2="12" /><line x1="4" y1="18" x2="18" y2="18" /></svg>
                                    </button>
                                    <button type="button" onclick="setDir('rtl')" class="btn btn-light ">
                                        <!-- Download SVG icon from http://tabler-icons.io/i/align-right -->
                                        <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><line x1="4" y1="6" x2="20" y2="6" /><line x1="10" y1="12" x2="20" y2="12" /><line x1="6" y1="18" x2="20" y2="18" /></svg>
                                    </button>

                                </div>

                                <div class="col-lg-12 col-md-12 col-sm-12 mt-2">
                                    <div class="form-group">
                                        <label>اسم الكويز</label>
                                        <input class="form-control @error('title') is-invalid @enderror direc" type="text" name="title" placeholder="عنوان الكويز">
                                        @error('title') <small class="form-text text-danger">{{ $message }}</small> @enderror
                                    </div>
                                </div>


                                <div class="col-lg-6 col-md-6 col-sm-12 mt-2">
                                    <div class="form-group">
                                        <label>هل هو نشط</label>
                                        <select class="form-select @error('active') is-invalid @enderror direc" name="active">
                                            <option value="0">لا</option>
                                            <option value="1">نعم</option>
                                        </select>
                                        @error('active') <small class="form-text text-danger">{{ $message }}</small> @enderror
                                    </div>
                                </div>

                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn me-auto" data-bs-dismiss="modal">Close</button>
                            <button type="submit" class="btn btn-primary">
                                إضافة الكويز
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        {{--        edit modal--}}

        <div class="modal modal-blur fade" id="edit-modal" tabindex="-1" role="dialog" aria-hidden="true">
            <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
                <div class="modal-content" id="edit-modal-content">

                </div>
            </div>
        </div>

        @include('components.remove-modal')
        @endsection

        @push('scripts')
            <script>

                const dropdowns = document.querySelectorAll('.dropdown-toggle')
                const dropdown = [...dropdowns].map((dropdownToggleEl) => new bootstrap.Dropdown(dropdownToggleEl, {
                    popperConfig(defaultBsPopperConfig) {
                        return { ...defaultBsPopperConfig, strategy: 'fixed' };
                    }
                }));

                let loader = `@include('components.loader')`;

                function edit(id) {
                    $("#edit-modal-content").html(loader);
                    $('#edit-modal').modal('show');
                    $("#edit-modal-content").load(`admin/lessons/${id}/edit`);
                }

                function editTest(id) {
                    $("#edit-modal-content").html(loader);
                    $('#edit-modal').modal('show');
                    $("#edit-modal-content").load(`admin/course_tests/${id}/edit`);
                }



                function setDir(dir) {
                    // Use querySelectorAll for more modern and efficient element selection
                    const elements = document.querySelectorAll('.direc');

                    if (elements.length === 0) {
                        console.warn("No elements found with class 'direc'.");
                        return; // Exit the function if no elements are found
                    }

                    if (dir.toLowerCase() === 'rtl') {
                        elements.forEach(element => element.setAttribute('dir', 'rtl'));
                    } else if (dir.toLowerCase() === 'ltr') {
                        elements.forEach(element => element.setAttribute('dir', 'ltr'));
                    } else {
                        console.warn("Invalid direction specified. Please use 'rtl' or 'ltr'.");
                    }
                }
            </script>
            <script>
                function deleteRecord(action) {
                    console.log(action);
                    $("#remove-form").attr('action', action);
                    $("#modal-danger").modal('show');
                }

            </script>
    @endpush
