@extends('layouts.tabler-vertical')
@section('title','Admin Settings')

@section('header-top')

    @include('layouts.inc.top-large-bar')
    <div class="page-wrapper ">
        <div class="wrapper">
            <!-- Page title -->
            <div class="page-header d-print-none">
                <div class="row align-items-center">
                    <div class="col">
                        <!-- Page pre-title -->

                        <h2 class="page-title">
                            {{ __('admin.coupon_codes') }}
                        </h2>
                    </div>
                    <!-- Page title actions -->
                    <div class="col-auto ms-auto d-print-none">


                        <div class="btn-list">

                            <a href="#" class="btn btn-indigo d-none d-sm-inline-block" data-bs-toggle="modal"
                               data-bs-target="#modal-large">
                                <!-- Download SVG icon from http://tabler-icons.io/i/plus -->
                                <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24"
                                     viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none"
                                     stroke-linecap="round" stroke-linejoin="round">
                                    <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
                                    <line x1="12" y1="5" x2="12" y2="19"/>
                                    <line x1="5" y1="12" x2="19" y2="12"/>
                                </svg>
                                {{ __('admin.add_new_coupon') }}
                            </a>
                            <a href="#" class="btn btn-indigo d-sm-none btn-icon" data-bs-toggle="modal"
                               data-bs-target="#modal-large" aria-label="Create new report">
                                <!-- Download SVG icon from http://tabler-icons.io/i/plus -->
                                <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24"
                                     viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none"
                                     stroke-linecap="round" stroke-linejoin="round">
                                    <path stroke="none" d="M0 0h24v24H0z" fill="none"/>
                                    <line x1="12" y1="5" x2="12" y2="19"/>
                                    <line x1="5" y1="12" x2="19" y2="12"/>
                                </svg>
                            </a>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('content')
    <div class="wrapper ">
        <div class="row">
            <div class="col-lg-12 col-md-12 col-sm-12">

                <div class="card">
                    <div class="card-body-s">

                        <div class="table-responsive">
                            <table class="table table-striped">
                                <thead>
                                <tr>
                                    <th>{{ __('admin.id') }}</th>
                                    <th>{{ __('admin.course') }}</th>
                                    <th>{{ __('admin.workshop') }}</th>
                                    <th>{{ __('admin.discount') }} (%)</th>
                                    <th>{{ __('admin.apply_count') }}</th>
                                    <th>{{ __('admin.allowed_apply_count') }}</th>
                                    <th>{{ __('admin.coupon_code') }}</th>
                                    <th>{{ __('admin.actions') }}</th>
                                </tr>
                                </thead>
                                <tbody>
                                @foreach($couponCodes as $coupon)
                                    <tr>
                                        <td>{{ $coupon->id }}</td>
                                        <td>{{ $coupon->course ? $coupon->course->name : ' ' }}</td>
                                        <td>{{ $coupon->workshop ? $coupon->workshop->name : ' ' }}</td>
                                        <td>{{ $coupon->discount }}%</td>
                                        <td>{{ $coupon->apply_count }}</td>
                                        <td>{{ $coupon->allowed_apply_count }}</td>
                                        <td>{{ $coupon->coupon }}</td>
                                        <td>
                                            <div class="dropdown">
                                                <button class="btn dropdown-toggle align-text-top" data-bs-toggle="dropdown" aria-expanded="false">
                                                    {{ __('admin.actions') }}
                                                </button>
                                                <div class="dropdown-menu dropdown-menu-end">
                                            <button type="button" class="dropdown-item" onclick="edit('{{$coupon->id}}')"> {{ __('admin.edit') }}</button>
                                            <button type="button" onclick="deleteRecord('{{route("admin.coupon_codes.destroy",["coupon_code"=>$coupon->id])}}')" class="dropdown-item">{{ __('admin.delete') }}</button>
                                                </div>
                                            </div>

                                        </td>
                                    </tr>
                                @endforeach
                                </tbody>
                            </table>

                        </div>
                        {{--                        <div class="row">--}}
                        {{--                            <div class="pagination">--}}
                        {{--                                {!! $lots->links('pagination::bootstrap-4') !!}--}}
                        {{--                            </div>--}}
                        {{--                        </div>--}}
                    </div>

                </div>
            </div>
        </div>

        {{--        modals--}}
        <div class="modal modal-blur fade" id="modal-large" tabindex="-1" role="dialog" aria-hidden="true">
            <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">{{ __('admin.create_new_coupon') }}</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <form action="{{route('admin.coupon_codes.store')}}" method="post" enctype="multipart/form-data">
                        @csrf

                        @if(isset($course))
                            <input name="course_id" value="{{$course->id}}" hidden>
                        @endif
                        @if(isset($workshop))
                            <input name="workshop_id" value="{{$workshop->id}}" hidden>
                        @endif

                        <div class="modal-body scrollable-modal">

                            <div class="row mt-3">


                                <div class="col-lg-12 col-md-12 col-sm-12 mt-2">
                                    <div class="form-group">
                                        <label>{{ __('admin.discount') }} (%)</label>
                                        <input class="form-control @error('discount') is-invalid @enderror" type="number" name="discount" placeholder="{{ __('admin.discount') }} (%)" value="{{ isset($coupon) ? $coupon->discount : old('discount') }}">
                                        @error('discount') <small class="form-text text-danger">{{ $message }}</small> @enderror
                                    </div>
                                </div>

                                <div class="col-lg-12 col-md-12 col-sm-12 mt-2">
                                    <div class="form-group">
                                        <label>{{ __('admin.allowed_apply_count') }}</label>
                                        <input class="form-control @error('allowed_apply_count') is-invalid @enderror" type="number" name="allowed_apply_count" placeholder="{{ __('admin.allowed_apply_count') }}" value="{{ isset($coupon) ? $coupon->allowed_apply_count : old('allowed_apply_count') }}">
                                        @error('allowed_apply_count') <small class="form-text text-danger">{{ $message }}</small> @enderror
                                    </div>
                                </div>

                                <div class="col-lg-12 col-md-12 col-sm-12 mt-2">
                                    <div class="form-group">
                                        <label>{{ __('admin.coupon_code') }}</label>
                                        <input class="form-control @error('coupon') is-invalid @enderror" type="text" name="coupon" placeholder="{{ __('admin.coupon_code') }}" value="{{ isset($coupon) ? $coupon->coupon : old('coupon') }}">
                                        @error('coupon') <small class="form-text text-danger">{{ $message }}</small> @enderror
                                    </div>
                                </div>


                            </div>


                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn me-auto" data-bs-dismiss="modal">Close</button>
                            <button type="submit" class="btn btn-primary">
                                {{ __('admin.create_coupon') }}
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        {{--        edit modal--}}

        <div class="modal modal-blur fade" id="edit-modal" tabindex="-1" role="dialog" aria-hidden="true">
            <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
                <div class="modal-content" id="edit-modal-content">

                </div>
            </div>
        </div>

        @include('components.remove-modal')
        @endsection

        @push('scripts')
            <script>

                const dropdowns = document.querySelectorAll('.dropdown-toggle')
                const dropdown = [...dropdowns].map((dropdownToggleEl) => new bootstrap.Dropdown(dropdownToggleEl, {
                    popperConfig(defaultBsPopperConfig) {
                        return { ...defaultBsPopperConfig, strategy: 'fixed' };
                    }
                }));

                let loader = `@include('components.loader')`;

                function edit(id) {
                    $("#edit-modal-content").html(loader);
                    $('#edit-modal').modal('show');
                    $("#edit-modal-content").load(`admin/coupon_codes/${id}/edit`);
                }


                function setDir(dir) {
                    // Use querySelectorAll for more modern and efficient element selection
                    const elements = document.querySelectorAll('.direc');

                    if (elements.length === 0) {
                        console.warn("No elements found with class 'direc'.");
                        return; // Exit the function if no elements are found
                    }

                    if (dir.toLowerCase() === 'rtl') {
                        elements.forEach(element => element.setAttribute('dir', 'rtl'));
                    } else if (dir.toLowerCase() === 'ltr') {
                        elements.forEach(element => element.setAttribute('dir', 'ltr'));
                    } else {
                        console.warn("Invalid direction specified. Please use 'rtl' or 'ltr'.");
                    }
                }
            </script>
            <script>
                function deleteRecord(action) {
                    console.log(action)
                    $("#remove-form").attr('action', action);
                    $("#modal-danger").modal('show');
                }

            </script>
    @endpush
