@extends('layouts.tabler-vertical')
@section('title','Admin Settings')

@section('header-top')

    @include('layouts.inc.top-large-bar')
    <div class="page-wrapper ">
        <div class="wrapper">
            <!-- Page title -->
            <div class="page-header d-print-none">
                <div class="row align-items-center">
                    <div class="col">
                        <!-- Page pre-title -->

                        <h2 class="page-title">
                           الشهادات
                        </h2>
                    </div>
                    <!-- Page title actions -->
                    <div class="col-auto ms-auto d-print-none">




                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('content')
    <div class="wrapper ">
        <div class="row">
            <div class="col-lg-12 col-md-12 col-sm-12">

                <div class="card">
                    <div class="card-body-s">

                        <div class="table-responsive">
                            <table class="table table-striped">

                                <tbody>
                                @foreach($certificates as $certificate)

                                    <tr>
                                        <td class="text-muted"> {{ $certificate->id }} </td>
                                        <td class="text-muted h3"> {{$certificate->user->name}}</td>
                                        <td class="text-muted">




                                            <a href="{{route('certificate.show',['certificate'=>$certificate->id])}}" target="_blank" class="btn btn-indigo" aria-label="RSS" >
                                               تحميل 
                                            </a>

                                        </td>
                                        @if($certificate->course_id)

                                            <td class="text-muted"> كورس : {{$certificate->course->name}} </td>
                                         @else

                                            <td class="text-muted"> ورشة : {{$certificate->workshop->name}} </td>

                                        @endif

                                        <td class="text-muted">{{ $certificate->number }} </td>
                                        <td class="text-muted">{{ $certificate->created_at }} </td>
                                        <td class="text-muted">{{ $certificate->updated_at->diffForHumans() }} </td>
                                        <td>

                                            <button onclick="deleteRecord('{{route("admin.certificates.destroy",['certificate'=>$certificate->id])}}')" class="btn btn-red">
                                                <i class='bx bxs-trash-alt'></i>  &nbsp; delete
                                            </button>

                                        </td>
                                    </tr>
                                @endforeach
                                </tbody>
                            </table>

                        </div>
                                                <div class="row">
                                                    <div class="pagination">
                                                        {!! $certificates->links('pagination::bootstrap-4') !!}
                                                    </div>
                                                </div>
                    </div>

                </div>
            </div>
        </div>

        {{--        modals--}}

        {{--        edit modal--}}



        @include('components.remove-modal')
        @endsection

        @push('scripts')
            <script>

                const dropdowns = document.querySelectorAll('.dropdown-toggle')
                const dropdown = [...dropdowns].map((dropdownToggleEl) => new bootstrap.Dropdown(dropdownToggleEl, {
                    popperConfig(defaultBsPopperConfig) {
                        return { ...defaultBsPopperConfig, strategy: 'fixed' };
                    }
                }));

                let loader = `@include('components.loader')`;




                function setDir(dir) {
                    // Use querySelectorAll for more modern and efficient element selection
                    const elements = document.querySelectorAll('.direc');

                    if (elements.length === 0) {
                        console.warn("No elements found with class 'direc'.");
                        return; // Exit the function if no elements are found
                    }

                    if (dir.toLowerCase() === 'rtl') {
                        elements.forEach(element => element.setAttribute('dir', 'rtl'));
                    } else if (dir.toLowerCase() === 'ltr') {
                        elements.forEach(element => element.setAttribute('dir', 'ltr'));
                    } else {
                        console.warn("Invalid direction specified. Please use 'rtl' or 'ltr'.");
                    }
                }

                function deleteRecord(action) {

                    $("#remove-form").attr('action', action);
                    $("#modal-danger").modal('show');
                }

            </script>
@endpush
