<?php

namespace App\Policies;

use App\Models\Role;
use App\Models\User;
use Illuminate\Auth\Access\HandlesAuthorization;

class RolePolicy
{
    use HandlesAuthorization;


    public function viewAny(User $user)
    {
        //
    }
    public function read(User $user)
    {
        return $user->hasPermission('read role');
    }


    public function view(User $user, Role $role)
    {
        //
    }


    public function create(User $user)
    {
        return $user->hasPermission('create role');
    }


    public function update(User $user )
    {
        return $user->hasPermission('update role');
    }


    public function delete(User $user )
    {
        return $user->hasPermission('delete role');
    }

    public function restore(User $user, Role $role)
    {
        //
    }


    public function forceDelete(User $user, Role $role)
    {
        //
    }
}
