<?php

namespace App\Policies;

use App\Models\Question;
use App\Models\User;
use Illuminate\Auth\Access\HandlesAuthorization;

class QuestionPolicy
{
    use HandlesAuthorization;


    public function viewAny(User $user)
    {

    }


    public function view(User $user, Question $question)
    {

    }

    public function create(User $user)
    {
       return $user->hasPermission('create question');
    }


    public function update(User $user, Question $question)
    {
        return $user->user_id == $question->customer->user_id || $user->role->name=="manager";
    }


    public function delete(User $user, Question $question)
    {
        return $user->user_id == $question->customer->user_id || $user->role->name=="manager";
    }


    public function restore(User $user, Question $question)
    {

    }


    public function forceDelete(User $user, Question $question)
    {

    }
}
