<?php

namespace App\Policies;

use App\Models\Language;
use App\Models\User;
use Illuminate\Auth\Access\HandlesAuthorization;

class LanguagePolicy
{
    use HandlesAuthorization;


    public function viewAny(User $user)
    {

    }


    public function view(User $user, Language $language)
    {

    }


    public function create(User $user)
    {
        return $user->hasPermission('create languages');
    }


    public function update(User $user, Language $language)
    {
        return $user->user_id == $language->customer->user_id || $user->role->name=="manager";
    }


    public function delete(User $user, Language $language)
    {
        return $user->user_id == $language->customer->user_id || $user->role->name=="manager";
    }

    public function restore(User $user, Language $language)
    {

    }


    public function forceDelete(User $user, Language $language)
    {

    }
}
