<?php

namespace App\Http\Controllers\api\v1;

use App\Http\Controllers\Controller;
use App\Http\Helpers\ImageHelper;
use App\Models\User;
use App\Services\OtpService;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Arr;
use App\Http\Helpers\SettingHelper;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Crypt;

class AuthController extends Controller
{

    protected $otpService;

    public function __construct(OtpService $otpService)
    {
        $this->otpService = $otpService;
    }

    public function splash(Request $request)
    {

        $whats_app = SettingHelper::getSetting('whatsapp contact');
        $mail = SettingHelper::getSetting('email contact');
        return response([
            'whats_app' => $whats_app,
            'mail' => $mail,
            'user' => auth('api')->user()
        ]);


    }


    public function changeImage(Request $request)
    {
        $request->validate([
            'image' => 'required|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
        ]);

        $image = ImageHelper::storeImage('profiles/', $request->image);

        if ($image) {
            $user = auth('api')->user();
            $user->image = $image;
            $user->save();
            return response()->json([
                'message' => 'Image uploaded successfully',
                'path' => $image
            ]);
        }

        return response()->json([
            'message' => 'invalid image',
        ], 403);
    }

    // public function sendOtp($otp, $number, $type = "whatsapp")
    // {

    //     $user = User::where('phone', $number)->first();


    //     if (strlen($number) > 10) {
    //         $number = substr($number, -10);
    //     }

    //     if ($number == "07507955607") {
    //         $otp = "111000";
    //     }


    //     $user->activation_code = $otp;
    //     $user->code_expired = Carbon::now()->addMinutes(5);
    //     $user->is_active = 0;
    //     $user->save();

    //     // Step 4: Prepare the message (OTP)
    //     $message = "شكراً لاستخدامك تطبيق المحكمة الافتراضية";
    //     $message .= " ";
    //     $message .= "رمز التحقق الخاص بك هو";
    //     $message .= ' : ';
    //     $message .= $otp;

    //     $reception = '+964' . $number;
    //     if ($type == "whatsapp") {
    //         $this->otpService->sendWhatsAppMessage($reception, $message);
    //     } else {
    //         $this->otpService->sendSmsOTP($reception, $message);
    //     }

    // }




    // Ready

    public function sendOtp($number, $type = "whatsapp")
    {

        // if (strlen($number) > 10) {
        //     $number = substr($number, -10);
        // }

        if ($number == '07507955607') {
            $otp = '111000';
        } else {
            $otp = rand(100000, 999999);
        }

        // Store OTP and phone number in cache for 5 minutes
        $cache_key = 'phone_otp_' . $number;
        Cache::put($cache_key, Crypt::encrypt($otp), 60 * 5);

        $message = "شكراً لاستخدامك تطبيق المحكمة الافتراضية";
        $message .= " ";
        $message .= "رمز التحقق الخاص بك هو";
        $message .= ' : ';
        $message .= $otp;


        // if ($number != '07507955607') {
        $reception = '+964' . $number;
        if ($type == "whatsapp") {
            $this->otpService->sendWhatsAppMessage($reception, $message);
        } else {
            $this->otpService->sendSmsOTP($reception, $message);
        }
        // }

    }


    // Ready
    public function checkAndSendOtp(Request $request)
    {

        $validator = validator()->make($request->all(), [
            'phone' => 'required|string|max:15|min:10',
            'type' => 'required|string|in:sms,whatsapp',
        ]);

        if ($validator->fails()) {
            return response()->json(['message' => $validator->errors()->first()], 403);
        }

        $exist = User::where('phone', $request->phone)->count();

        // if ($exist == 0) {
        //     return response()->json(['message' => 'invalid phone number.'], 403);
        // }

        // $otp = rand(100000, 999999);
        if ($request->type == "whatsapp") {
            $this->sendOtp($request->get('phone'));
        } else {
            $this->sendOtp($request->get('phone'), "sms");
        }
        return response()->json(['exist' => $exist, 'message' => 'code sent'], 200);
    }



    // Verify and Login|Register
    public function verifyUserPhone(Request $request)
    {
        $validator = validator()->make($request->all(), [
            'activation_code' => 'required|string|max:25',
            'phone' => 'required|string|max:15|min:10',
            'name' => 'nullable|string|max:25',
        ]);

        if ($validator->fails()) {
            return response()->json(['message' => $validator->errors()->first()], 403);
        }

        $phone_number = $request->phone;
        $otp = $request->activation_code;

        // Retrieve the encrypted OTP from the cache
        $cache_key = 'phone_otp_' . $phone_number;
        $encrypted_otp = Cache::get($cache_key);


        if ($encrypted_otp && Crypt::decrypt($encrypted_otp) == $otp) {

            // Check if User Exists
            $user = User::where('phone', $phone_number)->first();
            if ($user) {

                $user->activation_code = null;
                $user->code_expired = null;
                $user->is_active = 1;
                $user->verified_at = Carbon::now();
                $user->save();

                $credentials = ['phone' => $request->get('phone'), 'password' => 'yomaquaewaebaebethatyakareboyamakatsheway'];
                Arr::add($credentials, 'block', '0');
                if (!$token = auth('api')->attempt($credentials)) {
                    return response()->json(['message' => 'the phone or password is wrong.'], 403);
                }
                return $this->createNewToken($token);

            } else {

                if (!$request->name) {
                    return response()->json(['message' => 'You must enter your Name'], 403);
                }

                $user = new User();
                $user->phone = $request->phone;
                $user->name = $request->name;
                $user->password = bcrypt("yomaquaewaebaebethatyakareboyamakatsheway");
                $user->role_id = 1;
                $user->save();

                if (!$user) {
                    return response()->json(['message' => 'we cant create this account'], 403);
                }

                $credentials = ['phone' => $request->get('phone'), 'password' => 'yomaquaewaebaebethatyakareboyamakatsheway'];
                Arr::add($credentials, 'block', '0');
                if (!$token = auth('api')->attempt($credentials)) {
                    return response()->json(['message' => 'the phone or password is wrong.'], 403);
                }
                return $this->createNewToken($token);

                // return response()->json(['message' => 'account created successfully'], 200);
            }



            // $data['customer'] = $customer;
            // // $data['profile'] = $customer->profile;

            // $status_code = 200;
            // // Prepare token
            // auth('customer')->login($data['customer']);
            // $auth_token = JWTAuth::fromUser($customer);
            // $data['auth_token'] = $auth_token;

        } else {
            return response()->json(['message' => 'invalid activation code.'], 403);
        }

    }

    public function verifyUserPhone_old(Request $request)
    {
        $validator = validator()->make($request->all(), [
            'activation_code' => 'required|string|max:25',
            'phone' => 'required|string|max:15|min:10',
            'name' => 'nullable|string|max:25',
        ]);

        if ($validator->fails()) {
            return response()->json(['message' => $validator->errors()->first()], 403);
        }

        $user = User::where('phone', $request->phone)->where('activation_code', $request->activation_code)->first();

        if (!$user) {
            return response()->json(['message' => 'invalid credential'], 403);
        }

        if (
            $user->activation_code === $request->activation_code &&
            Carbon::now()->lessThanOrEqualTo(Carbon::parse($user->code_expired))
        ) {
            $user->activation_code = null;
            $user->code_expired = null;
            $user->is_active = 1;
            $user->verified_at = Carbon::now();
            $user->save();



            $credentials = ['phone' => $request->get('phone'), 'password' => 'yomaquaewaebaebethatyakareboyamakatsheway'];
            Arr::add($credentials, 'block', '0');
            if (!$token = auth('api')->attempt($credentials)) {
                return response()->json(['message' => 'the phone or password is wrong.'], 403);
            }
            return $this->createNewToken($token);


        }
        return response()->json(['message' => 'invalid activation code.'], 403);
    }


    public function Register(Request $request)
    {
        $validator = validator()->make($request->all(), [
            'name' => 'required|string|max:25',
            'phone' => 'required|numeric|digits_between:10,12|unique:users',
        ]);

        if ($validator->fails()) {
            return response()->json(['message' => $validator->errors()->first()], 403);
        }

        if (!is_numeric($request->phone)) {
            return response()->json(['message' => 'please provide your phone'], 403);
        }

        $user = new User();
        $user->phone = $request->phone;
        $user->name = $request->name;
        $user->password = bcrypt("yomaquaewaebaebethatyakareboyamakatsheway");
        $user->role_id = 1;
        $user->save();

        if (!$user) {
            return response()->json(['message' => 'we cant create this account'], 403);
        }

        return response()->json(['message' => 'account created successfully'], 200);

    }

    public function changePassword(Request $request)
    {
        $validator = validator()->make($request->all(), [
            'password' => 'required|string|max:25|min:6',
        ]);

        if ($validator->fails()) {
            return response()->json(['message' => $validator->errors()->first()], 403);
        }
        $password = $request->password;

        $user = auth('api')->user();
        $user->password = bcrypt($password);
        $user->save();

        return response()->json(['message' => 'password changed successfully']);

    }


    public function Login(Request $request)
    {
        $validator = validator()->make($request->all(), [
            'phone' => 'required|string',
            'password' => 'required|string|min:6',
        ]);

        if ($validator->fails()) {
            return response()->json(['message' => $validator->errors()->first()], 403);
        }


        $credentials = ['phone' => $request->get('phone'), 'password' => $request->get('password')];
        Arr::add($credentials, 'block', '0');
        if (!$token = auth('api')->attempt($credentials)) {
            return response()->json(['message' => 'the phone or password is wrong.'], 403);
        }
        return $this->createNewToken($token);
    }

    protected function createNewToken($token)
    {

        $user = auth('api')->user();
        return response()->json([
            'access_token' => $token,
            'token_type' => 'bearer',
            'expires_in' => auth('api')->factory()->getTTL() * 60,
            'user' => $user
        ], 200);
    }

}
