<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Helpers\ImageHelper;
use Illuminate\Http\Request;
use RealRashid\SweetAlert\Facades\Alert;
use App\Models\QuestionAnswer;


class QuestionAnswerController extends Controller
{

    public function index()
    {
       $questions = QuestionAnswer::orderBy('id','desc')->get();
       return view('admin.questions.index')->with('questions',$questions);
    }


    public function create()
    {

    }


    public function store(Request $request)
    {

        $validator = validator()->make($request->all(), [
            'question' => 'required|string',
            'answer' => 'required|string',

        ]);

        if ($validator->fails()) {
            Alert::toast($validator->errors()->first(), 'error');
            return redirect()->back();
        }


        $question = new QuestionAnswer();
        $question->question = $request->question;
        $question->answer = $request->answer;
        $question->save();

        Alert::toast('Question created successfully', 'success');
        return redirect()->route('admin.question-answers.index');

    }


    public function show(QuestionAnswer $questionAnswer)
    {

    }


    public function edit(QuestionAnswer $questionAnswer)
    {
        return view('admin.questions.edit')->with('question',$questionAnswer);
    }


    public function update(Request $request, QuestionAnswer $questionAnswer)
    {
        $validator = validator()->make($request->all(), [
            'question' => 'required|string',
            'answer' => 'required|string',

        ]);

        if ($validator->fails()) {
            Alert::toast($validator->errors()->first(), 'error');
            return redirect()->back();
        }



        $questionAnswer->question = $request->question;
        $questionAnswer->answer = $request->answer;
        $questionAnswer->save();

        Alert::toast('Question Updated successfully', 'success');
        return redirect()->route('admin.question-answers.index');
    }


    public function destroy(QuestionAnswer $questionAnswer)
    {
        $questionAnswer->delete();
        Alert::toast('Question Deleted Successfully', 'success');
        return redirect()->route('admin.question-answers.index');
    }
}
