<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\CourseContent;
use App\Models\Lesson;
use Illuminate\Http\Request;
use RealRashid\SweetAlert\Facades\Alert;

class LessonController extends Controller
{

    public function index()
    {

    }

    public function create()
    {

    }


    public function store(Request $request)
    {

    }


    public function show(Lesson $lesson)
    {

    }


    public function edit(Lesson $lesson)
    {
        return view('admin.courses.content.edit_lesson')->with('lesson',$lesson);
    }


    public function update(Request $request, Lesson $lesson)
    {
        $validator = validator()->make($request->all(), [
            'title' => 'required|string',
            'description' => 'required|string',
            'link' => 'required|string',
            'active' => 'required|boolean',
            'is_free' => 'required|boolean',
        ]);

        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator);
        }


        $lesson->title = $request->title;
        $lesson->description = $request->description;
        $lesson->url = $request->link;
        $lesson->active = $request->active;
        $lesson->is_free = $request->is_free;
        $lesson->save();



        Alert::toast('Lesson Updated','success');
        return redirect()->back();
    }


    public function destroy(Lesson $lesson)
    {

    }
}
