<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\JoinReq;
use App\Models\Notification;
use App\Models\Student;
use App\Models\User;
use App\Services\FCMService;
use Illuminate\Http\Request;
use RealRashid\SweetAlert\Facades\Alert;

class JoinReqController extends Controller
{

    public function index()
    {
        $joinreqs = JoinReq::with(['user:id,name,image','course','workshop'])->orderBy('id','DESC')->paginate(15);
        return view('admin.courses.joins')->with('joinreqs',$joinreqs);
    }


    public function create()
    {
        //
    }


    public function store(Request $request)
    {
        //
    }


    public function show(JoinReq $joinReq)
    {
        if($joinReq->type == "course"){
            $student = new Student();
            $student->user_id = $joinReq->user_id;
            $student->course_id = $joinReq->course_id;
            $student->code = "coupon : ". $joinReq->coupon_code;
            $student->save();

            $message = "تم قبولك في كورس"." ".$joinReq->course->name;
        }else{
            $student = new Student();
            $student->user_id = $joinReq->user_id;
            $student->workshop_id = $joinReq->workshop_id;
            $student->code = "coupon : ". $joinReq->coupon_code;
            $student->save();

            $message = "تم قبولك في ورشة"." ".$joinReq->workshop->name;
        }

        $user = User::findOrFail($joinReq->user_id);

        $uid = $user->id;

        $notification = Notification::create([
            'type' => 'user_'.$uid,
            'title' =>  "المحكمة الافتراضية",
            'description' => $message,
             'user_id' => $uid,
        ]);
        $user->notifications()->attach($notification->id);

        $joinReq->delete();
        Alert::toast('Join Request accepted successfully', 'success');

        FCMService::sendNotification('user_'.$uid,"المحكمة الافتراضية",$message );

        return redirect()->back();
    }


    public function edit(JoinReq $joinReq)
    {
        //
    }


    public function update(Request $request, JoinReq $joinReq)
    {

    }


    public function destroy(JoinReq $joinReq)
    {
        $joinReq->delete();
        Alert::toast('Join Request deleted successfully', 'success');
        return redirect()->back();
    }
}
