<?php

namespace App\Http\Controllers\Admin;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Http;


class FileManagerController extends Controller
{

     public function index()
    {
        return view('filemanager.static');
    }

    public function indexedFolder($folder)
    {
        $directories = Storage::disk('s3')->allDirectories($folder);
        return view('filemanager.index', compact('directories','folder'));
    }

    public function listFiles($folder)
    {

        $files = Storage::disk('s3')->allFiles($folder);
        // $folder = $folder;
        return view('filemanager.course_files', compact('files','folder'));
    }




    public function createFolder(Request $request)
    {
        $folderName = $request->input('folder_name');
        $dir = $request->dir;
        $path =$dir.'/' . $folderName . '/';

        // Check if the folder already exists
        if (Storage::disk('s3')->exists($path)) {
            return back()->with('error', 'الملف موجود مسبقاً');
        }

        // Create a new directory
        Storage::disk('s3')->makeDirectory($path);

        return back()->with('success', 'تم إنشاء المجلد بنجاح');
    }


    // Delete a folder
    public function deleteFolder($folder)
    {
        $folder = urldecode($folder);  // Decode the folder path

        // Get all files and subdirectories in the folder and delete them
        $files = Storage::disk('s3')->allFiles($folder);
        $directories = Storage::disk('s3')->allDirectories($folder);

        // Delete files first
        foreach ($files as $file) {
            Storage::disk('s3')->delete($file);
        }

        // Delete subdirectories
        foreach ($directories as $directory) {
            Storage::disk('s3')->deleteDirectory($directory);
        }

        // Finally, delete the folder itself
        Storage::disk('s3')->deleteDirectory($folder);

        return back()->with('success', 'تم حذف الملف بنجاح');
    }

    public function upload(Request $request)
    {
        $request->validate([
            'dir' => 'required|string',
            'file' => 'nullable|file',        // File upload from device
            'file_url' => 'nullable|url'     // File upload from a direct URL
        ]);

        $dir = $request->dir;

        try {
            if ($request->hasFile('file')) {
                // Handle file upload from the device
                $file = $request->file('file');
                $path = $dir . '/' . $file->getClientOriginalName();
                Storage::disk('s3')->put($path, fopen($file, 'r+'));

                return back()->with('success', 'File uploaded successfully from device.');
            } elseif ($request->filled('file_url')) {
            // Download file from URL
            $fileUrl = $request->file_url;
            $response = Http::get($fileUrl);

            if ($response->successful()) {
                $fileContent = $response->body();

                // Extract file name from URL
                $fileName = basename(parse_url($fileUrl, PHP_URL_PATH));
                $path = $dir . '/' . $fileName;

                Storage::disk('s3')->put($path, $fileContent);

                return back()->with('success', 'File uploaded successfully from URL.');
            } else {
                return back()->withErrors('Failed to retrieve file from URL.');
            }
        }
            return back()->with('error', 'No file selected.');
        } catch (\Exception $e) {
            return back()->withErrors('Failed to upload file: ' . $e->getMessage());
        }
    }


    public function delete($file)
    {
        Storage::disk('s3')->delete($file);
        return back()->with('success', 'تم حذف الملف بنجاح');
    }


    public function rename(Request $request, $file)
    {
        $newName = $request->input('new_name');
        Storage::disk('s3')->move($file, 'Virtual Court/' . $newName);
        return back()->with('success', 'File renamed successfully');
    }

    public function download($file)
    {
        return Storage::disk('s3')->download($file);
    }
}
