<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\CourseContent;
use App\Models\CourseTest;
use App\Models\Lesson;
use Illuminate\Http\Request;
use RealRashid\SweetAlert\Facades\Alert;

class CourseContentController extends Controller
{


    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }
    public function storeLesson(Request $request){
        $validator = validator()->make($request->all(), [
            'title' => 'required|string',
            'description' => 'required|string',
            'link' => 'required|string',
            'active' => 'required|boolean',
            'is_free' => 'required|boolean',
        ]);

        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator);
        }


        // Create Lesson
        $lesson = new Lesson();
        $lesson->title = $request->title;
        $lesson->description = $request->description;
        $lesson->url = $request->link;
        $lesson->active = $request->active;
        $lesson->is_free = $request->is_free;
        $lesson->save();

        // Create CourseContent entry and associate with Lesson
        $courseContent = new CourseContent();
        $courseContent->course_id = $request->course_id;
        $courseContent->contentable()->associate($lesson);
        $courseContent->save();

        Alert::toast('Lesson created','success');
        return redirect()->back();
    }
    public function storeQuiz(Request $request){
        $validator = validator()->make($request->all(), [
            'title' => 'required|string',
            'active' => 'required|boolean',
        ]);

        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator);
        }

        // Create CourseTest
        $test = new CourseTest();
        $test->title = $request->title;
        $test->active = $request->active;
        $test->save();

        // Create CourseContent entry and associate with CourseTest
        $courseContent = new CourseContent();
        $courseContent->course_id = $request->course_id;
        $courseContent->contentable()->associate($test);
        $courseContent->save();
        Alert::toast('Quiz created','success');
        return redirect()->back();
    }

    public function store(Request $request)
    {

        if($request->content_tp == "course_test"){
            return $this->storeQuiz($request);
        }else{
            return $this->storeLesson($request);
        }

    }


    public function show(CourseContent $courseContent)
    {

    }


    public function edit(CourseContent $courseContent)
    {

    }


    public function update(Request $request, CourseContent $courseContent)
    {

    }


    public function destroy(CourseContent $courseContent)
    {
        $courseContent->delete();
        Alert::toast('Course Content Deleted','success');
        return redirect()->back();
    }
}
