<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\CouponCode;
use Illuminate\Http\Request;
use RealRashid\SweetAlert\Facades\Alert;

class CouponCodeController extends Controller
{

    public function index()
    {

    }


    public function create()
    {

    }


    public function store(Request $request)
    {
        $validator = validator()->make($request->all(), [
            'course_id' => 'nullable|exists:courses,id',
            'workshop_id' => 'nullable|exists:workshops,id',
            'discount' => 'required|numeric|min:0',
            'allowed_apply_count' => 'required|integer|min:1',
            'coupon' => 'required|string',
        ]);

        if ($validator->fails()) {
            Alert::toast($validator->errors()->first(), 'error');
            return redirect()->back();
        }

        $couponCode = new CouponCode();
        $couponCode->course_id = $request->course_id;
        $couponCode->workshop_id = $request->workshop_id;
        $couponCode->discount = $request->discount;
        $couponCode->apply_count = 0;
        $couponCode->allowed_apply_count = $request->allowed_apply_count;
        $couponCode->coupon = strtoupper($request->coupon);
        $couponCode->save();


        if($couponCode->course_id != null){
            Alert::toast('Coupon code created successfully', 'success');
            return redirect()->route('admin.courses.show',$request->course_id);
        }else{
            Alert::toast('Coupon code created successfully', 'success');
            return redirect()->route('admin.workshops.show',$request->workshop_id);
        }

    }


    public function show(CouponCode $couponCode)
    {

    }


    public function edit(CouponCode $couponCode)
    {
        return view('admin.coupons.edit')->with('coupon',$couponCode);
    }

    public function update(Request $request, CouponCode $couponCode)
    {
        $validator = validator()->make($request->all(), [

            'discount' => 'required|numeric|min:0',
            'allowed_apply_count' => 'required|integer|min:1',
            'coupon' => 'required|string',
        ]);

        if ($validator->fails()) {
            Alert::toast($validator->errors()->first(), 'error');
            return redirect()->back();
        }

        $couponCode->discount = $request->discount;
        $couponCode->allowed_apply_count = $request->allowed_apply_count;
        $couponCode->coupon = strtoupper($request->coupon);
        $couponCode->save();




        if($couponCode->course_id != null){
            Alert::toast('Coupon code updated successfully', 'success');
            return redirect()->route('admin.courses.show',$couponCode->course_id);
        }else{
            Alert::toast('Coupon code updated successfully', 'success');
            return redirect()->route('admin.workshops.show',$couponCode->workshop_id);
        }


    }


    public function destroy(CouponCode $couponCode)
    {
        $couponCode->delete();
        Alert::toast('Coupon code deleted successfully', 'success');
        return redirect()->back();
    }
}
