<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Certificate;
use App\Models\User;
use Illuminate\Http\Request;
use RealRashid\SweetAlert\Facades\Alert;

class CertificateController extends Controller
{



    public function index()
    {
        $certificates = Certificate::with(['user','course','workshop'])->orderBy('id','desc')->paginate(15);

        return view('admin.certificate.index')->with('certificates', $certificates);

    }


    public function create()
    {



    }
    public function check($number)
    {
        $check  = Certificate::where('number',$number)->count();

        if($check>0){
            $verfied = "yes";

            $cert =  Certificate::where('number',$number)->get()->first();
            $user= User::select('name')->where('id',$cert->user_id)->get()->first();
            $name = $user->name;
        }else{
            $verfied = "no";
            $name = "";
        }

        return view('admin.certificate.check')->with('name',$name)->with('number',$number)->with('verfied',$verfied);



    }
   public function checkPost(Request $request)
    {
        $check  = Certificate::where('number',$request->number)->count();

        if($check>0){
            $verfied = "yes";

            $cert =  Certificate::where('number',$request->number)->get()->first();
            $user= User::select('name')->where('id',$cert->user_id)->get()->first();
            $name = $user->name;
        }else{
            $verfied = "no";
            $name = "";
        }

        return view('admin.certificate.check')->with('name',$name)->with('number',$request->number)->with('verfied',$verfied);



    }



    public function store(Request $request)
    {
        //
    }


  public function show(Certificate $certificate)
    {
        $user_name = $certificate->user->name;
        if($certificate->course_id){
            $course_name = $certificate->course->name;
        }else{
            $course_name = $certificate->workshop->name;
        }

        $certificate_date = substr($certificate->created_at,0,10);

        return view('admin.certificate.preview-download')
            ->with('user_name',$user_name)
            ->with('course_name',$course_name)
            ->with('certificate_date',$certificate_date)
            ->with('certificate_url',asset('check/'.$certificate->number));
    }




    public function edit(Certificate $certificate)
    {
        //
    }


    public function update(Request $request, Certificate $certificate)
    {
        //
    }

    public function destroy(Certificate $certificate)
    {
        // abort_if(!auth()->user()->hasPermission('delete certificate'),403,"you dont have permission to do this action");

        $certificate->delete();
        Alert::toast('Certificate removed successfully', 'success');
        return redirect()->route('admin.certificates.index');
    }
}
