<?php

namespace App;

use Illuminate\Http\Resources\Json\JsonResource;

class App_WorkshopResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [
            'id' => (int) $this->id,
            'user_id' => (int) $this->user_id,
            'category_id' => (int) $this->category_id,
            'name' => (string) $this->name,
            'description' => (string) $this->description,
            'image' => (string) $this->image,
            'pdf' => (string) $this->pdf,
            'long_video' => (string) $this->promo_link,
            'short_video' => (string) $this->short_video,

            'price' => (string) $this->price,
            'discount' => (string) $this->discount,
            'is_free' => (int) $this->is_free,

            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,

            'author_id' => (int) $this->author_id,
            'students_count' => (int) $this->students_count,
            'is_student_count' => (int) $this->is_student_count,
            'is_rated_count' => (int) $this->is_rated_count,

            'author' => $this->author ? [
                'id' => (int) $this->author->id,
                'name' => (string) $this->author->name,
                'image' => (string) $this->author->image,
                'bio' => (string) $this->author->bio,
            ] : null,
        ];

    }
}
