<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use \App\Http\Controllers\api\v1\AuthController;
use \App\Http\Controllers\api\v1\LotController;
use \App\Http\Controllers\api\v1\NotificationController;
use \App\Http\Controllers\api\v1\ReportController;
use \App\Http\Controllers\api\v1\PullController;




Route::prefix('v1')->group(function () {
    // Route::post('login', [AuthController::class,  'Login']);

    //    Ready
    Route::post('send/otp/using/type/and/phone', [AuthController::class, 'checkAndSendOtp']);


    Route::post('login/with/code/and/phone', [AuthController::class, 'verifyUserPhone']);

    // Route::post('register', [AuthController::class, 'Register']);
});

Route::prefix('v1')->middleware('jwt.auth')->group(function () {

    Route::get('splash', [AuthController::class, 'splash']);
    Route::post('change/password', [AuthController::class, 'changePassword']);

    Route::get('splash', [AuthController::class, 'splash']);
    // Route::get('home', [LotController::class, 'index']);
    Route::get('my/courses', [LotController::class, 'myCourses']);
    Route::get('quiz/{id}/questions', [LotController::class, 'quizQuestions']);
    Route::get('final/{id}/exam', [LotController::class, 'getFinalExam']);
    Route::post('apply/coupon/code', [LotController::class, 'applyCode']);
    Route::post('answer/final/exam', [LotController::class, 'answerFinalQuestions']);
    Route::get('search/{keyword}/courses/{t}', [LotController::class, 'search']);

    Route::get('certificates', [LotController::class, 'getMyCertificates']);

    Route::get('check/{id}/course/result', [LotController::class, 'getStudentResult']);

    Route::post('rate/course', [LotController::class, 'rateCourse']);

    Route::get('questions', [LotController::class, 'questions']);

    Route::get('course/{courseId}/raters', [LotController::class, 'raters']);
    Route::get('course/{courseId}/content', [LotController::class, 'content']);
    Route::post('apply/workshop/code', [LotController::class, 'applyWorkShopCode']);

    Route::get('notification', [NotificationController::class, 'index']);

    Route::post('reports', [ReportController::class, 'storeReport']);
    Route::post('profile/update', [AuthController::class, 'changeImage']);

    Route::post('/join/request', [LotController::class, 'createJoinReq']);

    Route::post('/discussions', [LotController::class, 'storeDiscuss']);
    Route::get('/courses/{course_id}/discussions', [LotController::class, 'getDiscuss']);
    Route::get('/discussions/{id}/delete', [LotController::class, 'deleteDiscuss']);

    Route::controller(LotController::class)->group(function () {

         // The index route
         Route::get('/home', 'index');

        // Get all parents Categories
        Route::get('/category/all-parents', 'categoryParents');

        // Get Courses By Category
        Route::get('/category/{id}/courses', 'categoryCourses');

        // Get Workshops By Category
        Route::get('/category/{id}/workshops', 'categoryWorkshops');

    });

    // Get Courses By Category
    // Route::get('/category/{id}/courses', [LotController::class, 'categoryCourses']);

    // Route::get('/category/{id}/workshops', [LotController::class, 'categoryWorkshops']);

    // Route::get('/category/all-parents', [LotController::class, 'categoryParents']);
});
