<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Admin\AuthController;
use App\Http\Controllers\Admin\HomeController;
use App\Http\Controllers\Admin\SettingController;
use App\Http\Controllers\Admin\UserController;
use App\Http\Controllers\Admin\NotificationController;
use App\Http\Controllers\Admin\CategoryController;
use App\Http\Controllers\Admin\CourseController;
use App\Http\Controllers\Admin\WorkshopController;
use App\Http\Controllers\Admin\ChatController;
use App\Http\Controllers\Admin\QuestionAnswerController;
use App\Http\Controllers\Admin\CouponCodeController;
use App\Http\Controllers\Admin\FileManagerController;



Route::get('/',function (){
    return view('front.index');
});

Route::get('/f/courses',function (){
    return view('front.course');
});
Route::get('/team',function (){
    return view('front.team');
});

Route::get('/about',function (){
    return view('front.about');
});

Route::get('/f/workshops',function (){
    return view('front.workshop');
});
Route::group(['prefix'=>'admin'],function (){

    Route::get('login',[AuthController::class,'index'])->name('admin.login');
    Route::post('login',[AuthController::class,'login'])->name('admin.auth.login');

});
Route::get('admin/logout',[AuthController::class,'logout'])->name('admin.logout');
Route::group(['middleware'=>['admin-authed','not-blocked','language-middleware'],'prefix'=>'admin'],function (){



    Route::get('/home', [HomeController::class, 'index'])->name('admin.home');
    Route::get('/statistics', [HomeController::class, 'statistics'])->name('admin.statistics');
    
    
    Route::get('single/user/{id}/edit', [UserController::class, 'editSingleUser'])->name('admin.edit.single.users');
    Route::put('update/single/user', [UserController::class, 'updateUser'])->name('admin.update.single.users');


    Route::resource('notifications',  NotificationController::class, ['as' => 'admin']);
    Route::get('to/user/{user_id}/notifications', [NotificationController::class, 'toUser'])->name('admin.notifications.touser');
    


    Route::resource('users',  UserController::class, ['as' => 'admin']);

    Route::get('profile', [UserController::class, 'profile'])->name('admin.users.profile');


    Route::post('process/user/wallet', [UserController::class, 'processWallet'])->name('admin.process.user.wallet');
    Route::get('profile/up/date', [UserController::class, 'updateImage'])->name('admin.users.profile.up.date');

    Route::post('profile', [UserController::class, 'updateProfile'])->name('admin.profile');

    // categories
    Route::resource('categories',  CategoryController::class, ['as' => 'admin']);

    // courses
    Route::resource('courses',  CourseController::class, ['as' => 'admin']);
    Route::get('courses/contents/{courseId}/list', [CourseController::class, 'content'])->name('admin.courses.content');
    Route::get('courses/quiz/{quizId}/show', [CourseController::class, 'showQuiz'])->name('admin.courses.quiz.show');
    Route::get('courses/students/{course_id}/show', [CourseController::class, 'students'])->name('admin.courses.students.show');
    Route::get('courses/exam/{course_id}/show', [CourseController::class, 'exam'])->name('admin.courses.exam');
    Route::get('courses/{id}/toggle/{state}', [CourseController::class, 'toggleCourse'])->name('admin.courses.toggle');
    
    
    Route::get('courses/{id}/join/reqs', [CourseController::class, 'joinReqs'])->name('admin.courses.joins');
    Route::get('workshops/{id}/join/reqs', [WorkshopController::class, 'joinReqs'])->name('admin.workshops.joins');
    
     Route::get('workshops/{id}/toggle/{state}', [WorkshopController::class, 'toggleWorkshop'])->name('admin.workshops.toggle');

    
     // coupon_codes
    Route::resource('coupon_codes',  CouponCodeController::class, ['as' => 'admin']);

   // students
    Route::resource('students',  \App\Http\Controllers\Admin\StudentController::class, ['as' => 'admin']);
       Route::get('students/{id}/final/exam', [\App\Http\Controllers\Admin\StudentController::class, 'finalExam'])->name('admin.students.final.exam');
    Route::get('students/{id}/generate/certificate', [\App\Http\Controllers\Admin\StudentController::class, 'generateCert'])->name('admin.students.generate.certificate');



    // workshops
    Route::resource('workshops',  WorkshopController::class, ['as' => 'admin']);
    Route::get('workshops/{id}/students/list', [WorkshopController::class, 'studentList'])->name('admin.workshops.students');



    // question-answers
    Route::resource('question-answers',  QuestionAnswerController::class, ['as' => 'admin']);


    // course_contents
    Route::resource('course_contents',  \App\Http\Controllers\Admin\CourseContentController::class, ['as' => 'admin']);

    // lessons
    Route::resource('lessons',  \App\Http\Controllers\Admin\LessonController::class, ['as' => 'admin']);
   // lessons
    Route::resource('course_tests',  \App\Http\Controllers\Admin\CourseTestController::class, ['as' => 'admin']);

    // quiz_questions
    Route::resource('quiz_questions',  \App\Http\Controllers\Admin\QuizQuestionController::class, ['as' => 'admin']);

    // text_questions
    Route::resource('text_questions',  \App\Http\Controllers\Admin\TextQuestionController::class, ['as' => 'admin']);

    // settings
    Route::resource('settings',  SettingController::class, ['as' => 'admin']);
    Route::post('settings/about/store', [SettingController::class, 'storeAbout'])->name('admin.settings.store.about');
    Route::get('settings/about/show', [SettingController::class, 'showAbout'])->name('admin.settings.show.about');

    //chats

    Route::get('chats', [ChatController::class, 'index'])->name('admin.chats.index');
    
    
     Route::resource('join_reqs',\App\Http\Controllers\Admin\JoinReqController::class, ['as' => 'admin']);
    
    // certifications
    Route::resource('certifications',  \App\Http\Controllers\Admin\CertificateController::class, ['as' => 'admin']);
 // certifications
    Route::resource('certificates',  \App\Http\Controllers\Admin\CertificateController::class, ['as' => 'admin']);


    
    
    Route::get('set/language/{lang}', [UserController::class, 'setLanguage'])->name('admin.languages.changer');
    
    
    Route::get('files', [FileManagerController::class, 'index'])->name('admin.files.index');
    Route::post('files/upload', [FileManagerController::class, 'upload'])->name('admin.files.upload');
    Route::delete('files/{file}', [FileManagerController::class, 'delete'])->name('admin.files.delete')->where('file', '.*');
    Route::post('files/{file}/rename', [FileManagerController::class, 'rename'])->name('admin.files.rename')->where('file', '.*');
    Route::get('files/{file}/download', [FileManagerController::class, 'download'])->name('admin.files.download')->where('file', '.*');
    
    Route::get('folder/files/{folder}/list', [FileManagerController::class, 'listFiles'])->name('admin.files.in.folders')->where('folder', '.*');
    Route::get('folder/indexed/{folder}/list', [FileManagerController::class, 'indexedFolder'])->name('admin.indexed.folders')->where('folder', '.*');
    
    
    Route::post('files/create-folder', [FileManagerController::class, 'createFolder'])->name('admin.files.create_folder');
    Route::delete('folders/{folder}', [FileManagerController::class, 'deleteFolder'])->name('admin.files.delete_folder')->where('folder', '.*');
});



Route::get('client/certificates/{certificate}', [\App\Http\Controllers\Admin\CertificateController::class,'show'] )->name('certificate.show');

Route::get('check/{number}/', [ \App\Http\Controllers\Admin\CertificateController::class, 'check'])->name('check');
Route::post('check/', [ \App\Http\Controllers\Admin\CertificateController::class, 'checkPost'])->name('check_post');


Route::get('privacy-policy',function(){return view('privacy-policy');});
