<div>


    <div class="modal modal-blur fade" wire:ignore="self" id="modal-simple" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">@lang('admin.change_role')</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <label class="form-label">@lang('admin.roles')</label>
                    <select class="form-select" id="select_role">
                        @foreach($roles as $role)
                            <option value="{{$role->id}}">{{$role->name}}</option>
                        @endforeach
                    </select>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn me-auto" data-bs-dismiss="modal" wire:click="selectedId(0)">@lang('admin.close')</button>
                    <button type="button" class="btn btn-primary" data-bs-dismiss="modal" wire:click="updateUserRole(document.getElementById('select_role').value)">@lang('admin.save_changes')</button>
                </div>
            </div>
        </div>
    </div>








        <div class="row mt-2">

            <div class="col-lg-12 col-md-12 col-sm-12">
                <div class="card card-rounded">
                    <div class="card-body">


                        <div class="filter-wrapper bg-gray p-2 rounded text-left m-lg-0 m-md-0 ms-0 d-flex align-items-center justify-content-start flex-lg-nowrap flex-sm-wrap flex-wrap mb-3 gap-2">
                            <input wire:model.debounce.300ms="search" type="text" class="form-control mr-lg-2" placeholder="@lang('admin.search_users')">

                            <select wire:model="orderBy" class="form-select ml-2 mr-lg-2 mt-lg-0 mt-sm-2 mt-2" id="grid-state">
                                <option value="id">@lang('admin.id')</option>
                                <option value="name">@lang('admin.name')</option>
                                <option value="email">@lang('admin.email')</option>
                                <option value="created_at">@lang('admin.sign_up_date')</option>
                            </select>

                            <select wire:model="role" class="form-select ml-2 mr-lg-2 mt-lg-0 mt-sm-2 mt-2" id="grid-state">
                                <option value="0">@lang('admin.all_roles')</option>
                                @foreach($roles as $role)
                                    <option value="{{$role->id}}">{{$role->name}}</option>
                                @endforeach
                            </select>

                            <select wire:model="orderAsc" class="form-select ml-2 mr-lg-2 mt-lg-0 mt-sm-2 mt-2" id="grid-state">
                                <option value="1">@lang('admin.ascending')</option>
                                <option value="0">@lang('admin.descending')</option>
                            </select>

                            <select wire:model="perPage" class="form-select ml-2 mt-lg-0 mt-sm-2 mt-2" id="grid-state">
                                <option>@lang('admin.per_page_10')</option>
                                <option>@lang('admin.per_page_25')</option>
                                <option>@lang('admin.per_page_50')</option>
                                <option>@lang('admin.per_page_100')</option>
                            </select>
                        </div>


                        <div class="table-responsive mt-2">
                            <table class="table table-vcenter card-table">
                                <thead>
                                <tr>
                                    <th>@lang('admin.id')</th>
                                    <th>@lang('admin.image')</th>
                                    <th>@lang('admin.name')</th>
                                    <th>@lang('admin.status')</th>
                                    <th>@lang('admin.role')</th>
                                    <th>@lang('admin.email')</th>
                                    <th>@lang('admin.phone')</th>
                                    <th>@lang('admin.online')</th>
                                    <th>@lang('admin.created_at')</th>
                                    <th>@lang('admin.actions')</th>
                                </tr>
                                </thead>
                                <tbody>


                                @foreach($users as $user)
                                    <tr>
                                        <td  >{{ $user->id }}</td>
                                        <td  style="width: 6%;">
                                            @if($user->image != "profiles/big_circle_user.png")

                                                <span class="avatar" style="background-image: url({{asset($user->image)}})"></span>
                                            @else
                                                <span class="avatar">{{ substr($user->name,0,2)}}</span>
                                            @endif
                                        </td>
                                        <td >{{ $user->name }}</td>
                                      <td>
    @if($user->block == 0)
        <span class="badge bg-success me-1"></span>
        <p class="d-inline-block p-0 m-0 font-weight-bold">{{ __('admin.active') }}</p>
    @else
        <span class="badge bg-danger me-1"></span>
        <p class="d-inline-block p-0 m-0 font-weight-bold">{{ __('admin.blocked') }}</p>
    @endif
</td>
                                        <td  class="text-role  @if($user->role_id != 1) text-warning font-weight-bold @endif ">{{ $user->role->name }}</td>
                                        <td  >{{ $user->email }}</td>
                                        <td  >{{ $user->phone }}</td>


                                        <td  >
                                            @if($user->online == 1)
                                                <span class="badge bg-success me-1"></span>  <p class="d-inline-block  p-0 m-0 font-weight-bold">   </p>
                                            @else
                                                <span class="badge bg-gray me-1"></span>  <p class="d-inline-block   p-0 m-0 font-weight-bold">   </p>
                                            @endif
                                        </td>



                                        <td  >{{ $user->created_at->diffForHumans() }}</td>
                                        <td>
                                                <span class="dropdown">
                                                    <button class="btn dropdown-toggle align-text-top" data-bs-boundary="viewport" data-bs-toggle="dropdown">@lang('admin.actions')</button>
                                                    <div class="dropdown-menu dropdown-menu-end">
                                                        @if($user->block=="0")
                                                            <button type="button" class="dropdown-item text-drop-down" wire:click="blockUser({{$user->id}})">@lang('admin.block')</button>
                                                        @else
                                                            <button type="button" class="dropdown-item text-drop-down" wire:click="unBlockUser({{$user->id}})">@lang('admin.unblock')</button>
                                                        @endif
                                                       
                                                        <button type="button" class="dropdown-item text-drop-down"   onclick="edit('{{$user->id}}')">تعديل</button>
                                                        <button type="button" class="dropdown-item text-drop-down" data-bs-toggle="modal" data-bs-target="#modal-simple" wire:click="selectedId({{$user->id}})">@lang('admin.change_role')</button>
                                                       
                                                       
                                                        <button type="button" class="dropdown-item text-drop-down" wire:click="deleteUser({{$user->id}})">@lang('admin.delete')</button>
                                                        
                                                        
                                                    </div>
                                                </span>
                                        </td>
                                    </tr>
                                @endforeach


                                </tbody>
                            </table>
                        </div>

                        <div class="row mt-3">



                        {!! $users->links() !!}

                        </div>
                    </div>

                </div>

            </div>

        </div>



</div>
