@extends('layouts.tabler-vertical')
@section('title', 'Admin Settings')

@section('header-top')

    @include('layouts.inc.top-large-bar')
    <div class="page-wrapper ">
        <div class="wrapper">
            <!-- Page title -->
            <div class="page-header d-print-none">
                <div class="row align-items-center">
                    <div class="col">
                        <!-- Page pre-title -->

                        <h2 class="page-title">
                            إدارة الملفات
                        </h2>
                    </div>
                    <!-- Page title actions -->
                    <div class="col-auto ms-auto d-print-none">




                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('content')
    <div class="wrapper ">
        <div class="row">

            @if (session('success'))
                <div class="col-12">
                    <div class="alert alert-success" role="alert">
                        <h4 class="alert-title">Success</h4>
                        <div class="text-muted">{{ session('success') }}</div>
                    </div>
                </div>
            @endif
            @if (session('error'))
                <div class="alert alert-danger" role="alert">
                    <h4 class="alert-title">Error&hellip;</h4>
                    <div class="text-muted">{{ session('error') }}</div>
                </div>
            @endif

            <div class="col-lg-12 col-md-12 col-sm-12">

                <div class="card">
                    <div class="card-body">
                        <h1>إنشاء مجلدات</h1>
                        <p>{{ str_replace('Virtual Court/', '', $folder) }} </p>

                        <form action="{{ route('admin.files.create_folder') }}" method="POST" class="form-inline">
                            @csrf
                            <div class="row">
                                <div class="col-lg-10 col-md-9 col-sm-12">
                                    <div class="form-group mb-2">
                                        <input type="text" class="form-control" name="folder_name"
                                            placeholder="New Folder Name" required>
                                        <input type="text" class="form-control " name="dir"
                                            value="{{ $folder }}" hidden>
                                    </div>
                                </div>
                                <div class="col-lg-2 col-md-3 col-sm-12">
                                    <button type="submit" class="btn btn-primary mb-2 ml-2">إنشاء مجلد جديد</button>
                                </div>
                            </div>


                        </form>


                        <!-- Upload Form -->
                        <br />

                        <h2>المجلدات الحالية</h2>


                        <div class="col-12">
                            <div class="card">
                                <div class="table-responsive">
                                    <table class="table table-vcenter card-table">
                                        <thead>
                                            <tr>
                                                <th>اسم المجلد</th>
                                                <th>تصفح</th>
                                                <th>حذف</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach ($directories as $directory)
                                                <tr>
                                                    <td> {{ str_replace('Virtual Court/workshop/', '', str_replace('Virtual Court/courses/', '', $directory)) }}
                                                    </td>
                                                    <td class="text-muted">
                                                        <a class="btn btn-primary"
                                                            href="{{ route('admin.files.in.folders', rawurlencode($directory)) }}">تصفح</a>
                                                    </td>

                                                    <td>

                                                        <form
                                                            action="{{ route('admin.files.delete_folder', rawurlencode($directory)) }}"
                                                            method="POST" style="display:inline;">
                                                            @csrf
                                                            @method('DELETE')
                                                            <button class="btn btn-red" type="submit">حذف المجلد</button>
                                                        </form>

                                                    </td>
                                                </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>






                    </div>

                </div>
            </div>
        </div>

        {{--        modals --}}


        {{--        edit modal --}}

        <div class="modal modal-blur fade" id="edit-modal" tabindex="-1" role="dialog" aria-hidden="true">
            <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
                <div class="modal-content" id="edit-modal-content">

                </div>
            </div>
        </div>

        @include('components.remove-modal')
    @endsection

    @push('scripts')
        <script>
            const dropdowns = document.querySelectorAll('.dropdown-toggle')
            const dropdown = [...dropdowns].map((dropdownToggleEl) => new bootstrap.Dropdown(dropdownToggleEl, {
                popperConfig(defaultBsPopperConfig) {
                    return {
                        ...defaultBsPopperConfig,
                        strategy: 'fixed'
                    };
                }
            }));

            let loader = `@include('components.loader')`;

            function edit(id) {
                $("#edit-modal-content").html(loader);
                $('#edit-modal').modal('show');
                $("#edit-modal-content").load(`admin/categories/${id}/edit`);
            }


            function setDir(dir) {
                // Use querySelectorAll for more modern and efficient element selection
                const elements = document.querySelectorAll('.direc');

                if (elements.length === 0) {
                    console.warn("No elements found with class 'direc'.");
                    return; // Exit the function if no elements are found
                }

                if (dir.toLowerCase() === 'rtl') {
                    elements.forEach(element => element.setAttribute('dir', 'rtl'));
                } else if (dir.toLowerCase() === 'ltr') {
                    elements.forEach(element => element.setAttribute('dir', 'ltr'));
                } else {
                    console.warn("Invalid direction specified. Please use 'rtl' or 'ltr'.");
                }
            }
        </script>
        <script>
            function deleteRecord(action) {
                console.log(action)
                $("#remove-form").attr('action', action);
                $("#modal-danger").modal('show');
            }
        </script>
    @endpush
